/*
 *	xorline.c  --  draw a line exoring the color with the background.
 *		       works with EGA in Turbo C EGAHI mode.
 *
 *	Turbo C graphics settings are not affected.
 *	The first video page is used (at 0xa000).
 *	The coordinates are inclusive (both end points are drawn).
 *	Anything outside the screen is not drawn.
 *
 *	29 june 1989  Olle Olsson.
 */

#include <graphics.h>		/* for getmax?() */
#include "egatc.h"

#define LIMIT_CHECK 1		/* check screen limits */

/*#define LPATT 1		/* for patterned lines */

#ifdef LPATT
#define SOLID 0xff */
static char linmod = SOLID;		/* default solid */
#endif

/* local functions */
void setxor( int color );
void unsetxor( void );

/* make inline code for speed */
#define XPT( x, y )			                        \
	{                                                       \
	bmask = bitmask( x );                                   \
	LOADGR( E_BM, bmask );		                        \
	offset = maddr( x, y );         			\
	pokeb( EGASEG, offset, peekb( EGASEG, offset ) );	\
	}

void xorline( int x0, int y0, int x1, int y1, int color )
{
int dx, dy;
int xinc, yinc;
int res1;
int res2;
#ifdef LPATT
int slope;
#endif
register unsigned char bmask;
register short offset;
#ifdef LIMIT_CHECK
int mx, my;			/* maximum */

/* limits check */
mx = getmaxx();
my = getmaxy();

if ((x0 < 0 && x1 < 0) || (x0 > mx && x1 > mx))
	return;

if ((y0 < 0 && y1 < 0) || (y0 > my && y1 > my))
	return;
#endif

/* setup */
setxor( color );

#ifdef traceon
if (trace > 1)
	fprintf( stderr, "Line (%d, %d) to (%d, %d)\n", x0, y0, x1, y1 );
#endif

/* setup */
#ifdef LPATT
slope =
#endif
xinc = yinc = 1;

if ((dx = x1 - x0) < 0)
	{
	xinc = -1;
	dx = -dx;
#ifdef LPATT
	slope = -1;
#endif
	}

if ((dy = y1 - y0) < 0)
	{
	yinc = -1;
	dy = -dy;
#ifdef LPATT
	slope = -slope;
#endif
	}

res1 = res2 = 0;

/* fill in x or y direction? */
if (dx >= dy) while (x0 != x1)
	{
#ifdef LIMIT_CHECK
	if (x0 >= 0 && x0 <= mx && y0 >= 0 && y0 <= my)
		{
#ifdef LPATT
		/* could be dotted or dashed */
		if (linmod == SOLID)
			XPT( x0, y0 );
		else if ((x0 + slope * y0) & linmod)
#endif
			XPT( x0, y0 );
		}
#else
	/* could have LPATT here too */
	XPT( x0, y0 );
#endif

	/* increment for next */
	if (res1 > res2)
		{
		res2 += dx - res1;
		res1 = 0;
		y0 += yinc;

#ifdef LIMIT_CHECK
		/* limit check */
		if (yinc > 0)
			{
			if (y0 > my)
				return;
			}
		else if (y0 < 0)
			return;
#endif
		}

	res1 += dy;
	x0 += xinc;

#ifdef LIMIT_CHECK
	/* limit check */
	if (xinc > 0)
		{
		if (x0 > mx)
			return;
		}
	else if (x0 < 0)
		return;
#endif
	}
else while (y0 != y1)
	{
	/* same as above but y instead of x */
#ifdef LIMIT_CHECK
	if (x0 >= 0 && x0 <= mx && y0 >= 0 && y0 <= my)
		{
#ifdef LPATT
		if (linmod == SOLID)
			XPT( x0, y0 );
		else if ((x0 + slope * y0) & linmod)
#endif
			XPT( x0, y0 );
		}
#else
	/* could have LPATT here too */
	XPT( x0, y0 );
#endif

	if (res1 > res2)
		{
		res2 += dy - res1;
		res1 = 0;
		x0 += xinc;

#ifdef LIMIT_CHECK
		/* limit check */
		if (xinc > 0)
			{
			if (x0 > mx)
				return;
			}
		else if (x0 < 0)
			return;
#endif
		}

	res1 += dx;
	y0 += yinc;

#ifdef LIMIT_CHECK
	/* limit check */
	if (yinc > 0)
		{
		if (y0 > my)
			return;
		}
	else if (y0 < 0)
		return;
#endif
	}

/* last point */
#ifdef LPATT
if (linmod == SOLID)
	XPT( x1, y1 );
else if ((x1 + slope * y1) & linmod)
#endif
	XPT( x1, y1 );

/* restore */
unsetxor();
}

void xorpoint( int x, int y, int color )
{
unsigned char bmask;
short offset;

#ifdef LIMIT_CHECK
if (x < 0 || y < 0 || x > getmaxx() || y > getmaxy())
	return;
#endif

/* setup */
setxor( color );

/* do it */
XPT( x, y );

/* restore */
unsetxor();
}


/* local functions */
void setxor( int color )
{
/* setup for xorline(), except for bit mask register */
LOADGR( E_SR, color );		/* colour to SET/RESET reg */
LOADGR( E_ESR, 0x0f );		/* enable SET/RESET all planes */
LOADGR( E_RF, F_XOR );		/* xor function */

}

void unsetxor( void )
{
/* restore from setxor() */
LOADGR( E_BM, 0xff );		/* restore BITMASK */
LOADGR( E_ESR, 0 );		/* disable all planes */
LOADGR( E_RF, F_UNMOD );	/* disable xor function */
}

