/*
 *	wdescr.c  --  write an if description to file.
 *
 *	8 july 1989  Olle Olsson.
 */

#include "ifs.h"


void wdescr( of, dp, com, show )
FILE *of;			/* input file */
ifsdes *dp;			/* descriptor to be filled */
char *com;			/* comment to write */
int show;			/* trace flag */
{
transform *tp;
int i;

/* write the comment */
fprintf( of, "%c %s\n\n", COMMENTCH, com );

/* 1st line: write size, density and im mode */
fprintf( of, "%c transformation count; density; inv.meas.mode\n", COMMENTCH );
fprintf( of, "%15d %15f %15d\n\n", dp -> size, dp -> density, dp -> im );

/* 2nd line: the plot area */
fprintf( of, "%c x0  xlen  y0  ylen\n", COMMENTCH );
fprintf( of, "  %g %g %g %g\n\n",
	dp -> area.xlow, dp -> area.xlen,
	dp -> area.ylow, dp -> area.ylen );

/* 3rd..3+size lines: the transformations */
fprintf( of, "%c a11  a12   a21   a22   b1    b2    pr   color group\n",
							 COMMENTCH );
for (tp = dp -> tp, i = 0; i < dp -> size; ++tp, ++i)
	{
	fprintf( of, "%g %g %g %g %g %g %g %d %d\n",
		tp -> a11, tp -> a12, tp -> a21, tp -> a22,
		tp -> b1, tp -> b2, tp -> prob,
		tp -> color, tp -> group );
	}

fprintf( of, "\n" );

/* the palette */
fprintf( of, "%c colors (r,g,b)   (the first is the background)\n",
								 COMMENTCH );
for (i = 0; i < dp -> clrsize; ++i)
	{
	fprintf( of, "%d %d %d\n",
		dp -> colors[i].r, dp -> colors[i].g, dp -> colors[i].b );
	}

if (show)
	printf( "wdescr ok\n" );

}


