/*
 *	vsbif.c  --  view a simple binary image file.
 *
 *	25 july 1989  Olle Olsson.
 */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <conio.h>
#include <io.h>
#include <string.h>
#include <process.h>
#include <dos.h>
#include "sbif.h"
#include "egargb.h"	/* for the initshow() prototype */

/* stop character (if more than one screen) */
#define ESC '\033'

/* plot size */
#define MAX_COL	(max_x_coord)
#define MAX_ROW	(max_y_coord)

/* globals */
extern int grmode;			/* mode for setgraphmode() */
extern int max_x_coord, max_y_coord;	/* screen max x & y */

/* the functions */
void main( int argc, char *argv[] );
void beep( void );
void error( char *s, ... );
void warning( char *s, ... );
void usage( void );

static void usage( void )
{
fprintf( stderr, "Usage:\n" );
fprintf( stderr, "\tvsbif [options] sbif_file\n" );
fprintf( stderr, "Options are:\n" );
fprintf( stderr, "\t-x num\tx offset\n" );
fprintf( stderr, "\t-y num\ty offset\n" );
fprintf( stderr, "\n" );
}


void main( argc, argv )
int argc;
char *argv[];
{
register unsigned char mask;	/* pixel bit mask */
register int x, y;		/* current x, y */
unsigned char *vp;		/* pixel byte pointer */
FILE *inf;			/* data file */
int xlines, ylines;		/* x and y pixel count */
int xbytes;			/* x byte count */
unsigned char *pmat;		/* the pixel matrix (part of it) */
int xoffs, yoffs;		/* display offsets */
int trace;			/* trace flag */
int i, c;			/* tmp */
char datafile[100];		/* data file name */
char *ap, **p;			/* argument pointers */
char hbuf[SBHSIZE];		/* buffer for the sbif header */
char nbuf[100];			/* buffer for the name in the sbif header */

/* read arguments */
datafile[0] = '\0';
trace = 0;
xoffs = yoffs = 0;
for (p = argv + 1, c = 1; c < argc; ++c)
	{
	if (trace) printf( "%s:\n", *p );
	ap = *p++;

	if (*ap == '-')	for (i = 1; ap[i]; ++i) switch (ap[i])
		{

		case 'x':	/* x offset */
			if (++c >= argc)
				error( "-x: offset missing");

			xoffs = atoi( *p++ );

			if (xoffs <= 0)
				error( "-x: offset <= 0" );

			continue;

		case 'y':	/* y offset */
			if (++c >= argc)
				error( "-y: offset missing");

			yoffs = atoi( *p++ );

			if (yoffs <= 0)
				error( "-y: offset <= 0" );

			continue;

		case 't':
			trace++;
			continue;

		default:
			usage();
			error( "don't understand flag '-%c'", ap[i] );
		}
	else if (!datafile[0])
		{
		strcpy( datafile, ap );
		}
	else
		{
		usage();
		error( "too many data files specified" );
		}
	}

/* open the data file */
if (!datafile[0])
	error( "No SBIF data file specified" );

if ((inf = fopen( datafile, "rb" )) == NULL)
	error( "Can't open input file '%s'", datafile );


/* read the header */
if (fread( hbuf, sizeof( hbuf ), 1, inf ) < 1)
	error( "premature end of file '%s'", datafile );

/* read the sizes */
xlines = ylines = 0;
sscanf( hbuf, "%s %d %d", nbuf, &xlines, &ylines );
xbytes = XBYTES( xlines );

if (trace) fprintf( stderr, "%s x:%d y:%d (offs %d, %d xbytes:%d)\n",
			 nbuf, xlines, ylines, xoffs, yoffs, xbytes );

if (xlines <= 0 || ylines <= 0)
	error( "don't understand contents of file '%s'", datafile );

/* get a buffer for one row of the pixel matrix */
if (!(pmat = (unsigned char *) calloc( xbytes, 1 )))
	error( "out of memory for the pixel matrix" );

/* skip the offset */
ylines -= yoffs;
for (y = 0; y < yoffs; ++y)
	if (fread( pmat, xbytes, 1, inf ) < 1)
		error( "premature end of file '%s'", datafile );

/* go to graphic mode */
if (trace)
	{
	fprintf( stderr, "press any key to go to graphic mode",
				ylines );
	getch();
	}

initshow();

/* show the picture */
for (; ylines > 0; ylines -= MAX_ROW + 1)
    {
    /* show one screenfull */
    for (y = 0; y < ylines && y <= MAX_ROW; ++y)
	{
	/* read one line */
	if (fread( pmat, xbytes, 1, inf ) < 1)
		{
		printf( "end at line %d (%d bytes) ", y + 1, xbytes * (y + 1) );
		sleep( 5 );
		endshow();
		error( "premature end of file '%s'", datafile );
		}

	if (trace) putpixel( 0, MAX_ROW - y, EGA_RED );

	for (x = 0, mask = 0x80, vp = pmat; x < xlines; ++x, mask >>= 1)
		{
		if (!mask)
			{
			/* next byte */
			++vp;
			mask = 0x80;
			}

		/* check x offset */
		if (x < xoffs)
			continue;

		/* show the pixel if it is on */
		if (!(*vp & mask))
			continue;

		/* (y is upside down, but so is the screen y coordinate) */
		putpixel( x - xoffs, y, EGA_LIGHTGRAY );
		}
	}

    /* wait for a key */
    if (getch() == ESC)
	break;

    /* if there is another screen */
    cleardevice();
    }

/* ready */
endshow();
exit( 0 );
}



void error( s, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10 )
char *s;
int v1, v2, v3, v4, v5, v6, v7, v8, v9, v10;
{
fprintf( stderr, "\nError:" );
fprintf( stderr, s, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10 );
fprintf( stderr, "\n" );

exit( 2 );
}

void warning( s, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10 )
char *s;
int v1, v2, v3, v4, v5, v6, v7, v8, v9, v10;
{
fprintf( stderr, "\nWarning:" );
fprintf( stderr, s, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10 );
fprintf( stderr, "\n" );
}


