/*
 *	rdescr.c  --  read an ifs description file.
 *
 *	4 june 1989  Olle Olsson
 */

#include <stdlib.h>
#include <ctype.h>
#include "ifs.h"

static char *getline( FILE *infile, char *inbuffer, int buffersize,
						 int eof_fail );

void rdescr( inf, dp, show )
FILE *inf;			/* input file */
ifsdes *dp;			/* descriptor to be filled */
int show;			/* trace flag */
{
transform *tp;
int i;
char buf[200];

/* 1st line: read size, density and im mode */
dp -> size = dp -> density = dp -> im = 0;
(void) getline( inf, buf, sizeof( buf ), 1 );
sscanf( buf, "%d %lf %d", &dp -> size, &dp -> density, &dp -> im );

/* copy the im value to the previous value */
dp -> im_prev = dp -> im;

/* */
if (show) printf( "Size %d, density %g, imm %d\n",
		 dp -> size, dp -> density, dp -> im );
/* */

if (dp -> size <= 0)  error( "Size zero  --  no transformations" );
if (dp -> density <= 0) error( "Density zero  --  no calculations" );

if (dp -> size > dp -> maxsize)
	{
	warning( "Max number of transformations (%d) exeeded: %d",
			 dp -> size, dp -> maxsize );
	}

/* 2nd line: read the plot area */
(void) getline( inf, buf, sizeof( buf ), 1 );
sscanf( buf, "%lf %lf %lf %lf",
	&dp -> area.xlow, &dp -> area.xlen,
	&dp -> area.ylow, &dp -> area.ylen );

/* 3rd..3+size lines: read the transformations */
for (tp = dp -> tp, i = 0; i < dp -> size; ++tp, ++i)
	{
	(void) getline( inf, buf, sizeof( buf ), 1 );

	/* skip the execessive transforms */
	if (i >= dp -> maxsize )
		continue;

	sscanf( buf, "%lf %lf %lf %lf %lf %lf %lf %d %d",
		&tp -> a11, &tp -> a12, &tp -> a21, &tp -> a22,
		&tp -> b1, &tp -> b2, &tp -> prob,
		&tp -> color, &tp -> group );
	}
/* */
if (show) printf( "area %lf %lf %lf %lf\n",
	dp -> area.xlow, dp -> area.xlen, dp -> area.ylow, dp -> area.ylen );

if (show) for (tp = dp -> tp, i = dp -> size; i; ++tp, --i)
	printf( "%lf %lf %lf %lf %lf %lf %lf\n",
		tp -> a11, tp -> a12, tp -> a21, tp -> a22,
		tp -> b1, tp -> b2, tp -> prob );

/* */

/* read the palette */
for (i = 0; i < dp -> clrsize; ++i)
	{
	if (!getline( inf, buf, sizeof( buf ), 0 ))
		break;

	sscanf( buf, "%d %d %d", &dp -> colors[i].r, &dp -> colors[i].g,
							 &dp -> colors[i].b );
	}

if (show)
	{
	printf( "index  r g b\n" );
	for (i = 0; i < dp -> clrsize; ++i)
		{
		printf( " %d: %d %d %d;", i,
			dp -> colors[i].r, dp -> colors[i].g, dp -> colors[i].b );
		if (!((i + 1) % 4)) printf( "\n" );
		}
	printf( "\n" );
	}
}

static char *getline( f, bp, blen, failf )
FILE *f;		/* input file */
char *bp;		/* input buffer */
int blen;               /* buffer size */
int failf;		/* fail-at-eof flag */
{
register char *s;

/* read a line from f, skip comments and blank lines */
for (*bp = '\0';;)
	{
	if (fgets( bp, blen, f ) == NULL)
		{
		if (failf)
			error( "premature end of input file" );

		return (0);
		}

	/* comment ? */
	if (bp[0] == COMMENTCH)
		continue;

	/* blank ? */
	for (s = bp; *s; ++s)
		if (!isspace( *s )) break;

	if (*s) break;
	}

/* ok */
return (bp);
}

