/*
 *	IFS.h  -- iterated function system structures and constants.
 *
 *	 4 june 1989  Olle Olsson
 */

#include <stdio.h>
#include "egargb.h"

/* data file */
#define COMMENTCH '#'		/* comment line start char */

/* plot size */
#define MAX_COL	(max_x_coord)
#define MAX_ROW	(max_y_coord)

/* ifsdes.density to iterations */
#define DENS2ITER( d )	((long) ((d) * (MAX_COL + 1L) * (MAX_ROW + 1L)))

/* iterations to ifsdes.density */
#define ITER2DENS( it )	((it) / ((MAX_COL + 1.0) * (MAX_ROW + 1.0)))

/* useful constants */
#define MAXRAND 0x7fff		/* max value from rand() */
#define MINPROB 1e-6		/* minimum probability */

typedef struct
	{
	double a11, a12;	/* one transformation matrix */
	double a21, a22;
	double b1, b2;		/* translation vector */
	double prob;		/* probability */
	int color;		/* color index */
	int group;		/* transform group index */
	} transform;

typedef struct			/* a rectangular area */
	{
	double xlow;		/* low x */
	double xlen;
	double ylow;		/* low y */
	double ylen;
	} area;

typedef struct			/* a description for showing the ifs */
	{
	transform *tp;		/* the transforms (vector) */
	int size;		/* number of (active) transforms */
	int maxsize;		/* size of the transform vector */
	double density;		/* == iterations / screen_points */
	double prrdens;		/* density from previous run */
	area area;		/* limiting area */
	rgb *colors;		/* colors (index 0 is backgr.) */
	int clrsize;		/* max number of colors */
	int textcolor;		/* color index for menus etc. */
	int im;			/* flag/size for invariant measure mode */
	int im_prev;		/* previous im size for on/off flip */
	int maxgroup;		/* maximum group number (0 is minimum) */
	} ifsdes;

/* globals */
extern int grmode;			/* mode for setgraphmode() */
extern int max_x_coord, max_y_coord;	/* screen max x & y */

/* the functions */
void main( int argc, char *argv[] );
void beep( void );
void error( char *s, ... );
void warning( char *s, ... );
void usage( void );
double dett( transform *tp );
void rdescr( FILE *infile, ifsdes *dp, int show );
void wdescr( FILE *outfile, ifsdes *dp, char *comment, int show );

void normprob( transform *tp, int size );
double grprob( transform *tp, int size, int group );
void normgprob( transform *tp, int size, int group, double group_prob );

void showtrans( transform *tp, int *probp, int size, area *ap );
void ifsshow( ifsdes *dp, int (*stop)( void ), int earlystop,
				void (far *wpix)( int x, int y, int color ),
				unsigned (far *rpix)( int x, int y ) );
void setuprgb( transform *tp, int size );
int ifsrand( ifsdes *dp, int minsize, int maxsize, int show );
int edtrans( ifsdes *dp, int trace );
void palsetup( ifsdes *dp );

