/*
 *	EGA help file for Turbo C
 *
 *
 *	5 jan 1989  Olle Olsson  Plusdata HB
 */

#include <dos.h>	/* prototype for outport() */

/* video RAM addressing */
#define EGASEG		0xa000
#define EGASEG2		(EGASEG + 0x1000)

#define EGAROWS		350
#define EGACOLS		640

#define maddr( x, y ) ( 80*(y) + ((x)>>3) )
#define bitmask( x )  ( 0x80 >> ((x)&7) )
#define mask( x )     ( 0xff - ( 0xff >> ((x)&7) ) )
#define endmask( x )  ( 0x7f >> ((x)&7) )
#define ynext( adr )  ( ((adr)+80) )
#define yprev( adr )  ( ((adr)-80) )


/* i/o ports */
#define EGAGCR	0x3ce			/* graphics controller control */
#define EGAGDR	0x3cf			/* graphics controller data */
#define EGASCR	0x3c4			/* sequencer controller control */
#define EGASDR	0x3c5			/* sequencer data */
#define EGAACR	0x3c0			/* attribute controller control */
#define EGAADR	0x3c1			/* attribute controller data */


/* internal regs graphics controller */
#define E_SR	0			/* set/reset (write mode 0) */
#define E_ESR	1			/* enable set/reset (wr md 0) */
#define E_CC	2			/* colour compare (read mode 1) */
#define E_RF	3			/* rotate/function select */
#define E_RMS	4			/* read map select (read mode 0) */
#define E_MODE	5			/* mode */
#define E_MISC	6			/* miscellaneous */
#define E_CD	7			/* colour don't care (read mode 1) */
#define E_BM	8			/* bit mask */

/* sequencer */
#define E_SMM	2			/* sequencer/map mask */

/* functions for func. sel. reg E_RF */
#define F_UNMOD	0x00			/* unmodified */
#define F_AND	0x08			/* AND with read value */
#define F_OR	0x10			/* OR */
#define	F_XOR	0x18			/* XOR */

/* register load */
#define LOADGR( r, val )	outport( EGAGCR, ((val) << 8) | r )
#define LOADSR( r, val )	outport( EGASCR, ((val) << 8) | r )
#define LOADAR( r, val )	outport( EGAACR, ((val) << 8) | r )

/* the assembler likes Uppercase */
#define movebinc MOVEBINC
#define movebrsh MOVEBRSH
#define moveblsh MOVEBLSH

void movebinc( unsigned sseg, int soffs, unsigned dseg, int doffs, unsigned nb );
void movebrsh( unsigned sseg, int soffs, unsigned dseg, int doffs,
				 unsigned nbytes, int shiftamount );
void moveblsh( unsigned sseg, int soffs, unsigned dseg, int doffs,
				 unsigned nbytes, int shiftamount );
int egacopy( int x0, int y0, int x1, int y1, int dx, int dy );

void xorline( int x0, int y0, int x1, int y1, int color );
void xorpoint( int x, int y, int color );
void ggets( char *buf );
void gputs( char *string );

