/*
 *	edcolors.c  --  edit colors.
 *
 *	11 july 1989  Olle Olsson.
 */

#include "edtrans.h"

/* minimum length of the color display box */
#define CBOXL (MAX_COL / 20)

/* local things */

static void redisptr( ifsdes *dp, transform *tp, int newcolor );

static menudescr cmenu =		/* the menu */
	{
	"quit",
	"im",
	"Max_im+", "max_im-",
	"_bg",
	"prev",
	"+index", "-index",
	"R+", "G+", "B+",
	"r-", "g-", "b-"
	};


void edcolors( ifsdes *dp )
{
int i;
struct gm_status gs;		/* mouse status */
transform *ctp;			/* current transform */
rgb *cc;			/* current color */
int vx;				/* x position for color box display */
char *fim = "im:%d (%d) ";	/* format of the im level (max) */
char *fclr = "color:%d ";	/* format of the color index */
char buf[100];			/* tmp */

/* hide the mouse pointer */
gm_hide();

/* show the menu (the caller has removed its menu) */
setcolor( dp -> textcolor );
showmenu( &cmenu );

/* assume that the menu doesn't cover all of the top line */
vx = MAX_COL - CBOXL;

/* the color box is supposed to cover the im level display */
/* (the color index string is shorter so don't bother with its length) */
sprintf( buf, fim, dp -> clrsize, dp -> clrsize );
i = MAX_COL - textwidth( buf );
if (i < vx) vx = i;

gm_show();

/* if im mode: select the second level (not backgr.), else don't select */
for (cc = dp -> im ? &dp -> colors[1] : 0, ctp = 0;;)
	{
	/* show the value */
	if (ctp && !cc)
		{
		/* previous color! */

		gm_hide();

		/* draw the color display box in background color */
		setfillstyle( SOLID_FILL, 0 );
		bar( vx, 0, MAX_COL, CBOXL );

		setcolor( dp -> textcolor );
		moveto( vx, 0 );
		gputs( "prev" );

		gm_show();
		}
	else if (cc)
		{
		gm_hide();

		/* install the new palette value  */
		setpalette( i = cc - dp -> colors, mkegacolor( cc ) );

		/* draw the color display box */
		setfillstyle( SOLID_FILL, i );
		bar( vx, 0, MAX_COL, CBOXL );

		/* im mode ? */
		if (dp -> im && (i > 0))
			{
			/* display the im level */
			sprintf( buf, fim, i, dp -> im );
			}
		else
			{
			/* display the current transforms color (or bg color) */
			sprintf( buf, fclr, i );
			}

		setcolor( dp -> textcolor );
		moveto( vx, 0 );
		gputs( buf );

		gm_show();
		}

	/* read the keyboard & mouse */
	switch (wbup(), getkey( &gs ))
		{
		case 'q':	/* quit */
			/* remove the menu */
			gm_hide();
			nomenu();
			gm_show();
			return;

		/* Upper case: increase, lower: decrease color intensity */
		case 'R': if (cc) r_incdec( cc, 1 ); break;
		case 'G': if (cc) g_incdec( cc, 1 ); break;
		case 'B': if (cc) b_incdec( cc, 1 ); break;
		case 'r': if (cc) r_incdec( cc, 0 ); break;
		case 'g': if (cc) g_incdec( cc, 0 ); break;
		case 'b': if (cc) b_incdec( cc, 0 ); break;

		case '_':	/* background */
			/* the first color is background */
			cc = dp -> colors;
			ctp = 0;

			break;

		case '+':	/* increase color or im level (index) */
			if (dp -> im > 0)
				{
				/* im mode */
				/* increase or wrap around */
				if (cc < &dp -> colors[dp -> im])
					++cc;
				else cc = &dp -> colors[1];
				}
			else if (cc)
				{
				/* color index */
				/* increase or wrap */
				/* (also affects current transform) */
				if (cc < &dp -> colors[dp -> clrsize - 1])
					{
					++cc;
					if (ctp)
						{
						/* redraw with the new color */
						redisptr( dp, ctp,
							 ctp -> color + 1 );
						}
					}
				else
					{
					/* wrap to the second color (not bg) */
					cc = &dp -> colors[1];
					if (ctp)
						{
						/* redraw with the new color */
						redisptr( dp, ctp, 1 );
						}
					}
				}
			else if (ctp)
				{
				/* previous color: select "real" color 1 */

				/* redraw with the new color */
				redisptr( dp, ctp, 1 );

				cc = &dp -> colors[ctp -> color];
				}

			break;

		case '-':	/* decrease color or im level (index) */
			if (dp -> im > 0)
				{
				/* im mode */
				/* decrease or wrap */
				/* don't decrease to background */
				if (cc <= dp -> colors)
					{
					/* go from background */
					/* select the first level */
					cc = &dp -> colors[1];
					}
				else if (cc > &dp -> colors[1])
					--cc;
				else cc = &dp -> colors[dp -> im];
				}
			else if (cc)
				{
				/* color index */
				/* decrease or wrap */
				/* (also affects current transform) */
				if (cc > &dp -> colors[1])
					{
					--cc;
					if (ctp)
						{
						/* redraw with the new color */
						redisptr( dp, ctp,
							ctp -> color - 1 );
						}
					}
				else
					{
					cc = &dp -> colors[dp -> clrsize - 1];
					if (ctp)
						{
						/* redraw with the new color */
						redisptr( dp, ctp,
							 dp -> clrsize - 1 );
						}
					}
				}
			else if (ctp)
				{
				/* previous color: select "real" color 1 */

				/* redraw with the new color */
				redisptr( dp, ctp, 1 );

				cc = &dp -> colors[ctp -> color];
				}

			break;

		case 'p':	/* previous color */
			if (dp -> im)
				beep();
			else if (ctp)
				{
				/* deselect color */
				cc = 0;

				/* -1 is previous color */

				/* redraw with the new color */
				redisptr( dp, ctp, -1 );
				}
			else beep();
			break;

		case 'i':	/* im mode flip */
			if (dp -> im)
				{
				/* im mode was on, turn off */

				/* keep the old value */
				dp -> im_prev = dp -> im;
				dp -> im = 0;

				/* select the background
				 * (to erase the im level display) */
				cc = dp -> colors;
                	        }
			else
				{
				/* im mode was off, turn on */
				/* use previous value, but only if it is > 0 */
				if ((dp -> im = dp -> im_prev) <= 0)
					dp -> im = 1;

				/* select the first im level (not backgr.) */
				cc = &dp -> colors[1];
				}

			/* no transform is selected */
			ctp = 0;

			break;

		case 'M':	/* increase im max level */
			if (dp -> im)
				{
				/* im mode */
				/* (dp -> im starts at 1) */
				if (dp -> im < dp -> clrsize - 2)
					++dp -> im;
				else beep();
				}
			else beep();

			break;

		case 'm':	/* decrease im max level */
			if (dp -> im)
				{
				/* im mode */
				if (dp -> im > 1)
					{
					--dp -> im;

					/* check current level */
					/* (dp -> im starts at 1) */
					if (cc > &dp -> colors[dp -> im])
						cc = &dp -> colors[dp -> im];
					}
				else beep();
				}
			else beep();

			break;

		case 0:		/* a mouse button */
			/* not valid if im mode */
			if (dp -> im)
				{
				beep();
				break;
				}

			/* a transform is selected, find out which one! */
			i = findtrans( dp -> tp, dp -> size, &dp -> area,
						 gs.gm_xpos, gs.gm_ypos );

			/* found it? */
			if (i < 0)
				break;	/* no */

			/* set the pointers for current color and transform */
			ctp = &dp -> tp[i];
			if (ctp -> color >= dp -> clrsize)
				{
				/* out of range */
				/* redraw with the new color */
				redisptr( dp, ctp, 1 );
				}

			if (ctp -> color < 0)
				{
				/* previous color */
				cc = 0;
				}
			else cc = &dp -> colors[ctp -> color];

			break;

		default:	/* ?? */
			break;
		}
	}
}

/* local routines */
static void redisptr( ifsdes *dp, transform *tp, int newcolor )
{
gm_hide();

/* erase */
setcolor( (tp -> color > 0) ? tp -> color : dp -> textcolor );
xdistrans( tp, &dp -> area );

/* change color and redisplay */
tp -> color = newcolor;
setcolor( (tp -> color > 0) ? tp -> color : dp -> textcolor );
xdistrans( tp, &dp -> area );

setcolor( dp -> textcolor );
gm_show();
}
