/*                        Sprite & Scrolling Engine                         */
/*           Copyright (c) Genesoft 1996.  All rights reserved.             */
/*                                                                          */
/*                      Palette Functions Header File                       */

#ifndef _SSEPAL_H_INCLUDED

/*  C++ compatibility  */

#ifdef __cplusplus
extern "C" {
#endif

#include"sse.h"

void palSetActive( palRegister * SrcPal, int Start, int Registers );

void palFadeOutActive( palRegister * SrcPal, char Speed );

void palFadeInActive( palRegister * SrcPal, char Speed );

void palCycle( palRegister * Pal, int Speed, int Registers );

void palBlendWithColor( palRegister * DestPal, palRegister * SrcPal, char Amount, palRegister * SrcReg, int Registers );

void palDarken( palRegister * DestPal, palRegister * SrcPal, char Amount, int Registers );

void palBlendPalettes( palRegister * OutPal, palRegister * PalOne, char Amount, palRegister * PalTwo, int Registers );

void palMakeGrayScale( palRegister * OutPal, palRegister * InPal, int Registers );

int palFindClosest( palRegister * Reg, palRegister * SrcPal, int Registers );

#define _SSEPAL_H_INCLUDED
#ifdef __cplusplus
};
#endif
#endif

