/* PCX routines */

#include "ldpcxtga.h"
#include <sys/farptr.h>
#include <go32.h>
#include <iostream.h>
#include <pc.h>
#include <stdio.h>
#include <stdlib.h>

#define putpixel(x,y,c) _farpokeb(_dos_ds, 0xA0000 + (y << 8) + (y << 6) + x, c)
#define set_v_mode()  asm(" movw $0x13, %ax; int $0x10 ")
#define set_t_mode()  asm(" movw $0x03, %ax; int $0x10 ")

PCXLoad::PCXLoad(char *fname)
{
  inf = fopen(fname, "rb");

  if(inf == NULL)
  {
    cout << "Could not open the file: " << fname << ".\n";
    exit(0);
  }

  fseek(inf, 8, SEEK_SET);

  Width = fgetc(inf);
  Width = ((fgetc(inf) << 8) | Width) + 1;
  Height = fgetc(inf);
  Height = ((fgetc(inf) << 8) | Height) + 1;

  Image = (char *)malloc(Width * Height);
}

PCXLoad::~PCXLoad()
{
  free(Image);
  set_t_mode();
  fclose(inf);
}

void PCXLoad::SetPal()
{
  fseek(inf, -768, SEEK_END);
  fread(Pal, 1, 768, inf);

  outportb(0x3c8, 0);
  for(int i = 0; i < 768; i++)  outportb(0x3c9, Pal[i] >> 2);
}

void PCXLoad::Load()
{
  char Temp1, Temp2;
  int X = 0, Y = 0;

  set_v_mode();
  SetPal();

  fseek(inf, 128, SEEK_SET);
  fread(Image, 1, Width * Height, inf);

  while( (Y < Height) && ( (X * Y) < (Width * Height) ) )
  {
    Temp1 = *Image;
    Image++;

    if((Temp1 & 192) == 192)       // Check if the top two bits of the byte
    {                              // are set.
      Temp2 = *Image;
      Image++;

      for(int i = 0; i < (Temp1 & 63); i++)
      {
        putpixel(X, Y, Temp2);
        X++;
        if(X == Width)  {Y++; X = 0; }
      }
    }

    else                              // If they are not set, just plot it
    {                                 // to the screen.
      putpixel(X, Y, Temp1);
      X++;
      if(X == Width) {Y++; X = 0; }
    }

  }
}
