/******************************************************************************
Fractal Infinity - MAIN PROGRAM FILE - fr_main.c.
This file Copyright (C) 1999 Graeme Fenwick- see documentation for details.
******************************************************************************/

#include <stdlib.h>
#include "fr_user.h"
#include "fr_gen.h"
#include "fr_hware.h"
#include "fr_par.h"

int main(int argc, char **argv)
{
   int           depth = 16, xr = 640, yr = -1, svx = 0, key = -1;
   long double   xc = 0.0, yc = 0.0, mag = 2.0, range = 5.0;

   if (cli_parse(argc, argv, &depth, &xr, &yr, &svx, &xc, &yc, &range) == 0)
      correct_usage(0);                                   /* nonvalid switch */
   if (auto_setup(xr, yr, depth) == 0)                     /* screen set up? */
      exit(EXIT_FAILURE);
   do {
      image_generate(xc, yc, range);
      info_display(mag, range, xc, yc);
      if (svx == 0)                                    /* autosave mode off? */
         key = adjustment(&mag, &xc, &yc, &range);        /* adjust settings */
   } while (key != QUIT && svx == 0);
   if (svx == 1)
      return (save_next() ? EXIT_SUCCESS : EXIT_FAILURE);    /* save picture */
   return EXIT_SUCCESS;
}

