//
//	source generated by 'FastGL sourcer'
//  and improved by Marian Krivos (cca 24 hours of working)
//

#include <fastgl.h>
#include <widgets.h>

#include "editor.h"

static Window *Text_EditorPtr;
static Window *OptionsPtr;
static int lfonly;
#ifdef DEBUG
static int TABSIZE=8;
#else
static int TABSIZE=4;
#endif
static BUFFER buf;
static LINE text[MAX_LINE];
static char s[1028];
static int WX, WY;
static Window *String_SearchPtr;
static char srch_str[33];
static int last_found=0;
static int _font=3;
static int nodraw;
static int font_tab[5][2]=
{
{4,8},
{8,12},
{8,18},
{12,25},
{16,34},
};

static void SaveBuffer(void);
static void SaveAsBuffer(void);
static void NewBuffer(void);
static void OpenBuffer(void);
static void ShowBuffer(void);
static void ShowCursor(int trigger);
static LINE *create_line(char *s, int at=buf.line);

//  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

static void Done(void)
{
	delete Text_EditorPtr;
}

static void file(void)
{
	MenuWindow *m1Wnd = new MenuWindow(Text_EditorPtr->GetX()+4, Text_EditorPtr->GetY()+46, 100, 104);
	m1Wnd->AddMenu("New",'N', NewBuffer);
	m1Wnd->AddMenu("Open",'O', OpenBuffer);
	m1Wnd->AddMenu("Save",'S',SaveBuffer);
	m1Wnd->AddMenu("Save As",'A',SaveAsBuffer);
	m1Wnd->Separator();
#ifdef DEBUG
	m1Wnd->AddMenu("Quit",'Q',App::AppDone);
#else
	m1Wnd->AddMenu("Close",'C', Done);
#endif
}

static int _memcmp(unsigned char *from, unsigned char *co, unsigned kolko, unsigned l)
{
	unsigned char *p, c1, c2;
	unsigned i;

	while (kolko--)
	{
		if (toupper(*from) == toupper(*co))
		{
			p = from;
			for (i = 0; i < l; i++)
			{
				c1 = toupper(p[i]);
				c2 = toupper(co[i]);
				if (c1 != c2)
					break;
			}
			if (i == l)
				return 0;
		}
		from++;
	}
	return 1;
}

//
// return line number or -1
//
static int Find(int from, int count, int size)
{
	int i;
	for(i=0;i<count;i++)
	{
		if (!_memcmp(text[from+i].text,(unsigned char *)srch_str, text[from+i].size, size))
		{
			return from + i;
		}
	}
	return -1;
}

static void Clear(void)
{
	Text_EditorPtr->WindowBox(OFFSET_X, OFFSET_Y, WX*CX, WY*CY, Text_EditorPtr->GetPaper());
}

static void Goto(int line)
{
	if (line<buf.lines && line != buf.line)
	{
		buf.posx = 0;
		buf.posy = 0;
		buf.line = buf.top = line;
		Clear();
		ShowBuffer();
	}
}

static void Search(void)
{
	int size = strlen(srch_str);
	last_found = 0;
	if (size && buf.lines>1)
	{
		last_found = Find(last_found,buf.lines-last_found,size);
		if (last_found<0) last_found=0;
		else Goto(last_found);
	}
}

static void again(void)
{
	int size = strlen(srch_str);
	if (size && buf.lines>1)
	{
		last_found++;
		last_found = Find(last_found,buf.lines-last_found,size);
		if (last_found<0) last_found=0;
		else Goto(last_found);
	}
}

static void SearchProc(GuiEvent *p)
{
	if (p->Type() == KEYEVENT && p->Key()==ESC) delete p->wnd;
}

static void search(void)
{
	if (String_SearchPtr) String_SearchPtr->WindowFocus();
	else
	{
		String_SearchPtr = new Window(&String_SearchPtr, Text_EditorPtr->GetX()+160, Text_EditorPtr->GetY()+294, 284, 140, "String Search", SearchProc, CGRAY3, CDARK, 0x203);
		EditBox *eb = String_SearchPtr->AddEditBox(8, 24, 72, 160, "String", 's', srch_str, Search);
		String_SearchPtr->AddPushButton(80, 64, 160, 21, "Search again", CR, again);
		eb->SetSize(32);
		eb->ClickUp(1);
	}
}

static void SetFont(void)
{
	Clear();
	_font = Control::GetLastActive()->GetLocalId()-2;
	ShowBuffer();
}

static void OptionsProc(GuiEvent *p)
{
	static ButtonGroup *bg;
	Control *pb;
	
	switch(p->Type()) {
		case INITEVENT:
			set_ppop(_GSET);
			p->wnd->AddPointButton(8, 16, "LINEFEED ONLY", 'l', &lfonly);
			p->wnd->AddEditBox(176, 12, 64, 40, "TAB SIZE", 't', &TABSIZE, 0, 1, 32);
			bg = new ButtonGroup();
			pb = p->wnd->AddPointButton(8, 80, "1", '1', 0, SetFont);
			bg->AddToGroup(pb, _font==0);
			pb = p->wnd->AddPointButton(8, 100, "2", '2', 0, SetFont);
			bg->AddToGroup(pb, _font==1);
			pb = p->wnd->AddPointButton(64, 80, "3", '3', 0, SetFont);
			bg->AddToGroup(pb, _font==2);
			pb = p->wnd->AddPointButton(64, 100, "4", '4', 0, SetFont);
			bg->AddToGroup(pb, _font==3);
			pb = p->wnd->AddPointButton(110, 80, "5", '5', 0, SetFont);
			bg->AddToGroup(pb, _font==4);
			p->wnd->WindowText(8, 56, "Font size", 5, 1);
			break;
		case KEYEVENT:
			if (p->Key() == ESC) delete p->wnd;
			break;
		case TERMINATEEVENT:
			delete bg;
			break;
	}
}

static void options(void)
{
	OptionsPtr = new Window(&OptionsPtr, Text_EditorPtr->GetX()+100, Text_EditorPtr->GetY()+56, 300, 156, "Options", OptionsProc, CGRAY3, CDARK, 0x287&~WNOPICTO);
}

static char * terminate(char *s)
{
	int pom = MAX_LINESIZE-1;
	char *ss = s;
	while (pom && ss[pom]<=' ') pom--;
	if (pom<MAX_LINESIZE-1) pom++;
	ss[pom] = 0;
	return s;
}

//
// vytvori riadok s obsahom 's', na pozicii 'at'
// a inicializuje buffer s jeho obsahom
//
static LINE *create_line(char *s, int at=buf.line)
{
	int size = s==0?0:text[at].size = strlen(s);
	char tmp[MAX_LINESIZE+4]="";
	if (size) memmove(tmp,s,size);
	s = tmp;
	if (size>MAX_LINESIZE) size = MAX_LINESIZE;
	char *t = (char *)text[at].text;

	if (t) free((void *)t);
	if (size != 0)
	{
		assert(t = (char *)malloc(size+1));
		text[at].text = (unsigned char *) t;
		memmove(t, s, size);
		t[size] = 0;
		memset(buf.buffer, ' ', MAX_LINESIZE);
		memmove(buf.buffer, t, size);
	}
	else
	{
		memset(buf.buffer, ' ', MAX_LINESIZE);
		text[at].text = 0;
	}
	return text + at;
}

static void Init(void)
{
	buf.lines = 1;
	buf.top = buf.line = 0;
	buf.posx = buf.posy = 0;
	memset(text, 0, sizeof(text));
	memset(buf.buffer, ' ', MAX_LINESIZE);
	create_line(buf.buffer, 0);
}

static void DeInit(void)
{
	cfg->WriteInt("lfonly",lfonly);
	cfg->WriteInt("TABSIZE",TABSIZE);
	cfg->WriteInt("_font",_font);
}

static void Load(FILE *f)
{
	int c,l=0,i=0;
	char b[MAX_LINESIZE+1];
	
	lfonly = 1;
	for(;;)
	{
		c = fgetc(f);
		if (c==EOF) break;
		else if (c>=' ')
		{
			b[i] = c;
			if (i<MAX_LINESIZE) i++;
		}
		else if (c==TAB)
		{
			do
			{
				b[i] =  ' ';
				if (i<MAX_LINESIZE) i++;
			}
			while(i%TABSIZE);
		}
		else if (c == LF)
		{
			b[i]=0;
			create_line(b,l);
			i = 0;
			if (l++ == MAX_LINE) break;
		}
		else if (c==CR) lfonly = 0;
	}
	if (l) buf.lines = l;
}

static void _save(FILE *f)
{
	int c,i=0;
	unsigned j;
	for(i=0;i<buf.lines;i++)
	{
		for(j=0;j<text[i].size;j++)
		{
			c = text[i].text[j];
			fputc(c,f);
		}
		if (lfonly==0) fputc(CR,f);
		fputc(LF,f);
	}
}

static void Open(char *s)
{
	Init();
	FILE *f = fopen(s,"rb");
	strcpy(buf.name, s);
	if (f==0) return;
	Load(f);
	fclose(f);
}

static void SaveBuffer(void)
{
	FILE *f = fopen(buf.name,"wb");
	if (f==0) return;
	_save(f);
	fclose(f);
}

static void SaveAsBuffer2(char *s)
{
	strcpy(buf.name, s);
	Text_EditorPtr->SetName(buf.name);
	SaveBuffer();
}

static void SaveAsBuffer(void)
{
	new FileDialog(SaveAsBuffer2, 0, 0, "Save File", FDIALOG_SAVE | FDIALOG_MODAL | FDIALOG_SAVEDIR);
}

static void NewBuffer(void)
{
	strcpy(buf.name, "Untitled");
	Text_EditorPtr->SetName(buf.name);
	Clear();
	Init();
	ShowBuffer();
}

static void OpenBuffer2(char *s)
{
	strcpy(buf.name, s);
	Text_EditorPtr->SetName(buf.name);
	Clear();
	Open(s);
	ShowBuffer();
}

static void OpenBuffer(void)
{
	new FileDialog(OpenBuffer2, 0, 0, "Open File", FDIALOG_MODAL | FDIALOG_SAVEDIR);
}

static void ShowCursor(int trigger)
{
	int i,p,c=0;
	
	int	tmp2 = CScheme->statusbar;
	CScheme->statusbar = 2;
	c = buf.buffer[buf.posx];
	set_ppop(_GSET);
	if (!trigger)
	{
		p = Text_EditorPtr->GetPaper();
		i = Text_EditorPtr->GetInk();
	}
	else
	{
		i = Text_EditorPtr->GetPaper();
		p = Text_EditorPtr->GetInk();
	}
	Text_EditorPtr->WindowText(buf.posx*CX+OFFSET_X, buf.posy*CY+OFFSET_Y, (char *)&c, i, p);
	sprintf(s,"%5d:%d [%d] INS: %s       ", buf.line, buf.posx, buf.lines, buf.ovr?"OFF":"ON ");
	int tmp = set_font(2);
	Text_EditorPtr->WindowStatusBar(4,s,CWHITED);
	set_font(tmp);
	trigger ^= 1;
	CScheme->statusbar = tmp2;
}

static void ShowLine(int scr, char *s)
{
	char ss[1028];
	if (s)
	{
		strncpy(ss,s,WX);
		ss[WX]=0;
	}
	Text_EditorPtr->WindowBox(OFFSET_X, scr*CY+OFFSET_Y, Text_EditorPtr->GetWW(), CY, Text_EditorPtr->GetPaper());
	if (s)
		Text_EditorPtr->WindowText(OFFSET_X, OFFSET_Y+scr*CY, ss);
}

static void ShowBuffer(void)
{
	int old = set_font(_font);
	WX = (Text_EditorPtr->GetWW()-OFFSET_X)/CX;
	WY = (Text_EditorPtr->GetHW()-OFFSET_Y)/CY;
	for(int i=0;i<WY && buf.top+i<buf.lines;i++)
	{
		ShowLine(i, (char *)text[buf.top+i].text);
	}
	create_line((char *)text[buf.line].text);
	ShowCursor(1);
	set_font(old);
}

static int isempty(char *s)
{
	for(int i=0;i<MAX_LINESIZE;i++) if (s[i] != ' ') return 0;
	return 1;
}

static void CKey(int k)
{
	int pom;
	switch(k)
	{
		case BACKSP:
			if (isempty(buf.buffer)) CKey(CTRL_Y);
			else if (buf.posx)
			{
				memmove(buf.buffer+buf.posx-1, buf.buffer+buf.posx, MAX_LINESIZE-buf.posx);
				buf.buffer[MAX_LINESIZE-1] = ' ';
				buf.posx--;
			}
			break;
		case DEL:
			if (isempty(buf.buffer)) CKey(CTRL_Y);
			else if (buf.posx<MAX_LINESIZE-1)
			{
				memmove(buf.buffer+buf.posx, buf.buffer+buf.posx+1, MAX_LINESIZE-buf.posx);
				buf.buffer[MAX_LINESIZE-1] = ' ';
			}
			break;
		case INSERT:
			buf.ovr = !buf.ovr;
			break;
		case HOME:
			buf.posx = 0;
			break;
		case END:
			buf.posx = MAX_LINESIZE-1;
			while (buf.posx && buf.buffer[buf.posx]<=' ') buf.posx--;
			if (buf.posx<MAX_LINESIZE-2) buf.posx++;
			break;
		case KUP:
			if (buf.line)
			{
				create_line(terminate(buf.buffer));
				buf.line--;
				create_line((char *)text[buf.line].text);
				if (buf.posy) buf.posy--;
				if (buf.top>buf.line)
				{
					buf.top = buf.line;
					Text_EditorPtr->WindowScrollDown(OFFSET_X, OFFSET_Y,WX*CX,(WY-1)*CY,CY);
				}
			}
			break;
		case KDOWN:
			if (buf.lines-1>buf.line)
			{
				create_line(terminate(buf.buffer));
				buf.line++;
				create_line((char *)text[buf.line].text);
				if (buf.posy<WY-1) buf.posy++;
			    if (buf.top+WY<=buf.line)
				{
					buf.top++;
					Text_EditorPtr->WindowScrollUp(OFFSET_X, OFFSET_Y+CY,WX*CX,(WY-1)*CY,CY);
				}
			}
			break;
		case CTRL_PGUP:
			buf.line = buf.top = buf.posx = buf.posy = 0;
			ShowBuffer();
			break;
		case CTRL_PGDOWN:
			if (buf.lines >= WY)
			{
				buf.line = buf.top = buf.lines-WY;
				buf.posx = buf.posy = 0;
				ShowBuffer();
			}
			break;
		case PGUP:
			if (buf.top-WY>=0)
			{
				buf.line -= WY;
				buf.top  -= WY;
				ShowBuffer();
			}
			else CKey(CTRL_PGUP);
			break;
		case PGDOWN:
			if (buf.line+WY<buf.lines)
			{
				buf.line += WY;
				buf.top  += WY;
				Clear();
				ShowBuffer();
			}
			else if (buf.line+WY>buf.lines) CKey(CTRL_PGDOWN);
			break;
		case KLEFT:
			if (buf.posx) buf.posx--;
			nodraw = 1;
			break;
		case KRIGHT:
			if (buf.posx<MAX_LINESIZE-1) buf.posx++;
			nodraw = 1;
			break;
		case CTRL_Y:
			if (buf.line+1<buf.lines)
			{
				memmove(&text[buf.line], &text[buf.line+1], sizeof(LINE)*(MAX_LINE-buf.line));
				buf.lines--;
				create_line((char *)text[buf.line].text);
				if (buf.posy<WY-1)
				{
					int sz = WY-buf.posy;
					Text_EditorPtr->WindowScrollUp(OFFSET_X, (buf.posy+1)*CY+OFFSET_Y,WX*CX,(sz-1)*CY,CY);
					if (buf.line+sz<buf.lines) ShowLine(WY-1, (char *)text[buf.line+sz-1].text);
				}
			}
			break;
		case CR:
			pom = MAX_LINESIZE-1;
			while (pom && buf.buffer[pom]<=' ') pom--;
			if (pom<MAX_LINESIZE-1) pom++;
			if (pom>buf.posx) pom -= buf.posx; // set size of part 2
			else pom = 0; // no part 2
			strncpy(s, buf.buffer+buf.posx, pom);
			s[pom]=0;	// terminate line
			buf.buffer[buf.posx] = 0;
			create_line(buf.buffer);
			ShowLine(buf.posy, buf.buffer);
			if (buf.lines<MAX_LINE)
			{
				buf.lines++;
				buf.line++;
				memmove(&text[buf.line+1], &text[buf.line], sizeof(LINE)*(MAX_LINE-buf.lines));
				create_line(s);
				buf.posx = 0;
				if (buf.posy<WY-1)
				{
					buf.posy++;
					Text_EditorPtr->WindowScrollDown(OFFSET_X, buf.posy*CY+OFFSET_Y, WX*CX,(WY-buf.posy-1)*CY,CY);
				}
			    else
				{
					buf.top++;
					ShowBuffer();
				}
			}
			break;
	}
}

static void Key(int k)
{
	ShowCursor(0);
	if (k<' ' || k>0x7e) CKey(k);
	else
	{
		if (buf.ovr==0) memmove(buf.buffer+buf.posx+1, buf.buffer+buf.posx, MAX_LINESIZE-buf.posx-1);
		buf.buffer[buf.posx] = k;
		if (buf.posx<MAX_LINESIZE-1) buf.posx++;
	}
	if (!nodraw) ShowLine(buf.posy, buf.buffer);
	nodraw = 0;
	ShowCursor(1);
}

static void Text_EditorProc(GuiEvent *p)
{
	int	xWnd = p->GetX()-OFFSET_X;
	int	yWnd = p->GetY()-OFFSET_Y;
	int old  = set_font(_font);

	switch(p->Type()) {
		case INITEVENT:
			set_ppop(_GSET);
			p->wnd->AddBaseMenu("File", 0, file);
			p->wnd->AddBaseMenu("Edit", 0, search);
			p->wnd->AddBaseMenu("Search", 0, search);
			p->wnd->AddBaseMenu("Options", 0, options);
			ShowBuffer();
			break;
		case KEYEVENT:
			Key(p->Key());
			break;
		case CLICKLEFTEVENT:
			xWnd = xWnd/CX;
			yWnd = yWnd/CY;
			if (xWnd<0 || yWnd<0 || xWnd>=WX || yWnd>=WY) return;
			ShowCursor(0);
			create_line((char *)buf.buffer);
			buf.posx = xWnd;
			if (buf.top+yWnd < buf.lines)
				buf.posy = yWnd;
			else
				buf.posy = buf.lines-buf.top;
			buf.line = buf.top + buf.posy;
			create_line((char *)text[buf.line].text);
			ShowLine(buf.posy, buf.buffer);
			ShowCursor(1);
			break;
		case CLICKRIGHTEVENT:
			break;
		case RESIZEEVENT:
			ShowBuffer();
			break;
		case TERMINATEEVENT:
			DeInit();
			if (String_SearchPtr) delete String_SearchPtr;
			if (OptionsPtr) delete OptionsPtr;
			break;
	}
	set_font(old);
}

void Editor(char *arg, int font)
{
	cfg->ReadInt("lfonly",lfonly);
	cfg->ReadInt("TABSIZE",TABSIZE);
	cfg->ReadInt("_font",_font);
	if (font == -1) font = _font;  // set default
	if (Text_EditorPtr)	Text_EditorPtr->WindowFocus();
	else
	{
		Open(arg);
		assert((_font = font) < 5);
		int	tmp = CScheme->statusbar;
		CScheme->statusbar = 2;
		Text_EditorPtr = new Window(&Text_EditorPtr, 512, 334, 476, 380, buf.name, Text_EditorProc, CGRAY3, 16, WSTANDARD|WMENU|WCLICKABLE|WSTATUSBAR|WSIZEABLE);
		CScheme->statusbar = tmp;
	}
}

#ifdef	DEBUG
int main(int argc, char **argv)
{
	App MyApp(4, argc, argv, CBLACK, +APP_ENABLEALTX+APP_CFG+APP_WINDOWDATABASE);
	CScheme->statusbar = 2;
	cApp->farby->CreateColor(5, 0, 17, 16);
	if (argc==2) Editor(argv[1], FONT);
	else Editor("Untitled", FONT);

	MyApp.Run();

	if (Text_EditorPtr) delete Text_EditorPtr;
	return 0;
}
#endif
