 ( Star Trek Battle Game -- version 2.26 only, part of Forth )    ( for details on this program, see the user documentation )                                                                   : get#$ ( -- f ) tib @ 30 blanks tib @ 1+ 25 expect tib @ 1+ c@     dup 45 = over 46 = or swap 48 58 within or hld @ 2- 0 ?do       tib @ i + 2+ c@ dup 46 = swap 48 58 within or and loop ;                          ( get a string, make sure it's a number )                                                                 : get# ( -- n/d f ) cur @ begin get#$ dup 0= if over cur !          space 8 emit then until drop tib @ number dpl @ tib @ 30        erase ;                        ( get number from keyboard )                                                                 : seed-it ." Input any number: " get# 2drop abs 0 do rnd0 drop      loop cr ; -->                 ( bump rnd gen around a bit )                                                                                                                                  ( basic ops )                                                  : rnd ( n -- n ) 1+ begin rnd0 abs over mod -dup until nip ;               ( our basic random get routine -- 1 to N inclusive )                                                                 : title cls home 27 spaces ." Fig-Forth Battle Trek v2.0" cr ;                                               ( Our main title )                                                                 : setwin ( x y w h -- ) video vlength ! vwidth ! vleft ! vtop !     forth home ;                        ( set window controls )                                                                 : norm 0 0 80 25 setwin 3680 cur ! ;          ( normal window )                                                                 : subs 13 0 80 12 setwin 3680 cur ! ; -->     ( game   window )                                                                                                                                                                                                 ( variables & constants 1 )                                         40 constant max-klings   3 constant min-kling                    1 constant min-bases    9 constant max-stars                 4000 constant batteries   10 constant shots     ( constants )   6000 constant ke ( kling power*10 )                                                                                              0 variable #klings   0 variable #bases        ( game stats )    0 variable xquad     0 variable yquad      ( ship location )    0 variable xsect     0 variable ysect                           0 variable cond      0 variable ang               ( status ) 3000 variable energy   10 variable torps            ( weapons ) 1000 variable shields   0 variable sdate  -->     ( game time )                                                                                                                                                                                                                                                                 ( arrays 1 )                                                     ( current energy & locations of enemy )                         4 4 * array kk                         ( max of 4 Ks in quad )                                                                  8 8 * 2 * array galaxy                         ( galaxy data )  64 64 *   array sectors   ( sector data: quad, quad, quad... )                                                                      8 2 * array damage 0 +off .lrs   2 +off .srs 2 +off .phsrs                         2 +off .torps 2 +off .eng 2 +off .dmg                           2 +off .shlds -->      ( damage array )                                                                                                                                                                                                                                                                                                                                                                                                 ( strings 1 )                                                   : $8  ."  Damaged***" cr ;      : $9  ." Long Range Sensors" ;  : $10 ." Short Range Sensors" ; : $11 ." Phasers" ;             : $12 ." Photon Tubes" ;        : $13 ." Engines" ;             : $14 ." Damage Control" ;      : $15 ." Shields" ;                                                 ( damage print strings... )                                                                 switch dev1 0 $9 1 $10 2 $11 3 $12 4 $13 5 $14 6 $15 -1                                              ( table of print vectors )                                                                 : $1 ( -- adr ) ," .  *  B  K  E    " 1+ ;                                                       ( the print data for display )                                                                 : hline 23 0 do 196 emit loop ; -->   ( A horizontal box line )                                                                                                                                 ( numbers & printing )                                          : .y ( n -- ) 1+ . ;                          ( print y coord ) : .x ( n -- ) 1+ . ;                          ( print x coord )                                                                 : #-# ( n -- ) s->d dup -rot dabs <# # # # 46 hold #s sign #>       type ;                               ( number print x.xxx ) : .## ( n -- ) s->d dup -rot dabs <# # # 46 hold #s sign #>         type ;                                ( number print x.xx ) : .# ( n -- ) s->d dup -rot dabs <# # 46 hold #s sign #> type ;                                          ( print number xxx.x ) : dots ( -- ) 19 0 do ." :" loop cr ;  ( print dots for frame )                                                                 : ->q ( x y -- adr ) 8 * + 2 * galaxy + ;      ( any quad adr )                                                                 : >quad ( -- adr ) xquad @ yquad @ ->q ;       ( current quad ) -->                                                             ( number helpers )                                              : digs ( n c -- n D ) pleat 1 -rot 0 -rot 0 do 10 /mod rot drop     rot 10 * -rot loop drop swap 10 / over * rot swap - swap ;                                   ( return column value c of n ) : 0-9 ( n -- n ) 0 max 9 min ;                  ( limit digit ) : 0-7 ( n -- n ) 0 max 7 min ;                  ( limit q/s   ) : ?xy ( x y -- x y f ) over 0 8 within over 0 8 within and 0= ;                                             ( is x & y valid? ) : sector ( -- adr ) xquad @ yquad @ 8 * + 64 * sectors + ;                      ( point to current quad record in sector data )                                                                 14 variable clrs -1 allot 15 c, 10 c, 12 c, 14 c, 14 ,                                                  ( color control table ) : c? ( n -- ) clrs + c@ attr ! ;    ( pick a color, any color ) -->                                                                                                                             ( formulas )                                                    : p->r ( 2n -- x y ) dup ang @ cos 20000 */ swap ang @ sin          20000 */ ;                   ( compute coords from vector ) : p->r1k ( n -- y x ) dup ang @ sin 200 */ ysect @ 1+ 100 * +       swap ang @ cos 200 */ xsect @ 1+ 100 * + ;                                                ( compute coords *100 from ship ) : w->r ( n -- x y f ) p->r swap xsect @ + swap ysect @ + ?xy ;                          ( convert vector to x,y & test limits ) : ^.4 ( n -- v ) 10 * 40 1 do i dup dup 2 / * * over >= if drop      i leave then loop ;              ( used later, 2.5 root )  : dist ( x1 y1 x2 y2 -- n ) rot - 10 * dup * -rot swap - 10 *       dup * + sqr ;  -->           ( distance between points*10 )                                                                                                                                                                                                                                                                 ( Creating the Galaxy Entries )                                 : galaxy-done? ( -- f ) 1 128 0 do i galaxy + @ 0 > and 2 +loop     ;         ( find out if all of the galaxy has been seeded )                                                                 : stars ( -- n ) max-stars rnd ;    ( get the number of stars )                                                                 : klings ( n -- n ) #klings @ max-klings < if min-kling rnd dup     #klings +! 100 * + then ;     ( add in the Klingon Menace )                                                                 : base% ( -- % ) #bases @ 0= if 43 else 500 #klings @ 10 / 1+ /     then ;                      ( get the percentage of bases ) : bases ( n -- n ) base% rnd 1 = if 10 + 1 #bases +! then ; -->                                  ( add bases to current value )                                                                                                                                                                                                 ( Creating the Galaxy itself )                                  : -value ( n -- ) 3 digs #klings -! 2 digs #bases -! drop ;                       ( correction for values that must be removed )                                                                : >gal ( n -- ) 8 rnd 1- 8 rnd 1- begin 2dup ->q @ 0= if            ->q ! 1 else 1+ 8 /mod +under swap 8 mod swap 2dup ->q          @ 0= if ->q ! 1 else 2drop 8 rnd 1- 8 rnd 1- 2dup ->q @         -value 2dup 0 -rot ->q ! 0 then then ?terminal or until ;                           ( send data to galaxy array at random )                                                                 : build-galaxy ( -- ) 0 #klings ! 0 #bases ! galaxy 128 erase       begin stars klings bases >gal #klings @ max-klings 4 / dup      3 * swap rnd + > #bases @ min-bases > and galaxy-done? and      ?terminal or until ; -->          ( build the whole thing )                                                                                                                                 ( now we report and place the ship )                            : report1 ( -- ) begin build-galaxy 480 cur ! ." klings: "          #klings ? ."   bases: " #bases ? cr ." change? " key 95 and     89 <> until ;                             ( report it all )                                                                 : qq1 8 0 do cr 8 0 do i j ->q @ 4 .r loop loop ;                                ( programmers cheat to print the galaxy data )                                                                 : put-e 8 rnd 1- xquad ! 8 rnd 1- yquad ! ; -->                                                  ( set ship down somewhere... )                                                                                                                                                                                                                                                                                                                                                                                                 ( Damage Control )                                              : ouch! 1 c? 7 rnd 1- 10000 rnd 1- over 2 * damage + +!             ." ***" dev1 drop $8 7 emit 0 c? ;     ( disable a device )                                                                 : damr damage.dmg @ if ." ***" $14 $8 else ." Damage Control "      ." Report" cr 7 0 do i dev1 42 cur @ 160 mod - 2 / spaces       2 * damage + @ #-# cr loop then ;      ( damage report... )                                                                 : fixit damage.dmg dup @ if dup @ 1000 - 0 max swap ! else 10 -     7 0 do dup @ if dup @ 1000 - 0 max over ! then 2+ loop drop     then ;                    ( fix damage in move increments )                                                                 : storm? 25 rnd 1 = if 7 emit 1 c? ." Ion Storm -- " ouch! then     ; -->                            ( be nasty to the folks! )                                                                                                                                 ( Long Range Sensor Scan )                                      : dlrs ( x y -- ) ?xy 0= if ->q @ 1000 mod 4 .r ."  :" else         2drop ."  --- :" then ;          ( print one line of scan )                                                                 : lrs 1 60 20 8 setwin damage.lrs @ if cr cr cr ." ** LRS "         ." Damaged **" cr cr else 4 1 do dots ." :" 4 1 do i 2-         xquad @ + j 2- yquad @ + dlrs loop cr loop dots then            ."    lrs for " xquad @ .x ." - " yquad @ .y ; -->                                                 ( print whole scan )                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ( Short Range Sensor Scan -- large data, full color )           : >sec ( n -- ) begin 64 rnd 1- sector + dup c@ 0= if c! 0 else     drop then -dup 0= until ;                                                  ( store data in a sector location that is zero )                                                                 : sec? ( -- f ) sector 0 64 0 do over i + c@ or dup if leave        then loop nip ;        ( Has this quad been drawn before? )                                                                 : sects sec? 0= if >quad @ begin dup 1000 / if 4 >sec 1000 -        else dup 100 / if 3 >sec 100 - else dup 10 / if 2 >sec 10 -     else dup if 1 >sec 1- then then then then -dup 0= until         then ;                              ( set up one quadrant )                                                                 : set-e sects begin 64 rnd 1- dup sector + c@ 0= if 8 /mod          ysect ! xsect ! 0 then 0= until ; -->                                                               ( put ship somewhere! ) ( Status report & short range scan  )                           : docked? ( x y n -- ) 2 = cond @ 3 <> and if ysect @ - abs         swap xsect @ - abs 2 < swap 2 < and if 3 cond ! then else       2drop then ;                             ( are we docked? )                                                                 : red? ( n -- ) 3 = cond @ 3 <> and if 1 cond ! then ;                                                       ( enemy present? )                                                                 : e? ( x y -- n ) 2dup ysect @ = swap xsect @ = and if 2drop 4      else 8 * + sector + c@ then ;        ( get kind of object )                                                                 : dsrs 8 0 do cr 179 emit 8 0 do i j 2dup e? dup red? docked? 3     spaces loop 8 emit 179 emit loop cur @ 864 cur !                ." ** SRS Damaged **" cur ! ; -->       ( damaged display )                                                                                                                                 ( Short Range Sensor Scan & Staus )                             : rsrs 8 0 do cr 179 emit 8 0 do i j 2dup e? dup dup c? 3 * $1      + 3 type 0 c? dup red? docked? loop 8 emit 179 emit loop ;                                   ( normal short range display )                                                                 : srs 0 cond ! 1 28 27 13 setwin damage.srs @ sects 218 emit        hline 191 emit if dsrs else rsrs then cr 192 emit hline 217     emit cr ."  quad: " xquad @ .x ." - " yquad @ .y ." sect: "     xsect @ .x ." - " ysect @ .y ;                ( do it all )                                                                 : yellow? energy @ 500 < cond @ 0 = and if 2 cond ! then cond @     3 = if 3000 energy ! 10 torps ! then ; -->                                             ( is ship low on energy? or docked )                                                                                                                                                                                                  ( Staus Report )                                               : $2 ." Condition: " cond @ dup 0= if 2 c? ."   GREEN " 0 c?        then dup 1 = if 3 c? ." * RED *" 0 c? then dup 2 = if 0 c?      ." YELLOW " then 3 = if 1 c? ."  DOCKED " 0 c? then cr ;                                               ( condition report )                                                                 : $3 ." Energy  @: " energy @ 7 .r cr ;  ( print energy level ) : $4 ." Torpedoes: " torps @ 7 .r cr ;           ( torp count ) : $5 ." Shields @: " shields @ 7 .r cr ;    ( shield strength ) : $6 ." Star Date: " sdate @ 7 .r cr ;            ( game time ) : $7 ." Klingons : " #klings @ 7 .r cr ;         ( enemy left )                                                                 : .stats cur @ norm srs lrs yellow? 1 0 20 9 setwin $2 $3 $4 $5     cr $6 cr $7 subs cur ! ; -->            ( print all stats )                                                                                                                                  ( Other Utils )                                                : getd ." Direction? " get# dup 1 < if 2drop else 0 do 10 m/        loop drop then ang ! cr ;               ( get a direction )                                                                 : @k ( adr -- y x ) 8 /mod swap ;           ( rel adr changer )                                                                 : ?klings ( -- n ) 0 4 0 do i 4 * kk + @ if 1+ then loop ;                                     ( how many klings in quadrant? )                                                                 : fndk ( rel -- rel f ) 1+ 0 over 64 swap do over sector + c@ 3     = if 1+ leave else swap 1+ 64 min swap then loop ;                                                       ( find a bad-guy )                                                                 : up-klings kk 4 4 * erase -1 4 0 do fndk if ke i 4 * kk + >r       r ! dup r> 2+ ! then loop drop ; --> ( set-up enemy array )                                                                 ( more utils here )                                             : -kl ( a n -- a n ) 4 0 do over i 4 * kk + 2+ @ = if i 4 * kk      + dup 2+ @ swap -64 0 rot 2! ."  ZAP!!" >quad @ 3 digs 1-       0-9 100 * + >quad ! 1 #klings -! sector + 0 swap c! then        loop ;                                   ( remove a kling )                                                                 : sect? ( n -- a f ) w->r -rot 8 * + sector + dup c@ rot if         drop -1 then ; ( travel to x,y & retrieve object in sector.     Error if out of range. )                                                                                                    : ?cr cur @ 160 mod 145 > if cr then ; -->    ( is cr needed? )                                                                                                                                                                                                                                                                                                                                 ( win/lose report )                                             : ck1 #klings @ if norm cr ." It is Stardate " sdate ? ." and "     ." there are still " #klings @ . ." Klingon" if ." s" then      ."  in the Galaxy." cr ." Your mission has failed, the Fed"     ." eration will be destroyed." cr ." You are dead." sp! rp!     quit then ;                                                                                                                 : ck2 sdate @ 100 mod 98 > if ck1 then ;                                                                                        : ck3 energy @ 1 < if norm ." Out of ship's energy!" cr ck1         then ;                                                      : ck4 #klings @ 0= if norm ." Congratulations Admiral! You "        ." have saved the Federation!" cr sp! rp! quit then ;                                                                       : kill? ck2 ck3 ck4 ; -->                                                                                                       ( The Klingons Attack! )                                        : kfire2 ( a ke -- a ) 10 / damage.shlds @ if ." Shields Are "      ." Down! " cr ouch! energy -! else shields @ over < if cr       ouch! then shields @ swap - dup 0< if dup energy +! then 0      max shields ! then ;                                                            ( if shields over-powered, disable device )                                                                 : kfire1 ( a ke' -- a ) cond @ 3 = if ." Star Base Shields "        ." Protect the Enterprise." drop cr else kfire2 then ;                                     ( allow starbase to protect us )                                                                 : kfire ( -- ) kk 4 0 do dup @ if dup @ 2 / 1 max rnd over 2+ @     >r r @k swap xsect @ ysect @ dist ^.4 2 / / dup 3 c? .#         ."  Hit from K@ " r> @k .x ." - " .y ." left:" over @ pleat     swap - dup .# 0 c? cr swap >r over ! r> kfire1 then 4+ loop     drop ; -->                          ( report kling attack ) ( Timer & Phaser control )                                      : +turn fixit 1 sdate +! .stats kfire kill? storm? ;                                              ( advance game time & print )                                                                 : efire ( e -- ) ?klings / 4 0 do kk i 4 * + dup @ if 2+ >r dup     r @ @k ysect @ xsect @ dist ^.4 over 30 * swap / dup .#         ."  Hit on K@ " r @ @k .x ." - " .y r 2- @ swap - dup           ." Left: " .# dup 0< if r> @ swap -kl 2drop else r> 2- !        then cr then drop loop drop ;                                                      ( divide energy amoung klings and fire )                                                                 : phasers damage.phsrs @ if ." Phasers are out." else ." Energ"     ." y to fire: " get# cr dup 1 < if 2drop else 0 do 10 m/        loop drop then energy @ over < ?klings 0= or if ." sorry."      drop else efire kfire then then .stats ; -->                                                              ( shoot dammit! ) ( Torps )                                                       : torp1 ( a n -- ? n ) dup 1 = if ." Star Destroyed." cr 10 rnd     1 = if 5 3 pick c! >quad @ 4 digs 1+ 0-9 1000 * + >quad !       else 0 3 pick c! >quad @ 1 digs 1- 0-9 + >quad ! then then      ;                                            ( star hit? )                                                                  : torp2 ( a n -- ? n ) dup 2 = if cr ." Good shooting, Star "       ." Base Destroyed!" cr 0 3 pick c! 1 #bases -! >quad @ 2        digs 1- 0-9 10 * + >quad ! then ;             ( base hit? )                                                                 : torp3 ( a n -- ? n ) dup 5 = if 2 rnd 1 = if ." Torp off "        ." sensors." else ." Contact lost." then cr then ;                                                                 ( oops ) : torp4 ( a n -- ? n ) dup 3 = if sector minus +under -kl then      ; -->                                        ( kling hit? )                                                                 ( Torps )                                                       : firet 0 16 0 do drop i p->r1k .## ." -" .## 3 spaces ?cr i        sect? dup 0< if 1+ leave else torp1 torp2 torp3 torp4 then      nip if leave 1 else 0 then loop 0= if ." Missed." then 1        torps -! cr kfire .stats ;                    ( fire torp )                                                                 : torp damage.torps @ if ." Sorry, photon tubes damaged."           else torps @ if getd ." Tracking:" firet else                   ." No torpedoes left." then then cr ; -->                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ( engines )                                                     : in-sect? ( n -- a f ) 0. rot 0 do 2drop i sect? nip dup 0< if     leave -1 swap else i swap dup if leave then then loop ;                    ( scan vector for object, return flag & length )                                                                 : lck ( a -- ) dup sect? drop sector - @k ." Object @" .x ." -"     .y 1- sect? drop sector - @k xsect ! ysect ! cr +turn ;                                                   ( object report )                                                                 : warp1 ( x y -- ) yquad @ + 0-7 yquad ! xquad @ + 0-7 xquad !      set-e up-klings +turn ;         ( intra-quadrant movement )                                                                 : warp ( n -- ) 16 in-sect? dup 1 < if 2drop 2+ 4 / p->r warp1      else if lck drop else 2drop then then ; -->                                                           ( warp to next quad )                                                                 ( engines )                                                     : sgn ( n -- d') dup 0< if drop -1 else 7 > if 1 else 0 then        then ;                    ( return offset vector for warp )                                                                 : sublight ( n -- ) dup 16 10 */ in-sect? dup 0< if 2drop w->r       drop sgn swap sgn swap warp1 else if lck else sect? drop        sector - @k xsect ! ysect ! +turn then drop then ;                                                       ( travel in quad ) : chks ( n -- ) dup 9 > damage.eng @ 0= 0= and if ." Engines "      ." are off-line." cr drop else dup 9 > damage.eng @ 0= and      energy 149 > and if warp else 1+ sublight then then ;                            ( check speed and call correct function )                                                                  : gets ( -- n ) ." Warp? " get# dup 1 < if 2drop 10 * else 1-       dup if 0 do 10 m/ loop else drop then drop then cr ; -->                                                   ( get speed*10 )( engines & sheilds )                                           : navigate energy @ 150 < if ." Insufficient Power -- Cannot "      ." establish a Warp Field." cr else damage.eng @ if             ." Warp drive damaged, .2 max." cr then then getd gets chks     ;                                          ( move the ship )                                                                : shei damage.shlds @ if ." Shield Generator is off-line. " else    shields @ energy @ + ." Available power: " dup . cur @ >r       begin r cur ! ." Energy to Shields? " get# dup 1 < if 2drop     else 0 do 10 m/ loop drop then 2dup > until dup shields ! -     energy ! rdrop then cr .stats ; -->         ( get shields )                                                                                                                                                                                                                                                                                                                                 ( command system )                                              : cc1 ," COMMAND(NTPSDHQ)?" dup count type 9 + begin key dup 58     < if 48 - over + c@ then 95 and 2dup 7 0 do over c@ = if        drop 0 leave else 1+ then over loop swap 0= if emit cr 1        else 2drop 0 then until nip ;     ( get command character )                                                                 : cc2 78 case: navigate :end 84 case: torp :end 83 case: shei       :end 68 case: damr :end 80 case: phasers :end ;                                               ( first half of key process )                                                                 : set-up cls home seed-it sectors 64 dup * erase galaxy 8 dup *     2 * erase damage 8 2 * erase 3000 energy ! 1000 shields !       10 torps ! 16 rnd 20 + 100 * sdate ! 0 #klings ! 0 #bases !     report1 put-e set-e up-klings norm cls title srs lrs .stats     subs ; -->                                                                                                                  ( help & main )                                                 : h1 norm cr ." Your mission: to rid the galaxy of the Klingon "    ." menace." cr ." Your command are Navigation, Torpedo laun"    ." ch, Phaser control, Shield energy, Damage control, Help "    ." and Quit." cr key drop cls title srs lrs .stats subs ;               ( a help screen, but I'm too lazy to write it all )                                                                 ( main loop )                                                   : remain begin cc1 cc2 dup 72 = if h1 then 81 = until sp! ;     : main set-up kfire remain norm ;                               : // norm cls title srs lrs .stats 13 0 80 12 setwin ;                                                     ( testing function )                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 ( end )                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         