( INTERRUPT HANDLING EXAMPLE                   08:59 11/16/85 )

\ THIS TEST PROGRAM INTERCEPTS "CONTROL-C"
\   AND "CONTROL-BREAK" FROM THE KEYBOARD.
\   IT ALSO SHOWS TRAPPING OF DIVISION BY ZERO.

\ STOP EXECUTION BY TYPING ANY KEY BUT "CONTROL-C" OR "CONTROL-
\   BREAK"


256 MSDOS
HEX

INCLUDE INTS



\ CONTROL-C HANDLER
0 0 IN/OUT
: CC-HANDLER ." !!!CTRL-C!!! "  ;

23 CONSTANT CC-INT  ( interrupt number )

L: CC-ENTRY ( actual interrupt handler )
  ( save registers )
  AX PUSH  BX PUSH  CX PUSH  DX PUSH  SI PUSH  DI PUSH
  ES PUSHSEG  ( just in case we alter it )
  CALL' CC-HANDLER  ( high level interrupt handler )
  ( restore registers )
  ES POPSEG 
  DI POP  SI POP  DX POP  CX POP  BX POP  AX POP
  IRET     FORTH


\ CONTROL-BREAK HANDLER
20 ALLOT  HERE CONSTANT PARAMSTACK	\ our new stacks
20 ALLOT  HERE CONSTANT RETSTACK
2VARIABLE SS-SAVE			\ Stack segment save area

VARIABLE BREAK-SET

0 0 IN/OUT
: CB-HANDLER  BREAK-SET ON  ;

1B CONSTANT CB-INT

L: CB-ENTRY ( actual interrupt handler )
  ( save registers )
	AX PUSH  DS PUSHSEG  AX CS <SEG  AX DS >SEG	\ save AX, DS, set DS
	SS-SAVE [] SS <SEG  SP SS-SAVE 2+ [] MOV	\ save SS SP
	AX SS >SEG PARAMSTACK # SP MOV			\ set SS,SP
	BX PUSH  CX PUSH  DX PUSH  SI PUSH  DI PUSH	\ Save remaining
	BP PUSH ES PUSHSEG 
	RETSTACK # BP MOV				\ set BP
	CALL' CB-HANDLER  ( high level interrupt handler )
	ES POPSEG BP POP DI POP SI POP DX POP CX POP BX POP \ restore registers
	SS-SAVE [] SS >SEG SS-SAVE 2+ [] SP MOV DS POPSEG  AX POP
	IRET FORTH

\ Because this is a BIOS interupt, rather than an MS-DOS interupt,
\ as CC-INT was, we have to set our data segment register, and 
\ use new stacks with minimum impact on the DOS stack


\  ZERO-DIVIDE TRAP HANDLER
0 CONSTANT /0-INT

L: /0-ENTRY  
	0 # AX MOV  AX DX MOV ( return zero )
	1 # BX MOV	( FOR 80286 or 80386 which will restart instruction )
	IRET    FORTH

\ Neither this interupt (which is a hardware trap) nor the
\ CONTROL-BREAK interupt had better do any i/o since DOS is not
\ reentrant!


\ INTERUPT HANDLER DEMO
0 1 IN/OUT
: KEY? ( like ?terminal, but returns keystroke if there is one)
       ( this returns CONTROL-BREAK like no key has been hit )
       ?TERMINAL IF KEY ELSE 0 THEN ;

2VARIABLE /0-SAVE  ( we will want to save the vectors )
2VARIABLE CB-SAVE

DECIMAL
: MAIN  
	/0-INT get-handler /0-SAVE 2!		\ get and save old handlers
	CB-INT get-handler CB-SAVE 2!
	?CS: CC-ENTRY CC-INT set-handler	\ set handlers to us
	?CS: CB-ENTRY CB-INT set-handler
	?CS: /0-ENTRY /0-INT set-handler
	." TYPE ANY KEY TO STOP, OR TYPE CONTROL-C OR BREAK" CR
	BEGIN  10 0 DO
		BREAK-SET @ IF BREAK-SET OFF ." *BREAK*"  THEN
		10000 I / . LOOP
		CR KEY? UNTIL
	/0-SAVE 2@ /0-INT set-handler		\ restore handlers
	( We dont need to restore the control-C handler )
	CB-SAVE 2@ CB-INT set-handler ;


INCLUDE FORTHLIB
END
