
#define HASH_TAB_SIZE 211

typedef struct entry {
	char name[14];
	unsigned fdate;
	unsigned ftime;
	char attr;
	char copied;
	struct entry *next;
} ENTRY;

typedef struct {
	int mo;
	int day;
	int year;
	int mode;
} DATE;

typedef struct {
	int min;
	int hour;
	int mode;
} TIME;

typedef struct date_node{
	int fdate;
	int mode;
	struct date_node *next;
} DATE_NODE;

typedef struct time_node{
	int ftime;
	int mode;
	struct time_node *next;
} TIME_NODE;


/* options */

#define O_FROM_FILE 1
#define O_INTERACTIVE 2
#define O_CHECK 4
#define O_COPY_ALL 8
#define O_RECURSIVE 0x10
#define O_SOURCE_DIR 0x20
#define O_TARGET_DIR 0x40
#define O_VERBOSE 0x80
#define O_X_VERBOSE 0x100
#define O_MOVE 0x200
#define O_COPY_IF_SRC_OLDER 0x400
#define O_CP_IF_SRC_NEWER 0x800
#define O_COPY_HIDDEN 0x1000
#define O_DATE_CHECK 0x2000
#define O_TIME_CHECK 0x4000
#define O_GATHER 0x8000
#define O_BATCH 0x10000L
#define O_FROM_STDIN 0x20000L
#define O_TARGET_REMOVEABLE 0x40000L
#define O_ARCHIVE 0x80000L
#define O_LARGEFILES 0x100000L
#define O_ZAPTARGET 0x200000L
#define O_JOIN 0x400000L


#define USAGE_MESS "docp - Directory-Oriented CoPy, version 1.1\n\
Copyright (c) 1992, Roy Bixler\n\
    \"docp\" comes with ABSOLUTELY NO WARRANTY; for details type `docp -?'.\n\
    This is free software, and you are welcome to redistribute it\n\
    under certain conditions.\n\n\
Usage:\tdocp [-abcdfghijlmnorstvwz?] source_dir target_dir [file list]\n\
    -a - copy only files with archive bit set\n\
    -b - batch mode\n\
    -c - checks which files will be copied\n\
    -d date_range (e.g. ao3/31/91) - copies files within date range\n\
    -f filename - gets file list from filename\n\
    -g - gather files recursively, but do not create subdirectories\n\
    -h - copies hidden files also\n\
    -i - interactively confirms copying each file\n\
    -j - join files.  Append source to target (instead of overwriting target)\n\
    -l - split large files if target is full\n\
    -m - moves files\n\
    -n - only copies newer files\n\
    -o - only copies older files\n\
    -no - only copies files not in target directory\n\
    -r - recursively copies subdirectories as well\n\
    -s - gets reference list from source directory\n\
    -t - gets reference list from target directory\n\
    -v - verbose, reports files copied\n\
    -vv - extra verbose, reports files copied and not copied\n\
    -w time_range (e.g. bo1:34pm) - copies files within time range\n\
    -z - zap the target before copying\n\
    -? - shows more complete information on 'docp'\n"
