/*
 EPSHeader

   File: save_mod.e
   Author: J. Kercheval
*/

/*
 EPSRevision History

   J. Kercheval  Sat, 10/24/1990  21:58:03  comment and explain
   J. Kercheval  Sat, 10/25/1990  00:01:45  set mark before updating headers
   J. Kercheval  Sat, 11/04/1990  22:38:35  add break to date switch (bug fix)
*/

/* 

    This command implements a simple and convenient tracking function
    for internal to file creation and revision tracking messages which
    allow input in addition to the standard revision control system
    comments allowed by products such as TLib or PVCS.
        
    This is designed as a replacement for save_file() which behaves
    slightly differently for certian file suffixes.
        
    On first save with this routine a header is created using the file
    name, the newly defined buffer variable author which is up to 80
    characters of name, and the time of creation.  In addition, a hook
    is called when the header block is created to allow specification
    of copyright notices or company headers or ... or ... etc.
        
    On second invocation this routine asks for a comment to insert in 
    a revision history block and inserts the author, the date, and the
    comment in the revision block.
        
    The routine asks before doing the above.  The non-special suffixed
    files are passed normally to save_file() and nothing occurs if the
    file was not modified.
        
        John Kercheval
        127 NW Bowdoin Pl #105
        Seattle, WA  98107-4960
        October 24, 1990
            
*/
    
#include "eel.h"

#define boolean int
#define TRUE 1
#define FALSE 0

/* buffer dependent author globally defined */

buffer char author_name[80] = "";

/* helper routine to obtain current day, date, time */

char *datestr(timestr)
  char *timestr;
{
  struct time_info time;
  char dow[4];
  
  time_and_day(&time);
  switch (time.day_of_week) {
    case 0: 
        strcpy(dow,"Sun");
        break;
    case 1: 
        strcpy(dow,"Mon");
        break;
    case 2: 
        strcpy(dow,"Tue");
        break;
    case 3: 
        strcpy(dow,"Wed");
        break;
    case 4: 
        strcpy(dow,"Thu");
        break;
    case 5: 
        strcpy(dow,"Fri");
        break;
    case 6:
        strcpy(dow,"Sat");
        break;
  }
  sprintf(timestr,"%s, %02d/%02d/%4d  %02d:%02d:%02d",
    dow,time.month,time.day,time.year,
    time.hour,time.minute,time.second);
  
  return(timestr);
}

/* user routine to save a file only if modified and to both place an initial 
   time stamp and/or to place a revision date and comment */

command save_modified_file()
{
  char comment_open[4];
  char comment_close[4];
  char response[80];
  char tmpfile[20];
  char time[30];
  int tmpint;
  boolean check;
  
  /* save only if file is modified */
  
  if (modified) {

    /* establish qualifications for revision update */

    check = FALSE;
    if (!strcmp(get_extension(filename),".c") ||
      !strcmp(get_extension(filename),".h") ||
      !strcmp(get_extension(filename),".e") ||
      !strcmp(get_extension(filename),".y")) {
        strcpy(comment_open,"/*");
        strcpy(comment_close,"*/");
        check = TRUE;
    }
    if (!strcmp(get_extension(filename),".pas")) {
      strcpy(comment_open,"{");
      strcpy(comment_close,"}");
      check = TRUE;
    }

    /* if qualified then prompt for verification */

    if (check) {
      strcpy(tmpfile,get_tail(filename,0));
      get_strdef(response,"Update revision information?","y");
      
      /* if user wants revision update then check for stamp, call hook,
        and prompt for revision message */
      
      if (!strnfcmp(response,"Y",1)) {
        mark = point;
        point = 0;
        if (!search(1,"EPSHeader")) {
          point = 0;
          bprintf("%s\n EPSHeader\n\n   File: %s\n   Author: %s\n",
                  comment_open,tmpfile,author_name);
          bprintf("   Created: %s\n%s\n\n",
                  datestr(time),comment_close);
          try_calling("revision-update-header-hook");
        }
        else {
          point = 0;
          search(1,"EPSHeader");
          search(1,comment_close);
          tmpint = point;
          if (!search(1,"EPSRevision")) {
            point = tmpint;
            bprintf("\n%s\n EPSRevision History\n\n%s",
              comment_open,comment_close);
          }
          point = 0;
          get_string(response,"Revision comment: ");
          search(1,"EPSRevision History");
          search(1,comment_close);
          to_begin_line();
          bprintf("   %s  %s  %s\n",author_name,datestr(time),response);
        }
      }
    }
    save_file();
  }
  else say("File was not modified.");
}
