/*
 * Name:	Mg 2a
 *		IBM BIOS keyboard driver (TurboC 1.5)
 *
 */

#include	"def.h"
#include	<dos.h>

#ifdef MSC
#include	<bios.h>
#endif /* MSC */

#define KMETA	METABIT

char	*keystrings[] = {
	"Home",		"Down-Arrow",	"Up-Arrow",	"Left-Arrow",
	"Right-Arrow",	"Page-Up",	"Page-Down",	"End",
	"Delete",	"Insert",	"Control-Left", "Control-Right",
	"Control-PgUp",	"Control-PgDn",	"Control-Home",	"Control-End",
	"F1",		"F2",		"F3",		"F4",
	"F5",		"F6",		"F7",		"F8",
	"F9",		"F10",		"FS1",		"FS2",
	"FS3",		"FS4",		"FS5",		"FS6",
	"FS7",		"FS8",		"FS9",		"FS10",
	"FC1",		"FC2",		"FC3",		"FC4",
	"FC5",		"FC6",		"FC7",		"FC8",
	"FC9",		"FC10",
};

/* convert IBM bios extended scan codes to appropriate function key values */
static KCHAR extended[] = {
	-1,		-1,		-1,		0,	  /* 0-3 */
	-1,		-1,		-1,		-1,	  /* 4-7 */
	-1,		-1,		-1,		-1,	  /* 8-11 */
	-1,		-1,		-1,		-1,	  /* 12-15 */
	KMETA|'Q',	KMETA|'W',	KMETA|'E',	KMETA|'R',/* 16-19 */
	KMETA|'T',	KMETA|'Y',	KMETA|'U',	KMETA|'I',/* 20-23 */
	KMETA|'O',	KMETA|'P',	-1,		-1,	  /* 24-27 */
	-1,		-1,		KMETA|'A',	KMETA|'S',/* 28-31 */
	KMETA|'D',	KMETA|'F',	KMETA|'G',	KMETA|'H',/* 32-35 */
	KMETA|'J',	KMETA|'K',	KMETA|'L',	-1,	  /* 36-39 */
	-1,		-1,		-1,		-1,	  /* 40-43 */
	KMETA|'Z',	KMETA|'X',	KMETA|'C',	KMETA|'V',/* 44-47 */
	KMETA|'B',	KMETA|'N',	KMETA|'M',	-1,	  /* 48-51 */
	-1,		-1,		/* oops - miscounted */	  /* 52-53 */
	-1,		-1,		-1,		-1,	  /* 54-57 */
	-1,		KF1,		KF2,		KF3,	  /* 58-61 */
	KF4,		KF5,		KF6,		KF7,	  /* 62-65 */
	KF8,		KF9,		KF10,		-1,	  /* 66-69 */
	-1,		KHOME,		KUP,		KPGUP,	  /* 70-73 */
	-1,		KLEFT,		-1,		KRIGHT,	  /* 74-77 */
	-1,		KEND,		KDOWN,		KPGDN,	  /* 78-81 */
	KINSERT,	KDELETE,	KSF1,		KSF2,	  /* 82-85 */
	KSF3,		KSF4,		KSF5,		KSF6,	  /* 86-89 */
	KSF7,		KSF8,		KSF9,		KSF10,	  /* 90-93 */
	KCF1,		KCF2,		KCF3,		KCF4,	  /* 94-97 */
	KCF5,		KCF6,		KCF7,		KCF8,	  /* 98-101 */
	KCF9,		KCF10,		KMETA|KF1,	KMETA|KF2,/* 102-105 */
	KMETA|KF3,	KMETA|KF4,	KMETA|KF5,	KMETA|KF6,/* 106-109 */
	KMETA|KF7,	KMETA|KF8,	KMETA|KF9,	KMETA|KF10,/* 110-113 */
	-1,		KCLEFT,		KCRIGHT,	KCEND,	  /* 114-117 */
	KCPGDN,		KCHOME,		KMETA|'1',	KMETA|'2',/* 118-121 */
	KMETA|'3',	KMETA|'4',	KMETA|'5',	KMETA|'6',/* 122-125 */
	KMETA|'7',	KMETA|'8',	KMETA|'9',	KMETA|'0',/* 126-129 */
	KMETA|'-',	KMETA|'=',	KCPGUP,			  /* 130-132 */
};

#define NEXTENDED (sizeof(extended)-sizeof(KCHAR))

static KCHAR savedkey = -1;

getkbd() {
    return (ttgetc());
}

/*
 * Get keyboard character, and interpret
 * any special keys on the keyboard.
 */
ttgetc() {
    KCHAR temp;

    while (savedkey == -1)
	getakey();

    temp = savedkey;
    savedkey = -1;
    return temp;
}

getakey() {
    union REGS rg;

    rg.h.ah = 0;		/* read keyboard */
    int86(0x16, &rg, &rg);
    if (rg.h.al) {
	if (rg.h.al == '\b' && rg.h.ah == 0x0E)
	    rg.h.al = 0x7F;	/* transform backspace key into delete */
				/* control H is still backspace */
	savedkey = rg.h.al;	/* normal key value */
    }
    else {
	if (rg.h.ah >= NEXTENDED)
	    savedkey = -1;
	else
	    savedkey = extended[rg.h.ah];
    }
}

pollkbd()
{
#ifdef MSC
    return _bios_keybrd(_KEYBRD_READY);
#else
    return bioskey(1);
#endif /* MSC */
}

typeahead() {
    if (savedkey != -1)
	return 1;
    if (pollkbd())
	getakey();
    return (savedkey != -1);
}

ttykeymapinit() {
    /* mg 2a no longer lets me easily bind things at run time. */
    /* instead, I make up a keymap, and link it in at compile time */
}

extern	int	gotobol();		/* Move to start of line	*/
extern	int	backchar();		/* Move backward by characters	*/
extern	int	gotoeol();		/* Move to end of line		*/
extern	int	forwchar();		/* Move forward by characters	*/
extern	int	gotobob();		/* Move to start of buffer	*/
extern	int	gotoeob();		/* Move to end of buffer	*/
extern	int	gotobop();		/* Move to start of display page*/
extern	int	gotoeop();		/* Move to end of display page	*/
extern	int	forwline();		/* Move forward by lines	*/
extern	int	backline();		/* Move backward by lines	*/
extern	int	forwpage();		/* Move forward by pages	*/
extern	int	backpage();		/* Move backward by pages	*/
extern	int	openline();		/* Open up a blank line		*/
extern	int	forwdel();		/* Forward delete		*/
extern	int	rescan();		/* for unmapped keys		*/
extern	int	backword();		/* Backup by words		*/
extern	int	forwword();		/* Advance by words		*/
extern	int	killline();		/* Kill forward			*/

PF	ibm_keys[] = {
	gotobol,	/* Home			(0x100)	*/
	forwline,	/* Down				*/
	backline,	/* Up				*/
	backchar,	/* Left				*/
	forwchar,	/* Right			*/
	backpage,	/* Page Up			*/
	forwpage,	/* Page Dn			*/
	gotoeol,	/* End				*/
	forwdel,	/* Delete			*/
	openline,	/* Insert			*/
	backword,	/* Control Left			*/
	forwword,	/* Control Right		*/
	gotobob,	/* Control PgUp           	*/
	gotoeob,	/* Control PgDn         	*/
	gotobop,	/* Control HOME			*/
	gotoeop,	/* Control END			*/

	/* function keys - initially unassigned */
	rescan, rescan, rescan, rescan,
	rescan, rescan, rescan, rescan,
	rescan, rescan, rescan, rescan,
	rescan, rescan, rescan, rescan,
	rescan, rescan, rescan, rescan,
	rescan, rescan, rescan, rescan,
	rescan, rescan, rescan, rescan,
	rescan, rescan,
};
