#
# Makefile for Amiga MG 2x, using Manx small model.
#
# This Makefile should be executed in the main Emacs directory.
#
# System-dependent conditional compilation possibilities:
#
# V11  -- must be defined for the editor to either run on
#      or compile on a version 1.1 AmigaDOS system.
#      It mainly wards against bugs in the 1.1 ROM
#      Kernel.
#
# NO_STARTUP -- if defined, code for using a startup file
#      is not included.
#
# MENU  -- if defined, Intuition menu selection is
#      enabled.  If you #define this, the XOBJ macro
#      must contain $(MENUOBJ).
#
# BROWSER  -- BROWSER uses the Amiga menu to present a MENU of
#      files. Selecting a directory entry (ends with a /)
#      makes the contents if that directory the next menu
#      (deleting any menus that used to follow it);
#      selecting a plain file does a "find-file" on that
#      file name. Really has to be seen to be understood.
#      XOBJ must contain $(MENUOBJ) for this to link.
#
# MOUSE  -- if defined, the Amiga mouse is active.
#      If you #define this, XOBJ must contain $(MOUSEOBJ)
#
# FKEYS  -- if defined, the editor understands the Amiga
#      function keys.
#
# NO_BACKUP -- Disable the creation of backup files. If this
#      option is defined, the function make-backup-files
#      sets a flag that causes save-buffers (C-x C-s)
#      to rename the original file to file~ before
#      writing the file.  Nice if the space is available.
#      By default, backup files are not made.  Calling
#      make-backup-files with no argument enables this
#      feature; calling it with an argument disables it.
#
# DO_METAKEY -- if defined, characters with high bit set (i.e.
#      most ALT-ed characters in the usa0 keymap)
#      are translated into internal META keys
#
# DO_ICONIFY -- if defined, provide a function to iconify the Emacs
#      window into a gadget that can be double-clicked to
#      return to the normal display.
#
# CHANGE_COLOR -- if defined, adds commands to manipulate
#      the rendition of the mode line and the
#      foreground and background color of the
#      text window and mode line.  The names match
#      the regular expression
#      set-{text,mode}-{foreground,background}
# CHANGE_FONT -- if defined, adds "set-font", which prompts
#      for a font name and size, then tries to reopen
#      the Emacs window using the new font.
# USE_ARP  -- Use the ARP (AmigaDOS Replacement Library) for
#      some functions.  This makes the executable
#      slightly smaller, but gives no new functionality
#      in the current version.  It will probably be
#      required for some future version.  Note that
#      LIBS needs to be changed to "-la -lc" if you
#      use ARP.
#
#
# MODE_RENDITION -- the these values indicate the way to render
# TEXT_RENDITION    characters in the text area and mode line.
#      TEXT_RENDITION is mainly there for completeness.
#      Possible values are:
#    0 -- plain text
#    1 -- boldface
#    3 -- italic
#    4 -- underscore
#    7 -- reverse-video (default if not defined)
#
# TEXT_FG  -- specifies which system color (0-7) to use
# TEXT_BG     when drawing the text and mode line.  If they
# MODE_FG     aren't between 0 and 7, or if a combination
# MODE_BG     comes out badly, it's *YOUR* fault.  If
#      CHANGE_COLOR is defined, you get to change these
#      values on the fly.  Naturally, making both
#      FG and BG the same results in an unusable display...
#
############################################################################
SYS = amiga
S = sys/amiga
LIBS = -lc

#
# PREFS contains the defines used to select compile-time options.
# XOBJ is used to denote any extra object files needed for these
# options.  MENUOBJ and MOUSEOBJ denote the extra object files
# needed for the menu, mouse and Browser.

MOUSEOBJ = ttymouse.o
MENUOBJ  = ttymenu.o menustack.o
OFFSETOBJ = offset.o
ICONIFYOBJ = iconify.o ttyicon.o

# The big burrito, with the Browser *and* the editing MENU.  Tough
# on space, but boy is it neat...
PREFS = -DSTARTUP -DDO_METAKEY -DDO_ICONIFY -DCHANGE_FONT -DCHANGE_COLOR \
 -DBACKUP -DFKEYS -DMOUSE -DMENU -DBROWSER
XOBJ  = $(MOUSEOBJ) $(MENUOBJ) $(ICONIFYOBJ)

# Burrito style, with just the Browser...
#PREFS = -DSTARTUP  -DBROWSER -DMOUSE -DCHANGE_COLOR -DFKEYS -DDO_ICONIFY -DDO_M
#XOBJ  = $(MOUSEOBJ) $(MENUOBJ) $(OFFSETOBJ) $(ICONIFYOBJ)

# Burrito style, with just the menu...
#PREFS = -DSTARTUP  -DMENU -DMOUSE -DCHANGE_COLOR -DFKEYS -DDO_ICONIFY -DDO_META
#XOBJ  = $(MOUSEOBJ) $(MENUOBJ) $(OFFSETOBJ) $(ICONIFYOBJ)


# Mike's favorite version
#PREFS = -DMOUSE -DBROWSER -DMODE_RENDITION=0 -DMODE_FG=2 -DDO_METAKEY \
# -DGOSREC -DV11 -DMEYN
#XOBJ = $(MOUSEOBJ) $(MENUOBJ)

# Mic's favorite version
#PREFS = -DSTARTUP -DMENU -DMOUSE -DCHANGE_FONT -DFKEYS
# -DDO_METAKEY -DDO_ICONIFY -DBACKUP -DPREFIXREGION
#XOBJ  = $(MOUSEOBJ) $(MENUOBJ) $(OFFSETOBJ) $(ICONIFYOBJ)

# Steve's favorite version
#PREFS  = -DSTARTUP -DMOUSE -DCHANGE_FONT -DFKEYS -DDO_METAKEY \
#  -DBACKUP -DPREFIXREGION -DUSE_ARP
#XOBJ   = $(MOUSEOBJ)
# Notice the "-la" here to use ARP's library as well as the standard one.
#LIBS = -la -lc

# Absolutely bare-bones, default editor
#PREFS = -DDO_METAKEY
#XOBJ  =

CFLAGS = -I$(S) -Isys/default $(PREFS) -DAMIGA -DMANX -DBINDKEY

# Objects which only depend on the "standard" includes
OBJS = basic.o dir.o dired.o file.o line.o match.o paragraph.o \
   random.o region.o search.o version.o window.o word.o

# Those with unique requirements
IND = buffer.o display.o echo.o extend.o help.o kbd.o keymap.o \
   macro.o main.o modes.o regex.o re_search.o

# System dependent objects
OOBJS = cinfo.o spawn.o ttyio.o tty.o ttykbd.o fileio.o sleep.o \
 sysinit.o malloc.o console.o dirio.o

OBJ = $(OBJS) $(IND) $(OOBJS) $(XOBJ)

OSRCS = cinfo.c fileio.c spawn.c ttyio.c tty.c ttykbd.c fileio.c sleep.c \
   sysinit.c malloc.c console.c dirio.c
SRCS = basic.c dir.c dired.c file.c line.c match.c paragraph.c \
   random.c region.c search.c version.c window.c word.c \
   buffer.c display.c echo.c extend.c help.c kbd.c keymap.c \
   macro.c main.c modes.c regex.c re_search.c

OINCS = $(S)/ttydef.h $(S)/sysdef.h sys/default/chrdef.h
INCS = def.h


#
# The editor
# Building in Ram: saves a LOT of time in pass 2 of the linker.
#
mg:		$(OBJ)
		ln -o ram:mg -w $(OBJ) $(LIBS)
		copy ram:mg mg
		delete ram:mg

lint:
	lint +vm -ilint: -e7?? $(CFLAGS) std.lnt mg

$(OBJ):		$(INCS) $(OINCS)

dir.o search.o:	$(INCS) $(OINCS)

regex.o re_search.o:	$(INCS) $(OINCS) regex.h

kbd.o:	$(INCS) $(OINCS) macro.h kbd.h key.h

macro.o main.o:	$(INCS) $(OINCS) macro.h

buffer.o display.o keymap.o help.o modes.o dired.o fileio.o: \
	$(INCS) $(OINCS) kbd.h

extend.o:	$(INCS) $(OINCS) kbd.h macro.h key.h

help.o:	$(INCS) $(OINCS) kbd.h key.h macro.h

echo.o:	$(INCS) $(OINCS) key.h macro.h

$(OOBJS):	$(INCS) $(OINCS)

clean:
	Delete $(OBJ)


fileio.o:	$(S)/fileio.c
		cc $(CFLAGS) -o fileio.o $(S)/fileio.c

spawn.o:	$(S)/spawn.c
		cc $(CFLAGS) -o spawn.o $(S)/spawn.c

sleep.o:	$(S)/sleep.c
		cc $(CFLAGS) -o sleep.o $(S)/sleep.c

sysinit.o:	$(S)/sysinit.c
		cc $(CFLAGS) -o sysinit.o $(S)/sysinit.c

malloc.o:	$(S)/malloc.c
		cc $(CFLAGS) -o malloc.o $(S)/malloc.c

offset.o:	$(S)/offset.c
		cc $(CFLAGS) -o offset.o $(S)/offset.c

iconify.o:	$(S)/iconify/iconify.c $(S)/iconify/iconify.h
		cc $(CFLAGS) -I$(S)/iconify -o iconify.o $(S)/iconify/iconify.c

tty.o:		$(S)/tty.c
		cc $(CFLAGS) -o tty.o $(S)/tty.c

ttyicon.o:	$(S)/ttyicon.c
		cc $(CFLAGS) -I$(S)/iconify -o ttyicon.o $(S)/ttyicon.c

ttyio.o:	$(S)/ttyio.c
		cc $(CFLAGS) -o ttyio.o $(S)/ttyio.c

ttykbd.o:	$(S)/ttykbd.c
		cc $(CFLAGS) -o ttykbd.o $(S)/ttykbd.c

ttymenu.o:	$(S)/ttymenu.c
		cc $(CFLAGS) -o ttymenu.o $(S)/ttymenu.c

ttymouse.o:	$(S)/ttymouse.c
		cc $(CFLAGS) -o ttymouse.o $(S)/ttymouse.c

menustack.o:	$(S)/menustack.c
		cc $(CFLAGS) -o menustack.o $(S)/menustack.c

console.o:	$(S)/console.c
		cc $(CFLAGS) -o console.o $(S)/console.c

dirio.o:	$(S)/dirio.c
		cc $(CFLAGS) -o dirio.o $(S)/dirio.c

arpbind.o:	$(S)/arpbind.asm $(S)/arpbase.i
		as -o arpbind.o -I$(S) -Isys2:asm $(S)/arpbind.asm

alloca.o:	$(S)/alloca.asm
		as -o alloca.o $(S)/alloca.asm

keymap.o:	keymap.c $(S)/amiga_maps.c
		cc $(CFLAGS) -Z4000 keymap.c

cinfo.o:	sys/default/cinfo.c
		cc $(CFLAGS) -o cinfo.o sys/default/cinfo.c
