/* shrink.c: shrink a bitmap */

#include <stdio.h>
#include "dvi.h"
#include "pxl.h"
#include "general.h"
#include "local.h"
#include "bitorder.h"

#ifdef MSBITFIRST
#define bitMask(n) (1<<(BYTESIZE-1-(n)))
#define bitMask2(n) (1<<(BYTESIZE*2-1-(n)))
#define nextBitMask(bmask) ((bmask)>>1)
#define catBits(b0,b1) (((b0)<<BYTESIZE)+(b1))
#else
#define bitMask(n) (1<<(n))
#define bitMask2(n) (1<<(n))
#define nextBitMask(bmask) ((bmask)<<1)
#define catBits(b0,b1) (((b1)<<BYTESIZE)+(b0))
#endif

int density_factor = 5;  /* personal prefernce (was 3) (GBP) */

sample(bitmap, x, y, w, h)
	register struct bitmap *bitmap;
	int x, y, w, h;
{
	register BYTE *ptr, *endp;
	register unsigned long m, bits, b;
	register int i, j, n;

	ptr = (BYTE*) (bitmap->bits
			+ (y * bitmap->bytes_wide)
			+ (x / BYTESIZE)*(BYTESIZE/BITS_PER_BYTE));
	endp = (BYTE*) (bitmap->bits + (bitmap->h * bitmap->bytes_wide));
	b = bitMask2(x % BYTESIZE);
	n = 0;
	for (i = 0;
	     i < h && ptr < endp;
	     i += 1, ptr += bitmap->bytes_wide/(BYTESIZE/BITS_PER_BYTE)) {
		/* this should make up to s==BYTESIZE work ok */
		bits = catBits(ptr[0], ptr[1]);
		for (m = b, j = 0; j < w; j += 1, m = nextBitMask(m))
			if (bits & m)
				n += 1;
	}
        return ((n>0) &&
                density_factor?(n >= (i * w) / density_factor):n); /* was 3 */
}

shrink_graymap(bitmap, x_factor, y_factor)
	register struct bitmap *bitmap;
	int x_factor, y_factor;
{
	BYTE *shrunk_bits;
	unsigned int shrunk_height, shrunk_width, shrunk_bytes_wide;
	register BYTE *ptr;
	BYTE *cp;
	register unsigned int b, m;
	register int x, y, sx, sy, xw, yw;
	static int masks[4] = {0x80, 0x20, 0x08, 0x02};

	shrunk_height = ROUNDUP(bitmap->h, y_factor);
	shrunk_width = ROUNDUP(bitmap->w*4, x_factor);
	shrunk_bytes_wide = ROUNDUP(bitmap->w, x_factor);
	ptr = shrunk_bits = (BYTE*) malloc(shrunk_height*shrunk_bytes_wide);
	if (ptr == NULL)
		error("Can't allocate shrunken graymap (%d by %d)",
			shrunk_height, shrunk_width);
	for (y = sy = 0; sy < shrunk_height*2; sy++, y += y_factor) {
		b = 0;
		cp = ptr;
		yw = ((y+y_factor)>>1) - y>>1;
		if (yw==0) yw=1;
		for (x = 0; x < shrunk_width; x += (x_factor<<1)) {
			m = masks[x&0x3];
			if (sy&1) m >>= 1;
			sx = (x>>2);
			xw = ((x+x_factor)>>2) - sx;
			if (xw==0) xw=1;
			if (sample(bitmap, x>>2, y>>1, xw, yw))
				*ptr |= m;
			else
				*ptr &= ~m;
			b += 1;
			m >>= 1;
			if (b >= BYTESIZE) {
				b = 0;
				m = bitMask(0);
				ptr += 1;
			}
		}
		ptr = cp + shrunk_bytes_wide;
	}
	free(bitmap->bits);
	bitmap->bits = (char*) shrunk_bits;
	bitmap->h = shrunk_height;
	bitmap->w = shrunk_width*2;
	bitmap->bytes_wide = shrunk_bytes_wide;
}

shrink_bitmap(bitmap, x_factor, y_factor)
	register struct bitmap *bitmap;
	int x_factor, y_factor;
{
	BYTE *shrunk_bits;
	unsigned int shrunk_height, shrunk_width, shrunk_bytes_wide;
	register BYTE *ptr;
	BYTE *cp;
	register unsigned int b, m;
	register int x, y;

	shrunk_height = ROUNDUP(bitmap->h, y_factor);
	shrunk_width = ROUNDUP(bitmap->w, x_factor);
	shrunk_bytes_wide = ROUNDUP(shrunk_width, BYTESIZE)
				*(BYTESIZE/BITS_PER_BYTE);
	ptr = shrunk_bits = (BYTE*) malloc(shrunk_height*shrunk_bytes_wide);
	if (ptr == NULL)
		error("Can't allocate shrunken bitmap (%d by %d)",
			shrunk_height, shrunk_width);
	for (y = 0; y < bitmap->h; y += y_factor) {
		b = 0;
		m = bitMask(0);
		cp = ptr;
		for (x = 0; x < bitmap->w; x += x_factor) {
			if (sample(bitmap, x, y, x_factor, y_factor))
				*ptr |= m;
			else
				*ptr &= ~m;
			b += 1;
			m = nextBitMask(m);
			if (b >= BYTESIZE) {
				b = 0;
				m = bitMask(0);
				ptr += 1;
			}
		}
		ptr = cp + shrunk_bytes_wide/(BYTESIZE/BITS_PER_BYTE);
	}
	free(bitmap->bits);
	bitmap->bits = (char*) shrunk_bits;
	bitmap->h = shrunk_height;
	bitmap->w = shrunk_width;
	bitmap->bytes_wide = shrunk_bytes_wide;
}
