' Boxes game v1.0 02/20/1998 (c)ejo
' Instructions: Load in QB v4.5
'    Use left and right shift to control paddle.
DEFSNG A-Z
REM $DYNAMIC
DIM Num AS INTEGER, Game AS INTEGER
Game = 0
GOSUB Display.Screen
DO
   x$ = INKEY$
   IF x$ = CHR$(27) THEN
      EXIT DO
   END IF
   DEF SEG = &H40
   i = PEEK(&H17)
   DEF SEG
   IF (i AND 1) = 1 THEN
      GOSUB Move.Right
   END IF
   IF (i AND 2) = 2 THEN
      GOSUB Move.Left
   END IF
   q = q + 1
   IF q > 100 THEN
      q = 0
      GOSUB Move.Ball
      GOSUB Redraw.Ball
   END IF
   IF Num <= 0 THEN
      Game = Game + 1
      IF Game > 3 THEN
         EXIT DO
      END IF
      LOCATE 24, 1, 1
      PRINT "Press any key to continue:";
      WHILE INKEY$ = "": WEND
      GOSUB Display.Screen
   END IF
LOOP
END

Display.Screen:
CLS
SCREEN 1
p = 130 ' paddle position
bx = 146 ' ball x-coor
by = 100 ' ball y-coor
dx = 0 ' direction x
dy = 1 ' direction y
Num = 80 ' number of boxes
FOR l = 1 TO 20 ' twenty boxes across
   FOR m = 1 TO 4 ' four boxes high
      FOR n = 1 TO 15 ' box width
         x = (l - 1) * 16 + n
         FOR o = 1 TO 10 ' box heigth
            y = (m - 1) * 11 + o
            PSET (x, y), 1
         NEXT
      NEXT
   NEXT
NEXT
SELECT CASE Game
CASE 1
   Num = 73
   FOR l = 1 TO 20 STEP 3
      m = 4 ' box row four
      FOR n = 1 TO 15 ' box width
         x = (l - 1) * 16 + n
         FOR o = 1 TO 10 ' box heigth
            y = (m - 1) * 11 + o
            PSET (x, y), 2
         NEXT
      NEXT
   NEXT
CASE 2
   Num = 66
   FOR l = 1 TO 20 STEP 3
      FOR m = 2 TO 4 STEP 2
         FOR n = 1 TO 15 ' box width
            x = (l - 1) * 16 + n
            FOR o = 1 TO 10 ' box heigth
               y = (m - 1) * 11 + o
               PSET (x, y), 2
            NEXT
         NEXT
      NEXT
   NEXT
CASE 3
   Num = 60
   FOR l = 1 TO 20 STEP 2
      FOR m = 2 TO 4 STEP 2
         FOR n = 1 TO 15 ' box width
            x = (l - 1) * 16 + n
            FOR o = 1 TO 10 ' box heigth
               y = (m - 1) * 11 + o
               PSET (x, y), 2
            NEXT
         NEXT
      NEXT
   NEXT
END SELECT
' draw paddle
FOR l = p TO p + 30
   PSET (l, 190), 2
NEXT
RETURN

Move.Right:
IF p < 290 THEN
   q = q + 50
   FOR l = 1 TO 30
      PSET (l + p - 1, 190), 0
   NEXT
   p = p + 2
   FOR l = 1 TO 30
      PSET (l + p, 190), 2
   NEXT
END IF
RETURN

Move.Left:
IF p > 3 THEN
   q = q + 50
   FOR l = 1 TO 30
      PSET (l + p, 190), 0
   NEXT
   p = p - 2
   FOR l = 1 TO 30
      PSET (l + p, 190), 2
   NEXT
END IF
RETURN

Move.Ball:
GOSUB Erase.Ball
' increment ball coordinates
bx = bx + dx
by = by + dy
' ball bounces off side of screen
IF dx < 0 THEN
   IF bx <= 2 THEN
      dx = -dx
   END IF
ELSE
   IF dx > 0 THEN
      IF bx > 318 THEN
         dx = -dx
      END IF
   END IF
END IF
' ball going down
IF dy > 0 THEN
   ' check ball hitting paddle
   IF by >= 186 THEN
      IF bx >= p AND bx <= (p + 31) THEN ' check paddle bounds
         dy = -dy ' reverse direction
         d = INT(bx - p)
         SELECT CASE d
         CASE 0
            dx = -1 / 1.1
         CASE 1
            dx = -1 / 1.2
         CASE 2
            dx = -1 / 1.3
         CASE 3
            dx = -1 / 1.4
         CASE 4
            dx = -1 / 1.5
         CASE 5
            dx = -1 / 1.6
         CASE 6
            dx = -1 / 1.7
         CASE 7
            dx = -1 / 1.8
         CASE 8
            dx = -1 / 1.9
         CASE 9
            dx = -1 / 2
         CASE 10
            dx = -1 / 2.1
         CASE 11
            dx = -1 / 2.2
         CASE 12
            dx = -1 / 2.3
         CASE 13
            dx = -1 / 2.4
         CASE 14
            dx = -1 / 2.5
         CASE 15
            dx = -1
         CASE 16
            dx = 1 / 2.5
         CASE 17
            dx = 1 / 2.4
         CASE 18
            dx = 1 / 2.3
         CASE 19
            dx = 1 / 2.2
         CASE 20
            dx = 1 / 2.1
         CASE 21
            dx = 1 / 2
         CASE 22
            dx = 1 / 1.9
         CASE 23
            dx = 1 / 1.8
         CASE 24
            dx = 1 / 1.7
         CASE 25
            dx = 1 / 1.6
         CASE 26
            dx = 1 / 1.5
         CASE 27
            dx = 1 / 1.4
         CASE 28
            dx = 1 / 1.3
         CASE 29
            dx = 1 / 1.2
         CASE 30
            dx = 1 / 1.1
         CASE 31
            dx = 1 / 1
         END SELECT
      ELSE
         ' ball falls off bottom of screen
         FOR l = 1 TO 30
            PSET (l + p, 190), 0
         NEXT
         p = 130 ' paddle position
         bx = 146 ' ball x-coor
         by = 100 ' ball y-coor
         dx = 0 ' direction x
         dy = 1 ' direction y
         FOR l = p TO p + 30
            PSET (l, 190), 2
         NEXT
      END IF
      RETURN
   END IF
ELSE
   ' ball going up
   IF dy < 0 THEN
      IF by < 2 THEN
         dy = -dy
         RETURN
      END IF
   END IF
END IF
' ball is below squares
IF by > 48 THEN
   RETURN
END IF
' check ball hit a square from below
fl3 = 0
FOR l = -2 TO 2
   z = POINT(bx + l, by - 3)
   IF z = 1 THEN ' remove square
      bc = INT((bx + l) / 16) + 1 ' calculate box row
      bd = INT((by - 3) / 11) + 1 ' calculate box column
      FOR n = 1 TO 15 ' box width
         x = (bc - 1) * 16 + n
         FOR o = 1 TO 10 ' box heigth
             y = (bd - 1) * 11 + o
             PSET (x, y), 0
         NEXT
      NEXT
      Num = Num - 1
      fl3 = -1
   END IF
NEXT
' check ball hit a permanent square from below
FOR l = -2 TO 2
   z = POINT(bx + l, by - 3)
   IF z = 2 THEN ' avoid square
      fl3 = -1
      EXIT FOR
   END IF
NEXT
' check ball hit a square from above
fl4 = 0
FOR l = -2 TO 2
   z = POINT(bx + l, by + 3)
   IF z = 1 THEN ' remove square
      ' calculate box column
      bc = INT((bx + l) / 16) + 1 ' calculate box row
      bd = INT((by + 3) / 11) + 1 ' caculate box column
      FOR n = 1 TO 15 ' box width
         x = (bc - 1) * 16 + n
         FOR o = 1 TO 10 ' box heigth
            y = (bd - 1) * 11 + o
            PSET (x, y), 0
         NEXT
      NEXT
      Num = Num - 1
      fl4 = -1
   END IF
NEXT
' check ball hit a permanent square from above
FOR l = -2 TO 2
   z = POINT(bx + l, by + 3)
   IF z = 2 THEN ' avoid square
      fl4 = -1
      EXIT FOR
   END IF
NEXT
' check ball hit a square right side
fl1 = 0
FOR l = -2 TO 2
   z = POINT(bx - 3, by + l)
   IF z = 1 THEN ' remove square
      bc = INT((bx - 3) / 16) + 1 ' calculate box row
      bd = INT((by + l) / 11) + 1 ' calculate box column
      FOR n = 1 TO 15 ' box width
         x = (bc - 1) * 16 + n
         FOR o = 1 TO 10 ' box heigth
            y = (bd - 1) * 11 + o
            PSET (x, y), 0
         NEXT
      NEXT
      Num = Num - 1
      fl1 = -1
      EXIT FOR
   END IF
NEXT
' check ball hit a permanent square right side
FOR l = -2 TO 2
  z = POINT(bx - 3, by + l)
  ' avoid square
  IF z = 2 THEN
     fl1 = -1
     EXIT FOR
  END IF
NEXT
' check ball hit a square left side
fl2 = 0
FOR l = -2 TO 2
   z = POINT(bx + 3, by + l)
   IF z = 1 THEN ' remove square
      bc = INT((bx + 3) / 16) + 1 ' calculate box row
      bd = INT((by + l) / 11) + 1 ' calculate box column
      FOR n = 1 TO 15 ' box width
         x = (bc - 1) * 16 + n
         FOR o = 1 TO 10 ' box heigth
            y = (bd - 1) * 11 + o
            PSET (x, y), 0
         NEXT
      NEXT
      Num = Num - 1
      fl2 = -1
      EXIT FOR
   END IF
NEXT
' check ball hit a permanent square left side
FOR l = -2 TO 2
   z = POINT(bx + 3, by + l)
   IF z = 2 THEN ' avoid square
      fl2 = -1
      EXIT FOR
   END IF
NEXT
IF fl1 OR fl2 THEN
   dx = -dx ' reverse direction
END IF
IF fl3 OR fl4 THEN
   dy = -dy ' reverse direction
END IF
RETURN

Erase.Ball:
FOR f = -2 TO 2
   FOR g = -2 TO 2
      z = POINT(bx + f, by + g)
      IF z = 3 THEN
         PSET (bx + f, by + g), 0
      END IF
   NEXT
NEXT
RETURN

Redraw.Ball:
FOR f = -2 TO 2
   FOR g = -2 TO 2
      z = POINT(bx + f, by + g)
      IF z = 0 THEN
         PSET (bx + f, by + g), 3
      END IF
   NEXT
NEXT
RETURN
END

