REM file: Findy.bas - Public Domain DOS Utility
REM Version 1.0a created 06/13/1995
REM Version 1.1a created 03/06/2001

' default integer variables
DEFINT A-Z
REM $DYNAMIC

' define boolean values
CONST True = -1
CONST False = NOT True
CONST TrueD = -1#
CONST FalseD = NOT TrueD
CONST NUL = ""

' define color values
CONST Black = 0
CONST Green = 10
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' declare include files
REM $INCLUDE: 'qbx.bi'

' declare functions
DECLARE FUNCTION ParseLine (S$)
DECLARE FUNCTION BreakIS()
DECLARE FUNCTION ClearBreak()
DECLARE FUNCTION KeyIS()

' declare registers
COMMON SHARED InregsX AS RegtypeX, OutregsX AS RegtypeX

' declare work variables
COMMON SHARED Reverse.Search AS INTEGER, Search.Column AS INTEGER
COMMON SHARED Ignore.Case AS INTEGER, Continuous.Display AS INTEGER
COMMON SHARED Lines.Counted AS INTEGER, List.Lines AS INTEGER
COMMON SHARED Display.Lines AS INTEGER, Line.Number AS INTEGER

' declare command line work variables
COMMON SHARED Command.line AS STRING, Command.Work AS STRING
COMMON SHARED Search.String AS STRING, Input.Line AS STRING
COMMON SHARED Line.Input AS STRING, Char AS STRING
COMMON SHARED Control.Break AS INTEGER

' declare external procedures
DECLARE SUB SetInt
DECLARE SUB RestInt

' backwards compatible for bc 7.1
REM $INCLUDE: 'bc7.inc'

' install new interrupt service routine
CALL SetInt

' declare standard error trap
ON ERROR GOTO Error.Routine

' reset count variables
Lines.Counted = False
Line.Number = False

' command line parser
FUNCTION ParseLine (X$)
 Imbedded = INSTR(Command.Line, LCASE$(X$))
 IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    ParseLine = True
 ELSE
    Imbedded = INSTR(Command.Line, UCASE$(X$))
    IF Imbedded THEN
       Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
       ParseLine = True
    ELSE
       ParseLine = False
    END IF
 END IF
END FUNCTION 

' read command line from PSP
Command.line = NUL
InregsX.AX = &H6200
CALL InterruptX(&H21, InregsX, OutregsX)
PSPsegment = OutregsX.BX
PSPoffset = 128
DEF SEG = PSPsegment
FOR Count = 1 TO 127
   Command.Char = PEEK(PSPoffset + Count)
   SELECT CASE Command.Char
   CASE 0, 10, 13
      EXIT FOR
   CASE ELSE
      Command.line = Command.line + CHR$(Command.Char)
   END SELECT
NEXT
DEF SEG

' store and parse command line
IF Command.line = NUL THEN
   Command.line = ENVIRON$("FINDY")
END IF

' check command line
SELECT CASE Command.line
CASE "/?"
   GOTO Boot.Usage
END SELECT

' locate string to search for
Command.line = RTRIM$(Command.line)
Command.line = LTRIM$(Command.line)
Command.Work = NUL
FOR Count = LEN(Command.line) TO 1 STEP -1
   IF MID$(Command.line, Count, 1) = CHR$(34) THEN
      Command.Work = LEFT$(Command.line, Count - 1)
      Command.line = MID$(Command.line, Count + 1)
      EXIT FOR
   END IF
NEXT
IF LEFT$(Command.Work, 1) = CHR$(34) THEN
   Command.Work = MID$(Command.Work, 2)
ELSE
   GOTO Boot.Usage
END IF
IF Command.Work = NUL THEN
   GOTO Boot.Usage
END IF
Search.String = Command.Work

' check command line switches
Continuous.Display = ParseLine ("/C")
Display.Lines = ParseLine ("/D")
Ignore.Case = ParseLine ("/I")
List.Lines = ParseLine ("/L")
Reverse.Search = ParseLine ("/R")
Control.Break = ParseLine ("/~")

' check command line switch
Imbedded = INSTR(Command.Line, "+")
IF Imbedded THEN
   Search.Column = INT(VAL(MID$(Command.line, Imbedded + 1)))
   IF Search.Column <= False THEN
      GOTO Boot.Usage
   END IF
ELSE
   Search.Column = 1
END IF

' check for case sensitive
IF Ignore.Case THEN
   Search.String = UCASE$(Search.String)
END IF

' check break flag override
IF Control.Break THEN
   Var = ClearBreak
END IF

' search through all redirected input
Line.Input = NUL
Redirected.Input = False
DO

   ' check control break
   IF BreakIS THEN
      EXIT DO
   END IF

   ' check direct console input
   InregsX.AX = &H600
   InregsX.DX = &H0FF
   CALL InterruptX(&H21, InregsX, OutregsX)

   ' check zero flag
   IF (OutregsX.Flags AND &H40) = &H40 THEN
      EXIT DO
   END IF

   ' store input flag
   Redirected.Input = True

   ' store character
   Char = CHR$(OutregsX.AX AND &HFF)

   ' check character
   SELECT CASE ASC(Char)
   CASE 13
   CASE 10
      Line.Number = Line.Number + 1
      Input.Line = Line.Input
      IF Ignore.Case THEN
         Input.Line = UCASE$(Input.Line)
      END IF
      Input.Line = MID$(Input.Line, Search.Column)
      IF INSTR(Input.Line, Search.String) > False THEN
         Lines.Counted = Lines.Counted + 1
         IF List.Lines = False THEN
            COLOR Yellow, Black
            IF Display.Lines THEN
               PRINT MID$(STR$(Line.Number), 2); " ";
            END IF
            PRINT Line.Input
         END IF
      ELSE
         IF Reverse.Search THEN
            Lines.Counted = Lines.Counted + 1
            IF List.Lines = False THEN
               COLOR Yellow, Black
               IF Display.Lines THEN
                  PRINT MID$(STR$(Line.Number), 2); " ";
               END IF
               PRINT Line.Input
            END IF
         END IF
      END IF
      Line.Input = NUL
   CASE ELSE
      Line.Input = Line.Input + Char
   END SELECT
LOOP

' check control break
IF BreakIS THEN
   GOTO End.Findy
END IF

' check filename
IF Redirected.Input = False THEN
   CALL RestInt ' restore Control-Break
   X$=Inkey$ ' quits here
   CALL SetInt ' reset Control-Break
END IF

End.Findy:

IF Continuous.Display = False THEN
   COLOR Yellow, Black
   PRINT "Lines counted"; Lines.Counted
   Prompt$ = "Press <enter> to exit to DOS:"
   CALL MorePrompt(Prompt$, CHR$(13), Outpt$)
END IF
COLOR Plain, Black

' restore key trapping
CALL RestInt

END

Boot.Usage:
 ' restore key trapping
 CALL RestInt
 Var$=Inkey$
 ' make header
 COLOR White, Black
 PRINT "Findy v1.1a: File content search utility; "
 COLOR Yellow, Black
 PRINT "Usage:"
 PRINT "   Findy "; CHR$(34); "string"; CHR$(34); " [/cdilr][+n]"
 PRINT "Where:"
 PRINT "   "; CHR$(34); "search"; CHR$(34); "  is search string"
 PRINT "   /c  continuous list"
 PRINT "   /d  display line number"
 PRINT "   /i  ignore case"
 PRINT "   /l  only list lines counted"
 PRINT "   /r  unmatched search"
 PRINT "   +n  search at column n"
 COLOR Plain, Black
 END

' critical error trap
Error.Routine:
 Data.Error = ERR
 SELECT CASE Data.Error
 CASE 9
    PRINT "Subscript out of range."
    END
 CASE 14
    PRINT "Out of string space."
    END
 CASE 53
    Temp.Outpt$ = "File not found."
 CASE 61
    Temp.Outpt$ = "Disk full."
 CASE 70
    Temp.Outpt$ = "Permission denied."
 CASE 71
    Temp.Outpt$ = "Disk not ready."
 CASE ELSE
    Temp.Outpt$ = "Untrapped error" + STR$(Data.Error) + "."
 END SELECT
 COLOR White, Black
 PRINT Temp.Outpt$
 Prompt$ = "Press R to retry, Q to quit, C to continue:"
 CALL MorePrompt(Prompt$, "rqc", Outpt$)
 IF BreakIS THEN
    Outpt$ = "q"
 END IF
 SELECT CASE Outpt$
 CASE "r"
    RESUME
 CASE "q"
    Error.Level = True
    RESUME End.Findy
 CASE "c"
    OutregsX.Flags = &H1
    RESUME NEXT
 END SELECT
 COLOR Plain, Black
 ' restore key trapping
 CALL RestInt
 END 0

SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
 COLOR White, Black
 PRINT Input.String$ + " ";
 Input.Char$ = NUL
 DO
    LOCATE , , 1
    DO
       IF BreakIS THEN
          EXIT DO
       END IF
       IF KeyIS THEN
          IF OutregsX.AX <> 0 THEN
             InregsX.AX = &H0000
             CALL InterruptX(&H16, InregsX, OutregsX)
             Input.Char$=CHR$(OutregsX.AX AND &HFF)
             EXIT DO
          END IF
       END IF
    LOOP
    IF BreakIS THEN
       EXIT DO
    END IF
    IF LEN(Input.Char$) THEN
       Input.Char$ = LCASE$(Input.Char$)
       IF INSTR(Input.Mask$, Input.Char$) THEN
	  PRINT Input.Char$
	  Output.String$ = Input.Char$
	  EXIT DO
       END IF
    END IF
 LOOP
END SUB

' clears Control-Break flag
FUNCTION ClearBreak
 DEF SEG = &H40
 POKE &H71, &H0
 DEF SEG
 ClearBreak = True
END FUNCTION

' checks Control-Break flag
FUNCTION BreakIS
 STATIC Var AS INTEGER
 IF KeyIS THEN
    IF OutregsX.AX = 0 THEN
       Var = True
    END IF
 END IF
 IF Var THEN
    Continuous.Display = True
 END IF
 BreakIS = Var
END FUNCTION

' checks keyboard buffer
FUNCTION KeyIS
 InregsX.AX = &H0100
 CALL InterruptX(&H16, InregsX, OutregsX)
 IF (OutregsX.Flags AND &H40) = &H40 THEN
    KeyIS = False
 ELSE
    KeyIS = True
 END IF
END FUNCTION
