 REM Subroutine to access long filename directories.

 REM Compiling instructions for VB 1.0:
 REM   VB LONGNAME/O;
 REM   LINK LONGNAME,,NUL,VBDOS.LIB;

 ' default integer variables
 DEFINT A-Z
 REM $DYNAMIC

 ' define boolean values
 CONST True = -1
 CONST False = NOT True
 CONST NUL = ""

 ' declare interrupt structure
 Type RegTypeX
 AX AS Integer
 BX AS Integer
 CX AS Integer
 DX AS Integer
 BP AS Integer
 SI AS Integer
 DI AS Integer
 Flags AS Integer
 DS AS Integer
 ES AS Integer
 End Type
 Declare Sub InterruptX(N AS Integer,I AS RegTypeX,O AS RegTypeX)

 ' declare windows long filename data transfer area
 TYPE WDTAtype
 FileAttr AS STRING * 4
 CreateTime AS STRING * 8
 AccessTime AS STRING * 8
 ModTime AS STRING * 8
 FileSizeHigh AS STRING * 4
 FileSizeLow AS STRING * 4
 Reserved AS STRING * 8
 ASCIZfull AS STRING * 260
 ASCIZshort AS STRING * 14
 END TYPE
 DIM TreeWDTA AS WDTAtype

 ' declare subroutine variables
 DIM Attribute AS INTEGER
 DIM Wfile.Handle AS INTEGER
 DIM ASCIZ.Sub AS STRING * 260

 ' declare registers
 DIM InregsX AS RegTypeX, OutregsX AS RegTypeX

 ' check windows dos
 InregsX.AX = &H160A
 CALL InterruptX(&H2F, InregsX, OutregsX)
 IF OutregsX.AX = False THEN
    Temp = (OutregsX.BX And &HFF00) / 256
    IF Temp >= 4 THEN
       Windows.Detected = True
    END IF
 END IF
 IF Windows.Detected = False THEN
    PRINT "Can't detect long filenames without Windows."
    END
 END IF

 ' specify search files
 ASCIZ.Sub = "*.*" + CHR$(0)

 ' find first filename
 InregsX.AX = &H714E
 InregsX.CX = &H37
 InregsX.SI = &H1
 InregsX.Ds = VARSEG(ASCIZ.Sub)
 InregsX.DX = VARPTR(ASCIZ.Sub)
 InregsX.ES = VARSEG(TreeWDTA)
 InregsX.DI = VARPTR(TreeWDTA)
 CALL InterruptX(&H21, InregsX, OutregsX)
 Wfile.Handle = OutregsX.AX

 ' check find first error
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    END
 END IF

 ' search filenames
 DO

    ' check directory attribute
    Attribute = ASC(TreeWDTA.FileAttr)

    ' check for directory
    IF (Attribute AND &H10) = &H0 THEN

       ' store directory name
       Filename$ = TreeWDTA.ASCIZfull
       Filename$ = LEFT$(Filename$, INSTR(Filename$, CHR$(0)) - 1)

       ' check directory name
       IF Filename$ <> "." AND Filename$ <> ".." THEN

          ' display filename
          PRINT Filename$

       END IF
    END IF

    ' find next long filename
    InregsX.AX = &H714F
    InregsX.BX = Wfile.Handle
    InregsX.SI = &H1
    InregsX.ES = VARSEG(TreeWDTA)
    InregsX.DI = VARPTR(TreeWDTA)
    CALL InterruptX(&H21, InregsX, OutregsX)

    ' check findnext error
    IF (OutregsX.Flags AND &H1) = &H1 THEN
       EXIT DO
    END IF
 LOOP

 ' close long filename search
 InregsX.AX = &H71A1
 InregsX.BX = Wfile.Handle
 CALL InterruptX(&H21, InregsX, OutregsX)
 END
