{
  TEMPS.PAS release 1.00

  Pascal source for the unit 'TEMPS.TPU', french version only.
  Goes with INFODISK.PAS and uses TEMPS.OBJ which is the object code for
  TEMPS.ASM.
  I've compiled it with Turbo Pascal 7.0, but I think that older versions
  (even 4.0) should work too.

  This file may be freely copied or distributed for any non-commercial use.
  If you modify it, please let me know so I can upgrade it easily.

  For any question or suggestion, please e-mail me at :
      p6ip329@cicrp.jussieu.fr     until the middle of September 1995,
  or
      willy@U40024.citi2.fr        after this date.
  (In a future release, I'll give my new address.)

  You can also mail me at home:

      Willy TARREAU
      23, rue Richepanse
      78500 Sartrouville
      FRANCE

      PS: I also accept postcards  :-)

                                                                Willy.

}





UNIT Temps;

{ Permet de compter un temps de 0  24 heures, de 838 ns en 838 ns.
  Comme on peut le constater, cela fait plus de 32 bits.Pour cette raison,
  la variable HeureActuelle contient les heures, et TempsActuel renvoie les
  838 ns.La frquence du PIT est : 14318180/12=1193181.66667 Mhz.
  Une unit de comptage de TempsActuel est donc de :
   1/1193181.66667 = 838.0953445 ns.

  Les variables HeureInitiale et TempsInitial sont ajustes par TempsAZero.

}

INTERFACE

{ variables partages par les routines assembleur }

var HeureInitiale,HeureActuelle : word;
    TempsInitial : longint;


Procedure InitPIT;
{   obligatoire au moins 1 fois : met le compteur 0 du 8253 en mode RYTHME,
    ce qui permet de lire le compte en vol.La frquence n'est pas change.
    L'horloge est donc prserve. }

Procedure TempsAZero;
{   Rajuste les variables TempsInitial et HeureInitial au temps courant }


Function  TempsActuel : longint;
{   Mesure le temps depuis TempsAZero.Renvoie le nombre d'impulsions de
    838 ns }

Procedure InitTemps;
{   Initialise le PIT et les variables de temps }

Function SecEnReel : real;
{   Retourne le temps coul depuis InitTemps en secondes }

IMPLEMENTATION

{$L TIMER.OBJ}

Procedure InitPIT;              external;
Procedure TempsAZero;           external;
Function  TempsActuel : longint;external;


{***************************************************************}
{************** Dbut des routines en Pascal *******************}

{***** Initialise le PIT et les variables de temps *****}
Procedure InitTemps;
begin
  InitPIT;           { rinitialise PIT (unit temps) }
  TempsAZero;        { et les variables de comptage   }
end;  { Fin de InitTemps }

{***** Retourne le temps coul depuis InitTemps en secondes *****}
Function SecEnReel : real;
begin
  SecEnReel:=TempsActuel*838.09534452/1E9;
end;  { Fin de SecEnReel }

{*************** Fin des routines de Temps  ********************}
{***************************************************************}

BEGIN
  InitPIT;
END.
