;
; Program to compare the ages of two files.
; 	
; Dan Tappan, BBN, 2/22/84
;
; To build
; MASM OLDER;
; LINK OLDER;
; EXE2BIN OLDER.EXE OLDER.COM
;
; Usage
;	OLDER <file1> <file2>
; Return value is 1 if <file1> is older than <file2>,
; 0 if <file1> is newer (or if <file2> doesn't exist)
;
	TITLE OLDER

SPACE	EQU	32			; SPACE CHARACTER

CODE	SEGMENT PARA
ASSUME	CS:CODE
	ORG	80H			; COMMAND LINE
CMDLINE	LABEL	BYTE	

	ORG	100H
OLDER	PROC	FAR

	MOV	AX,CS			; MAKE SURE DS SETUP
	MOV	DS,AX
	ASSUME	DS:CODE

	MOV	SI,OFFSET CMDLINE+1	; POINT TO START OF BUFFER
	MOV	CX,0
	MOV	CL,CMDLINE		; GET THE STRING LENGTH
	
	CALL	GETWORD			; GET A PARAMTER
	PUSH	DI			; SAVE IT
	CALL	GETWORD			; GET ANOTHER
	CALL	GETDATE			; GET THE FILE DATE
	POP	DI			; GET NEXT STRING
	PUSH	CX			; SAVE TIME
	PUSH	DX			; AND DATE
	CALL	GETDATE			; GET DATES FOR OTHER
	POP	AX			; DATE FROM SECOND FILE
	POP	BX			; TIME FROM SECOND
	CMP	AX,DX			; COMPARE TO FIRST
	JB	OLD0			; FIRST IS NEWER
	JA	OLD1			; FIRST IS OLDER
	CMP	BX,CX			; COMPARE TIMES
	JB	OLD0			; FIRST IS NEWER
; FIRST FILE IS OLDER, RETURN 1
OLD1:	MOV	AL,1
	JMP	OLDX			; LEAVE
; FIRST FILE IS NEWER, RETURN 0
OLD0:	MOV	AL,0			
OLDX:	MOV	AH,4CH			; RETURN WITH STATUS
	INT	21H
OLDER	ENDP

;
; GETDATE - GET A FILES DATE
; CALLED
;	DI/	POINTER TO NAME STRING
; RETURNS
;	DX/	DATE
;	CX/	TIME
;
GETDATE	PROC	NEAR
	MOV	DX,DI			; POINT TO STRING
	MOV	AH,3DH			; OPEN A FILE
	MOV	AL,0			; FOR READING
	INT	21H			; GET HANDLE
	JC	NOFILE			; ERROR RETURN
	MOV	BX,AX			; HANDLE
	MOV	AL,0			; GET DATE
	MOV	AH,57H			; FUNCTION CODE
	INT	21H			; DO IT
	JMP	GOTDATE			; RETURN THE VALUE
; HERE IF FILE DOES NOT EXIST
NOFILE:	MOV	CX,0			; RETURN VALUE OF 0
	MOV	DX,CX			; ..
GOTDATE:
	RET
GETDATE	ENDP

;
; GETWORD - GET A PARMETER FROM THE COMMAND LINE
; CALLED 
;	SI/	START OF LINE (MAY HAVE LEADING SPACES)
;	CX/	SIZE OF STRING
; RETURN
;	DI/	START OF WORD (NULL TERMINATED)
;	SI,CX/	UPDATED
;
GETWORD	PROC	NEAR
	CLD				; DIRECTION IS FORWARD

	PUSH	SI			; SAVE START OF STRING
	PUSH	CX			; AND INITIAL COUNT

	MOV	BX,CX			; MAKE SURE PROPERLY TERMINATED
	MOV	AL,SPACE		; CODE TO SCAN FOR
	MOV	BYTE PTR [BX+SI],AL	; WITH A SPACE

	MOV	DI,SI			; START OF STRING
	CMP	CX,0			; ANY STRING LEFT?
	JLE	GETWX			; RETURN NULL STRING

	REPE	SCASB			; SKIP SPACES
	CMP	CX,0			; FOUND?
	JLE	GETWX			; AGAIN NULL STRING
	NOT	CX			; PREVENT STOPPING
	DEC	DI			; BACKUP TO START OF STRING
	PUSH	DI			; SAVE THE START
	REPNE	SCASB			; SCAN FOR END OF WORD
	DEC	DI			; POINT TO THE SPACE
	MOV	SI,DI			; UPDATE SI
	POP	DI			; REMEMBER START OF STRING

GETWX:	MOV	BYTE PTR [SI],0		; NULL TERMINATE STRING
	INC	SI			; POINT TO NEXT
	POP	CX			; GET INITIAL COUNT
	POP	BX			; INITIAL SI
	SUB	BX,SI			; GET DIFFERENCE
	ADD	CX,BX			; UPDATE COUNT
	RET
GETWORD	ENDP
CODE	ENDS
	
	END OLDER
