NAME
	reminder - events reminder

SYNOPSIS
	reminder [ options ] [file...]

DESCRIPTION
	Reminder is a program to help mortals keep track of such
mundane things as appointments, scheduled travel, etc.  When
the program is invoked without file names, reminder attempts
to read a file called DATES in the current directory.  If
reminder is invoked with file names, these will be used as the
data files.  The file DATES (or any other data file) must have
a specified format.  Each line is composed of five fields.
Each field is marked by a colon.  There are no colons at the
beginning or end of the line, so there should be four colons
per line.  If a line doesn't have the right number of colons,
the program will print an error message and stop.

	The first field is the date or day of the event.
It is of the form mm/dd, mm/dd/yy, dd or ddd where:

mm   are one or two digits representing the month (01 or 1 is
     January, 2 is February, etc.).

dd   are the one or two digits representing the day of the month.

yy   are the number of years since 1900 (e.g. 85 for 1985 or 101
     for 2001).

ddd  are the two or more characters representing the day of the week.
     This could be any one of the following (all self-explanatory):
     mon, tu, wed, th, friday, sat, or sun.  They may also
     be in all upper case, as in FRI, or the first letter may be
     upper case, as in Tue.  Anything after the first two
     characters is ignored.

     If the year is omitted, reminder will issue a reminder every
     year, as appropriate.  Similarly, if the month is omitted,
     the reminder will be issued every month.  A "c" in the year
     field indicates the current year, and an "n" indicates the
     next year.

The next field states the number of days before the event that
reminder will tell you of its occurrence, unless overridden by
options on the command line.

The third field is the event itself.  This can be anything, e.g.

     Meeting with Mr. Smith,
     0830 staff meeting, or
     presentation.

The fourth (optional) field is the receptor of the event, e.g.
Mr.  Jones.

The last field is the status field.  It allows you to note
whether or not you want to be reminded of the event.  This is
accomplished by two letters:

D	Do not report the occurrence of this event

N	Report the occurrence of this event

Any line lacking colons completely will be understood to mean
a file name that reminder should read to get more data.

The following options are available:
-i	Print each line of output exactly as it appears in the
	input file.

-n	Print each line of output in the format:
	"date event" or
	"date receptor's event".

If neither -i nor -n is present, then the output format is:
	"n days until event"
	"n days until receptor's event"
	"Today is event"

-bdate	Specifies beginning date of a range during which all
	events will be printed.  Date is in the same format
	as used for dates in the input file, as specified above.

-edate	Specifies end date of a range during which all events will
	be printed.

-fn	Specifies beginning of a range of days from today
	during which all events will be printed.

-tn	Specifies end of a range of days from today during
	which all events will be printed.

-x	(eXplicit).  Print each line of output in the format:
"yy.mm.dd (ddd) (nnn days) receptor's time event"
The date is in a format suitable for piping to sort, and
both the day of week and the date are given, regardless
of the form in which the event was entered.

-p  Include all past events in the output

If neither -b nor -f nor -p is present, then events after today
will be printed.  If neither -e nor -t is present, then the
data in the second field of each input line will used to
determine the end of the range of DATES to be checked.

FILES
	DATES		current directory appointment book

EXAMPLES
	With the following DATES file:

     01/13:4:Meeting with Mr. Smith:Mr. Jones:N
     01/19:14:Meeting:Bruce:N
     01/20:5:Equipment Demo:Alex:N
     01/21:5:Conference:Staff Group:N
     20:5:Monthly fire inspection due::D

The command:
	reminder

would print the following on January 16:

    4 days before Mr. Jones's meeting with Mr. Smith
    5 days before Bruce's Meeting

On the same date, the command:

	reminder  -n -b1/1/c -e3/31/c

would print all events occurring during the first quarter of the
current year:

     01/13 Mr. Jones's Meeting with Mr. Smith
     01/19 Bruce's Meeting
     01/20 Alex's Equipment Demo
     01/21 Staff Group's Conference

Hint: Reminder is most easily used by adding the single line:
	REMINDER
to the user's AUTOEXEC.BAT file, so it is automatically invoked
every time the user powers up his computer.

DIAGNOSTICS
	There are two errors that halt the program.  The first is
if the line buffer exceeds its limit (256 characters).  The error
message "Line Buffer format error" is printed.  The second is
when the proper number of colons is confused.  The message will
read "Line buffer division error".

BUGS
	The DATES file must end with a newline reminder ignores the
last line.  The "X" option in the Unix version of reminder, to
automatically delete entries from the DATES file, is not
implemented in the MSDOS version.  The user must manually delete
entries using any text editor.  The feature in the Unix version
to allow "quoting" a colon in an entry by using \: is not
implemented in the MSDOS version.

SEE ALSO
	REMIND.MAN, EVENT.MAN

AUTHOR G. E. Toth wrote original program.
       Glenn Randers-Pehrson added various enhancements.
       Kenneth Van Camp adapted it for MSDOS (under Turbo C).
       Richard J. Reiner <rreiner@vm1.yorku.ca> or
	   <grad3077@writer.yorku.ca> added -x and -p (under
	   Microsoft C)