*=================================================================
*
* Copyright (c) 1996-1997   Daniele Giacomini
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation; either version 2 of
* the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the Free
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
* USA.
*
*=================================================================
* AUTHOR
*=================================================================

#define AUTHOR_ADDRESS;
        "Daniele Giacomini"             + NL(1) +;
        "Via F. Turati, 15"             + NL(1) +;
        "I-31100 Treviso - Italy"       + NL(1) +;
        "daniele@tv.shineline.it"       + NL(1) +;
        "http://www.geocities.com/SiliconValley/7737/nanobase.html"


*=================================================================
* INCLUDE
*=================================================================


*=================================================================
* UNSUPPORTED/DIFFERENT
*=================================================================
*
* The new READ() function may substitutes READMODAL() giving a
* minimal mouse support.
*
* The following funcitons are no more available.
*   __ReadFormat()
*   __ReadKill()       => ReadKill(.T.)
*   ReadExit()         => Set( _SET_EXIT )
*   ReadFormat()
*   ReadInsert()       => Set( _SET_INSERT )
*   ReadVar()
*
* The following function are different.
*   GetActive()        is now modifyed to hold the active
*                      Get object.
*   GetApplayKey()     static; modifyed for mouse support.
*   GetDoSetKey()      static.
*   GetPreValidate()   static.
*   GetPostValidate()  static.
*   GetReader()        static; more parameters for mouse support.
*   SetKey()           will be evaluated without parameters:
*                      EVAL( SETKEY( <nInkeyCode> ) )
*   ReadKill()         is now modifyed to hold the _Kill_ status.
*   ReadUpdated()      static; is now modifyed to hold the;
*                      _Updated_ status.
*-----------------------------------------------------------------
*
*
*=================================================================
* DISPBOX()
*=================================================================

* Single-line box
#define BOX_SINGLE (;
    CHR(218) +;
    CHR(196) +;
    CHR(191) +;
    CHR(179) +;
    CHR(217) +;
    CHR(196) +;
    CHR(192) +;
    CHR(179);
    )

* Double-line box
#define BOX_DOUBLE (;
    CHR(201) +;
    CHR(205) +;
    CHR(187) +;
    CHR(186) +;
    CHR(188) +;
    CHR(205) +;
    CHR(200) +;
    CHR(186);
    )

* Single-line top, double-line sides
#define BOX_SINGLE_DOUBLE (;
    CHR(214) +;
    CHR(196) +;
    CHR(183) +;
    CHR(186) +;
    CHR(189) +;
    CHR(196) +;
    CHR(211) +;
    CHR(186);
    )

* Double-line top, single-line sides
#define BOX_DOUBLE_SINGLE (;
    CHR(213) +;
    CHR(205) +;
    CHR(184) +;
    CHR(179) +;
    CHR(190) +;
    CHR(205) +;
    CHR(212) +;
    CHR(179);
    )


*=================================================================
* GETEXIT - READMODAL() - READ()
*=================================================================

#define GETEXIT_NOEXIT     0      // no exit attempted (blank)
#define GETEXIT_UP         1
#define GETEXIT_DOWN       2
#define GETEXIT_TOP        3
#define GETEXIT_BOTTOM     4
#define GETEXIT_ENTER      5
#define GETEXIT_WRITE      6
#define GETEXIT_ESCAPE     7
#define GETEXIT_WHEN       8      // pre validation failure

*=================================================================
* INKEY()
*=================================================================

#define K_UP                5   //   Up arrow, Ctrl-E
#define K_DOWN             24   //   Down arrow, Ctrl-X
#define K_LEFT             19   //   Left arrow, Ctrl-S
#define K_RIGHT             4   //   Right arrow, Ctrl-D
#define K_HOME              1   //   Home, Ctrl-A
#define K_END               6   //   End, Ctrl-F
#define K_PGUP             18   //   PgUp, Ctrl-R
#define K_PGDN              3   //   PgDn, Ctrl-C

#define K_CTRL_UP         397   // * Ctrl-Up arrow
#define K_CTRL_DOWN       401   // * Ctrl-Down arrow
#define K_CTRL_LEFT        26   //   Ctrl-Left arrow, Ctrl-Z
#define K_CTRL_RIGHT        2   //   Ctrl-Right arrow, Ctrl-B
#define K_CTRL_HOME        29   //   Ctrl-Home, Ctrl-]
#define K_CTRL_END         23   //   Ctrl-End, Ctrl-W
#define K_CTRL_PGUP        31   //   Ctrl-PgUp, Ctrl-Hyphen
#define K_CTRL_PGDN        30   //   Ctrl-PgDn, Ctrl-^

#define K_ALT_UP          408   // * Alt-Up arrow
#define K_ALT_DOWN        416   // * Alt-Down arrow
#define K_ALT_LEFT        411   // * Alt-Left arrow
#define K_ALT_RIGHT       413   // * Alt-Right arrow
#define K_ALT_HOME        407   // * Alt-Home
#define K_ALT_END         415   // * Alt-End
#define K_ALT_PGUP        409   // * Alt-PgUp
#define K_ALT_PGDN        417   // * Alt-PgDn

#define K_ENTER            13   //   Enter, Ctrl-M
#define K_RETURN           13   //   Return, Ctrl-M
#define K_SPACE            32   //   Space bar
#define K_ESC              27   //   Esc, Ctrl-[

#define K_CTRL_ENTER       10   //   Ctrl-Enter
#define K_CTRL_RETURN      10   //   Ctrl-Return
#define K_CTRL_RET         10   //   Ctrl-Return (Compat.)
#define K_CTRL_PRTSCR     379   // * Ctrl-Print Screen
#define K_CTRL_QUESTION   309   //   Ctrl-?

#define K_ALT_ENTER       284   // * Alt-Enter
#define K_ALT_RETURN      284   // * Alt-Return
#define K_ALT_EQUALS      387   // * Alt-Equals
#define K_ALT_ESC         257   // * Alt-Esc

#define KP_ALT_ENTER      422   // * Keypad Alt-Enter

#define KP_CTRL_5         399   // * Keypad Ctrl-5
#define KP_CTRL_SLASH     405   // * Keypad Ctrl-/
#define KP_CTRL_ASTERISK  406   // * Keypad Ctrl-*
#define KP_CTRL_MINUS     398   // * Keypad Ctrl--
#define KP_CTRL_PLUS      400   // * Keypad Ctrl-+

#define KP_ALT_5            5   // * Keypad Alt-5
#define KP_ALT_SLASH      420   // * Keypad Alt-/
#define KP_ALT_ASTERISK   311   // * Keypad Alt-*
#define KP_ALT_MINUS      330   // * Keypad Alt--
#define KP_ALT_PLUS       334   // * Keypad Alt-+

#define K_INS              22   //   Ins, Ctrl-V
#define K_DEL               7   //   Del, Ctrl-G
#define K_BS                8   //   Backspace, Ctrl-H
#define K_TAB               9   //   Tab, Ctrl-I
#define K_SH_TAB          271   //   Shift-Tab

#define K_CTRL_INS        402   // * Ctrl-Ins
#define K_CTRL_DEL        403   // * Ctrl-Del
#define K_CTRL_BS         127   //   Ctrl-Backspace
#define K_CTRL_TAB        404   // * Ctrl-Tab

#define K_ALT_INS         418   // * Alt-Ins
#define K_ALT_DEL         419   // * Alt-Del
#define K_ALT_BS          270   // * Alt-Backspace
#define K_ALT_TAB         421   // * Alt-Tab

#define K_CTRL_A        1    //   Ctrl-A, Home
#define K_CTRL_B        2    //   Ctrl-B, Ctrl-Right arrow
#define K_CTRL_C        3    //   Ctrl-C, PgDn, Ctrl-ScrollLock
#define K_CTRL_D        4    //   Ctrl-D, Right arrow
#define K_CTRL_E        5    //   Ctrl-E, Up arrow
#define K_CTRL_F        6    //   Ctrl-F, End
#define K_CTRL_G        7    //   Ctrl-G, Del
#define K_CTRL_H        8    //   Ctrl-H, Backspace
#define K_CTRL_I        9    //   Ctrl-I, Tab
#define K_CTRL_J       10   //   Ctrl-J
#define K_CTRL_K       11   //   Ctrl-K
#define K_CTRL_L       12   //   Ctrl-L
#define K_CTRL_M       13   //   Ctrl-M, Return
#define K_CTRL_N       14   //   Ctrl-N
#define K_CTRL_O       15   //   Ctrl-O
#define K_CTRL_P       16   //   Ctrl-P
#define K_CTRL_Q       17   //   Ctrl-Q
#define K_CTRL_R       18   //   Ctrl-R, PgUp
#define K_CTRL_S       19   //   Ctrl-S, Left arrow
#define K_CTRL_T       20   //   Ctrl-T
#define K_CTRL_U       21   //   Ctrl-U
#define K_CTRL_V       22   //   Ctrl-V, Ins
#define K_CTRL_W       23   //   Ctrl-W, Ctrl-End
#define K_CTRL_X       24   //   Ctrl-X, Down arrow
#define K_CTRL_Y       25   //   Ctrl-Y
#define K_CTRL_Z       26   //   Ctrl-Z, Ctrl-Left arrow

#define K_ALT_A         286   //   Alt-A
#define K_ALT_B         304   //   Alt-B
#define K_ALT_C         302   //   Alt-C
#define K_ALT_D         288   //   Alt-D
#define K_ALT_E         274   //   Alt-E
#define K_ALT_F         289   //   Alt-F
#define K_ALT_G         290   //   Alt-G
#define K_ALT_H         291   //   Alt-H
#define K_ALT_I         279   //   Alt-I
#define K_ALT_J         292   //   Alt-J
#define K_ALT_K         293   //   Alt-K
#define K_ALT_L         294   //   Alt-L
#define K_ALT_M         306   //   Alt-M
#define K_ALT_N         305   //   Alt-N
#define K_ALT_O         280   //   Alt-O
#define K_ALT_P         281   //   Alt-P
#define K_ALT_Q         272   //   Alt-Q
#define K_ALT_R         275   //   Alt-R
#define K_ALT_S         287   //   Alt-S
#define K_ALT_T         276   //   Alt-T
#define K_ALT_U         278   //   Alt-U
#define K_ALT_V         303   //   Alt-V
#define K_ALT_W         273   //   Alt-W
#define K_ALT_X         301   //   Alt-X
#define K_ALT_Y         277   //   Alt-Y
#define K_ALT_Z         300   //   Alt-Z
#define K_ALT_1         376   //   Alt-1
#define K_ALT_2         377   //   Alt-2
#define K_ALT_3         378   //   Alt-3
#define K_ALT_4         379   //   Alt-4
#define K_ALT_5         380   //   Alt-5
#define K_ALT_6         381   //   Alt-6
#define K_ALT_7         382   //   Alt-7
#define K_ALT_8         383   //   Alt-8
#define K_ALT_9         384   //   Alt-9
#define K_ALT_0         385   //   Alt-0

#define K_F1           28    //   F1, Ctrl-Backslash
#define K_F2           -1    //   F2
#define K_F3           -2    //   F3
#define K_F4           -3    //   F4
#define K_F5           -4    //   F5
#define K_F6           -5    //   F6
#define K_F7           -6    //   F7
#define K_F8           -7    //   F8
#define K_F9           -8    //   F9
#define K_F10          -9    //   F10
#define K_F11         -40    // * F11
#define K_F12         -41    // * F12

#define K_CTRL_F1       -20   //   Ctrl-F1
#define K_CTRL_F2       -21   //   Ctrl-F2
#define K_CTRL_F3       -22   //   Ctrl-F4
#define K_CTRL_F4       -23   //   Ctrl-F3
#define K_CTRL_F5       -24   //   Ctrl-F5
#define K_CTRL_F6       -25   //   Ctrl-F6
#define K_CTRL_F7       -26   //   Ctrl-F7
#define K_CTRL_F8       -27   //   Ctrl-F8
#define K_CTRL_F9       -28   //   Ctrl-F9
#define K_CTRL_F10      -29   //   Ctrl-F10
#define K_CTRL_F11      -44   // * Ctrl-F11
#define K_CTRL_F12      -45   // * Ctrl-F12

#define K_ALT_F1       -30   //   Alt-F1
#define K_ALT_F2       -31   //   Alt-F2
#define K_ALT_F3       -32   //   Alt-F3
#define K_ALT_F4       -33   //   Alt-F4
#define K_ALT_F5       -34   //   Alt-F5
#define K_ALT_F6       -35   //   Alt-F6
#define K_ALT_F7       -36   //   Alt-F7
#define K_ALT_F8       -37   //   Alt-F8
#define K_ALT_F9       -38   //   Alt-F9
#define K_ALT_F10      -39   //   Alt-F10
#define K_ALT_F11      -46   // * Alt-F11
#define K_ALT_F12      -47   // * Alt-F12

#define K_SH_F1       -10   //   Shift-F1
#define K_SH_F2       -11   //   Shift-F2
#define K_SH_F3       -12   //   Shift-F3
#define K_SH_F4       -13   //   Shift-F4
#define K_SH_F5       -14   //   Shift-F5
#define K_SH_F6       -15   //   Shift-F6
#define K_SH_F7       -16   //   Shift-F7
#define K_SH_F8       -17   //   Shift-F8
#define K_SH_F9       -18   //   Shift-F9
#define K_SH_F10      -19   //   Shift-F10
#define K_SH_F11      -42   // * Shift-F11
#define K_SH_F12      -43   // * Shift-F12


*=================================================================
* MEMOEDIT()
*=================================================================

* User function entry modes
#define MEMOEDIT_IDLE       0      // idle, all keys processed
#define MEMOEDIT_UNKEY      1      // unknown key, memo unaltered
#define MEMOEDIT_UNKEYX     2      // unknown key, memo altered
#define MEMOEDIT_INIT       3      // initialization mode


* User function return codes
#define MEMOEDIT_DEFAULT       0      // perform default action
#define MEMOEDIT_IGNORE       32      // ignore unknown key
#define MEMOEDIT_DATA         33      // treat unknown key as data
#define MEMOEDIT_TOGGLEWRAP   34      // toggle word-wrap mode
#define MEMOEDIT_TOGGLESCROLL 35      // toggle scrolling mode
#define MEMOEDIT_WORDRIGHT   100      // perform word-right operation
#define MEMOEDIT_BOTTOMRIGHT 101      // perform bottom-right operation

* NOTE:  Return codes 1 - 31 cause MEMOEDIT() to perform the
* edit action corresponding to the key whose value is returned.

*=================================================================
* SET()
*=================================================================

#define _SET_EXACT         1
#define _SET_FIXED         2
#define _SET_DECIMALS      3
#define _SET_DATEFORMAT    4
#define _SET_EPOCH         5
#define _SET_PATH          6
#define _SET_DEFAULT       7

#define _SET_EXCLUSIVE     8
#define _SET_SOFTSEEK      9
#define _SET_UNIQUE       10
#define _SET_DELETED      11

#define _SET_CANCEL       12
#define _SET_DEBUG        13
#define _SET_TYPEAHEAD    14

#define _SET_COLOR        15
#define _SET_CURSOR       16
#define _SET_CONSOLE      17
#define _SET_ALTERNATE    18
#define _SET_ALTFILE      19
#define _SET_DEVICE       20
#define _SET_EXTRA        21
#define _SET_EXTRAFILE    22
#define _SET_PRINTER      23
#define _SET_PRINTFILE    24
#define _SET_MARGIN       25

#define _SET_BELL         26
#define _SET_CONFIRM      27
#define _SET_ESCAPE       28
#define _SET_INSERT       29
#define _SET_EXIT         30
#define _SET_INTENSITY    31
#define _SET_SCOREBOARD   32
#define _SET_DELIMITERS   33
#define _SET_DELIMCHARS   34

#define _SET_WRAP         35
#define _SET_MESSAGE      36
#define _SET_MCENTER      37
#define _SET_SCROLLBREAK  38

#define _SET_COUNT        38

*=================================================================
* SETCURSOR()
*=================================================================

#define SETCURSOR_NONE     0  // No cursor
#define SETCURSOR_NORMAL   1  // Normal cursor (underline)
#define SETCURSOR_INSERT   2  // Insert cursor (lower half block)
#define SETCURSOR_SPECIAL1 3  // Special cursor (full block)
#define SETCURSOR_SPECIAL2 4  // Special cursor (upper half block)

*=================================================================
* RDD...
*=================================================================

#define RDT_FULL     1
#define RDT_TRANSFER 2
#define RDT_HIDDEN   255

*=================================================================
* CHARACTERs
*=================================================================

#define NUL chr(00)  // NULl
#define SOH chr(01)  // Start Of Hiteration
#define STX chr(02)  // Start TeXt
#define ETX chr(03)  // End TeXt
#define EOT chr(04)  // End Of Transmission
#define ENQ chr(05)  // ENQuery
#define ACK chr(06)  // ACKnowledge
#define BEL chr(07)  // BELl
#define BS  chr(08)  // Back Space
#define HT  chr(09)  // Horizontal Tab
#define LF  chr(10)  // Line Feed
#define VT  chr(11)  // Vertical Tab
#define FF  chr(12)  // Form Feed
#define CR  chr(13)  // Carriage Return
#define SO  chr(14)  // Shift Out
#define SI  chr(15)  // Shif In
#define DLE chr(16)  // Data Loop Exit
#define DC1 chr(17)  // Dispositive Check 1
#define DC2 chr(18)  // Dispositive Check 2
#define DC3 chr(19)  // Dispositive Check 3
#define DC4 chr(20)  // Dispositive Check 4
#define NAK chr(21)  // Not AKnowledge
#define SYN chr(22)  // SYNcronized
#define ETB chr(23)  // End Trasmission Block
#define CAN chr(24)  // CANcel
#define EM  chr(25)  // End Medium
#define SUB chr(26)  // SUBstitute
#define ESC chr(27)  // ESCape
#define FS  chr(28)  // File Separator
#define GS  chr(29)  // Group Separator
#define RS  chr(30)  // Record Separator
#define US  chr(31)  // Unit Separator

*=================================================================
* STRINGs
*=================================================================

#define NL( nTimes )    ( replicate ( CR + LF, nTimes ) )

*=================================================================
* ERROR MESSAGEs
*=================================================================

#define _ERROR_EXCLUSIVE_REQUIRED;
    "For this action, the Alias must be opened in exclusive mode."
#define _ERROR_FLOCK_FAILURE;
    "The file is already in use."
#define _ERROR_NO_ALIAS;
    "There is no active Alias."
#define _ERROR_NO_FILE;
    "The file do not exists."
#define _ERROR_NO_FILE_HERE;
    "The file do not exists in the specified directory."
#define _ERROR_NO_INDEX;
    "An opened index and a selected order is needed before."
#define _ERROR_PROMPT_ALREADY_EXIST_OVERWRITE;
    "This file already exists. Overwrite?"


*=================================================================
* MAX VALUEs
*=================================================================

#define _MAX_ORDER      255
#define _MAX_SELECT     255
#define _MAX_STRING_LEN 254

*=================================================================
* DEFAULT NAMEs
*=================================================================

#define _DEFAULT_RDD        "DBFNTX"

#define _UNTITLED           "UNTITLED"


*=================================================================
* FILE / ALIAS NAMEs
*=================================================================

#define _MACRO_ALIAS     "_MACRO_"      // plus 3 digits.


*=================================================================
* FILE NAME EXTENTIONs
*=================================================================

#define _EXTENTION_DBF                  "DBF"
#define _EXTENTION_FORM                 "FRM"
#define _EXTENTION_HTF                  "HLP"
#define _EXTENTION_INDEXBAG             substr( ordbagext(), 2 )
#define _EXTENTION_INDEXBAG_STANDARD    "NTX"
#define _EXTENTION_LABEL                "LBL"
#define _EXTENTION_TEXT                 "TXT"
#define _EXTENTION_MACRO_COMPILED       "NB"
#define _EXTENTION_MACRO_ASCII          "&"
#define _EXTENTION_HTM                  "HTM"

*=================================================================
* MACRO INTERPRETATION
*=================================================================

#define _MACRO_EXIT_NORMAL          0
#define _MACRO_EXIT_BREAK           1
#define _MACRO_EXIT_STATEMENT_ERROR 2
#define _MACRO_EXIT_NO_MACRO_FILE   3
#define _MACRO_EXIT_FILE_LOCKED     4
#define _MACRO_EXIT_FILE_NOT_DBF    5
#define _MACRO_EXIT_DIFFERENT_DBF   6

*=================================================================
* PROMPT MENU
*=================================================================

#define _MENU_YES             " YES "
#define _MENU_NO              " NO "
#define _MENU_CONTINUE        " CONTINUE "
#define _MENU_EXIT            " EXIT "

*=================================================================
* BUTTONS &&&&
*=================================================================

#define _BUTTON_ESC_CANCEL;
    "[Esc] Cancel"
#define _BUTTON_ESC_EXIT;
    "[Esc] Exit"
#define _BUTTON_ENTER_EXEC;
    "[Enter] Exec"
#define _BUTTON_F1_HELP;
    "[F1] Help"
#define _BUTTON_F2_LIST;
    "[F2] List"
#define _BUTTON_F10_MENU;
    "[F10] Menu"
#define _BUTTON_PGDN_CONFIRM;
    "[Pag] Confirm"
#define _BUTTON_UP_PREVIOUS;
    "[] Prev"
#define _BUTTON_DOWN_NEXT;
    "[] Next"

#define _BUTTON_CHANGE;
    "Change"



*=================================================================
* COLORS
*=================================================================
* Color string notes.
* "<standard>, <enhanced>, <border>, <background>, <unselected>"
*
* QOUT(), QOUT(), SAY(), DISPOUT()
* <standard>
*
* GET()
* <unselected> when a field is not selected,
* <enhanced> when a field is selected.
*


#define COLOR_BASE      setColorStandard( 1 )

#define COLOR_MENU      setColorStandard( 2 )

#define COLOR_HEAD      setColorStandard( 3 )

#define COLOR_BODY      setColorStandard( 4 )

#define COLOR_BUTTON    setColorStandard( 5 )

#define COLOR_MESSAGE   setColorStandard( 6 )

#define COLOR_ALERT     setColorStandard( 7 )


#define COLOR_STANDARD_BASE;
    iif( iscolor(),;
    "gb+/b,  n/w,    n,  n,  w/n",;
    "w/n,   u,      n,  n,  n/w" )

#define COLOR_STANDARD_MENU;
    iif( iscolor(),;
    "w+/g,  g+/n,    n,  n,  w+/g",;
    "w/n,   n/w,     n,  n,  w/n" )

#define COLOR_STANDARD_HEAD;
    iif( iscolor(),;
    "w+/rb,  n,   n,  n,  n",;
    "n/w,   n,   n,  n,  n" )

#define COLOR_STANDARD_BODY;
    iif( iscolor(),;
    "n/w,   g+/n,   n,  n,  w/n",;
    "w/n,   u,      n,  n,  n/w" )

#define COLOR_STANDARD_BUTTON;
    iif( iscolor(),;
    "w+/r,  r/w,   n,  n,  w+/r",;
    "n/w,   w/n,   n,  n,  n/w" )

#define COLOR_STANDARD_MESSAGE;
    iif( iscolor(),;
    "n/gb,  n,      n,  n,  n",;
    "n/w,   n,      n,  n,  n" )

#define COLOR_STANDARD_ALERT;
    iif( iscolor(),;
    "w+/r,  w+/n,   n,  n,  w+/r",;
    "n/w,   u,      n,  n,  n/w" )


*=================================================================
* ERRORS
*=================================================================

* Severity levels (e:severity)
#define ERROR_SEVERITY_WHOCARES        0
#define ERROR_SEVERITY_WARNING         1
#define ERROR_SEVERITY_ERROR           2
#define ERROR_SEVERITY_CATASTROPHIC    3

* Generic error codes (e:genCode)
#define ERROR_GENERIC_ARG             1
#define ERROR_GENERIC_BOUND           2
#define ERROR_GENERIC_STROVERFLOW     3
#define ERROR_GENERIC_NUMOVERFLOW     4
#define ERROR_GENERIC_ZERODIV         5
#define ERROR_GENERIC_NUMERR          6
#define ERROR_GENERIC_SYNTAX          7
#define ERROR_GENERIC_COMPLEXITY      8

#define ERROR_GENERIC_MEM            11
#define ERROR_GENERIC_NOFUNC         12
#define ERROR_GENERIC_NOMETHOD       13
#define ERROR_GENERIC_NOVAR          14
#define ERROR_GENERIC_NOALIAS        15
#define ERROR_GENERIC_NOVARMETHOD    16
#define ERROR_GENERIC_BADALIAS       17
#define ERROR_GENERIC_DUPALIAS       18

#define ERROR_GENERIC_CREATE         20
#define ERROR_GENERIC_OPEN           21
#define ERROR_GENERIC_CLOSE          22
#define ERROR_GENERIC_READ           23
#define ERROR_GENERIC_WRITE          24
#define ERROR_GENERIC_PRINT          25

#define ERROR_GENERIC_UNSUPPORTED    30
#define ERROR_GENERIC_LIMIT          31
#define ERROR_GENERIC_CORRUPTION     32
#define ERROR_GENERIC_DATATYPE       33
#define ERROR_GENERIC_DATAWIDTH      34
#define ERROR_GENERIC_NOTABLE        35
#define ERROR_GENERIC_NOORDER        36
#define ERROR_GENERIC_SHARED         37
#define ERROR_GENERIC_UNLOCKED       38
#define ERROR_GENERIC_READONLY       39

#define ERROR_GENERIC_APPENDLOCK     40
#define ERROR_GENERIC_LOCK           41

*=================================================================
* RDD REQUESTs
*=================================================================

#ifdef RDD
    external dbfcdx
    external dbfmdx
#endif

external dbfndx
external dbfntx // default

*=================================================================
* TAB()
*=================================================================
#define TAB_LEFT                1
#define TAB_RIGHT               2
#define TAB_FIELD_LEN           3
#define TAB_TAB_ARRAY           4
#define TAB_DEFAULT             { 0, maxcol(), 1, { 4 } }


*=================================================================


