/*
*******************************************
*                                         *
*   This program creates a PRN type file  *
*   out of the Sonka BBS list.  The PRN   *
*   file may be merged into an ICF file.  *
*   The number of lines per record is 9.  *
*                                         *
*        Copyright M. Arnow, 1988.        *
*        All rights reserved.             *
*                                         *
*******************************************
*/

#include <stdio.h>
#include <string.h>

char abbs[] = "Apple Bulletin Board System (Apple Based).";
char advn[] = "Adventure Systems (Apple Based).";
char akcs[] = "AKCS Unix Bulletin Board (Unix Based).";
char amig[] = "Amiga Bulletin Board System (Amiga Based).";
char amis[] = "Atari Message System (Atari or Atari ST Based).";
char cbbs[] = "Computer Bulletin Board System (S100 Based).";
char ccbs[] = "Commodore Computer Bulletin Board (C-64 Based).";
char coco[] = "Color Computer Bulletin Board (TRS-80 Based).";
char coli[] = "Collie Bulletin Board (IBM-PC & Compatibles).";
char data[] = "Online Computerized Library Catalog System.";
char divd[] = "Diversi-Dial Multi-User System (Apple Based).";
char erac[] = "ERAC Bulletin Board System (TRS-80 Based).";
char fido[] = "Fido Bulletin Board System (MS-DOS Based).";
char form[] = "Forum-PC Bulletin Board System(IBM & Compatibles).";
char gbbs[] = "General Bulletin Board System (Apple Based).";
char gtbb[] = "GT-BBS System (IBM-PC & Compatibles).";
char ibbs[] = "PC Bulletin Board System (IBM-PC & Compatibles).";
char ihcs[] = "IBM-PC Host Communication System (IBM-PC).";
char mcbb[] = "MacIntosh Bulletin Board (MacIntosh Based).";
char mcms[] = "Micro Computer Message System (TRS-80 Based).";
char mich[] = "Michtron Bulletin Board (Amiga Based).";
char netw[] = "Net-Works Communications System (Apple Based).";
char noch[] = "No Change Bulletin Board (IBM-PC & Compatibles).";
char onln[] = "Online Multi-User System (C-64 Based).";
char opus[] = "Computer -Based Conversation System (MS-DOS).";
char otbb[] = "Other TRS-80 Bulletin Board (TRS-80 Based).";
char pcbb[] = "PC Bulletin Board (IBM-PC & Compatibles).";
char pico[] = "PicoSpan Multiuser Conference System (Unix Based).";
char rbbs[] = "Remote PC Bulletin Board (IBM-PC & Compatibles).";
char rcpm[] = "Remote CP/M Bulletin Board (CP/M Based).";
char stbb[] = "ST Bulletin Board (Atari 520-ST Based).";
char tbbs[] = "The Bread Board System (IBM-PC & Compatibles).";
char tcom[] = "T-Comm Bulletin Board (IBM-PC & Compatibles).";
char tibb[] = "Texas Instruments Bulletin Board (TI99/4 Based).";
char ubbs[] = "Universal Bulletin Board System (Apple Based).";
char unix[] = "Unix/Xenix System (with bbs facilities).";
char xbbs[] = "Adult BBS Systems (Apple,C-64 or TRS-80 Based).";

char info_a[] = "24-hours per day, 7 days per week operation.";
char info_b[] = "Part-Time: 9am-9pm weekdays, 1pm-5pm weekends.";
char info_c[] = "Part-Time: 7pm-7am weekdays, 24 hours on weekends.";
char info_d[] = "Part-Time: 7am-6pm weekdays, 24 hours on weekends.";
char info_e[] = "Part-Time: 7pm-7am weekdays, 7 days per week.";
char info_f[] = "Part-Time: 7am-6pm weekdays, 7 days per week.";
char info_g[] = "BBS is temporarily closed for maintenance.";

char bps_a[] = "300-1200-2400-9600(HST) bps operation supported.";
char bps_b[] = "300-1200-2400 bps operation supported.";
char bps_c[] = "1200-12400 bps operation only.";
char bps_d[] = "1200 bps only.";
char bps_e[] = "300-1200 bps operation only.";
char bps_f[] = "300 bps operation only.";

char uart_7[] = "UART settings = 7-1-Even Parity.";
char uart_8[] = "UART settings = 8-1-No Parity.";

char header[] = "ABBS\0"
		"ADVN\0"
		"AKCS\0"
		"AMIG\0"
		"AMIS\0"
		"CBBS\0"
		"CCBS\0"
		"COCO\0"
		"COLI\0"
		"DATA\0"
		"DIVD\0"
		"ERAC\0"
                "FIDO\0"
		"FORM\0"
		"GBBS\0"
		"GTBB\0"
		"IBBS\0"
		"IHCS\0"
		"MCBB\0"
		"MCMS\0"
		"MICH\0"
		"NETW\0"
		"NOCH\0"
		"ONLN\0"
		"OPUS\0"
		"OTBB\0"
		"PCBB\0"
		"PICO\0"
		"RBBS\0"
		"RCPM\0"
		"STBB\0"
		"TBBS\0"
		"TCOM\0"
		"TIBB\0"
		"UBBS\0"
		"UNIX\0"
		"XBBS\0";

main()
{
FILE *fptr,*prn_ptr;
register int i;
char s_name[80],prn_name[80],buffer[80],*gptr;
char *h,*type,*info,*bps,*uart;
char name[80],location[80],number[80],flag;

do
	{
	printf("\nSonka List file name: ");
	scanf("%s",s_name);
	fptr = fopen(s_name,"r");
	if(!fptr)
		{
		strupr(s_name);
		printf("\n%s file not found.\n",s_name);
		}
	}
while(!fptr);

printf("\nPRN file name: ");
scanf("%s",prn_name);
prn_ptr = fopen(prn_name,"w");
if(!prn_ptr)
	{
	strupr(prn_name);
	printf("\nCannot open %s file",prn_name);
	exit(0);
	}
printf("\n");

for(;;)
	{
	for(i=0;i<80;++i) buffer[i] = name[i] = location[i] = number[i] = 0;
	gptr = fgets(buffer,80,fptr);
	if(!gptr) exit(0);
	for(h=header,i=0;*h;h+=5,++i) if(!strncmp(h,&buffer[2],4)) break;
	if(!*h) continue;
	flag = 0;
	switch(i)
		{
		case 0: type = abbs; break;
		case 1: type = advn; break;
		case 2: type = akcs; break;
		case 3: type = amig; break;
		case 4: type = amis; break;
		case 5: type = cbbs; break;
		case 6: type = ccbs; break;
		case 7: type = coco; break;
		case 8: type = coli; break;
		case 9: type = data; break;
		case 10: type = divd; break;
		case 11: type = erac; break;
		case 12: type = fido; break;
		case 13: type = form; break;
		case 14: type = gbbs; break;
		case 15: type = gtbb; break;
		case 16: type = ibbs; break;
		case 17: type = ihcs; break;
		case 18: type = mcbb; break;
		case 19: type = mcms; break;
		case 20: type = mich; break;
		case 21: type = netw; break;
		case 22: type = noch; break;
		case 23: type = onln; break;
		case 24: type = opus; break;
		case 25: type = otbb; break;
		case 26: type = pcbb; break;
		case 27: type = pico; break;
		case 28: type = rbbs; break;
		case 29: type = rcpm; break;
		case 30: type = stbb; break;
		case 31: type = tbbs; break;
		case 32: type = tcom; break;
		case 33: type = tibb; break;
		case 34: type = ubbs; break;
		case 35: type = unix; break;
		case 36: type = xbbs; break;
		default: flag = 1;
		}
	if(flag) continue;
	printf("%s",buffer);
	if(buffer[53]!='|')
		{
		strncpy(name,&buffer[9],30);
		strncpy(location,&buffer[41],18);
		strncpy(number,&buffer[61],9);
		}
	else
		{
		strncpy(name,&buffer[9],24);
		strncpy(location,&buffer[35],18);
		strncpy(number,&buffer[56],14);
		}
	switch(buffer[72])
		{
		case '*': info = info_a; break;
		case '#': info = info_b; break;
		case '%': info = info_c; break;
		case '&': info = info_d; break;
		case '=': info = info_e; break;
		case '+': info = info_f; break;
		case '?': info = info_g; break;
		default:  info = "";
		}
	switch(buffer[73])
		{
		case '7': uart = uart_7; break;
		case '8': uart = uart_8; break;
		default:  uart = "";
		}
	switch(buffer[74])
		{
		case '~': bps = bps_a; break;
		case '-': bps = bps_b; break;
		case '|': bps = bps_c; break;
		case '@': bps = bps_d; break;
		case '$': bps = bps_e; break;
		case '!': bps = bps_f; break;
		default:  bps = "";
		}
	fprintf(prn_ptr,"%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n\n",name,number,location,h,type,bps,uart,info);
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       