#include <stdio.h>                     
#include <memory.h>
#include <string.h>
#include "utype.h"
#include "umem.h"
#include "as68k.h"
#include "asmcom.h"
#include "yacc_tab.h"
#include "locgen.h"
#include "fpgen.h"
#include "mmugen.h"

extern int pass;
extern HASHREC **hashtable;
extern FILE *listfile;
extern int level;
extern int lineno[];
extern int macrolevel;
extern int prm_procrevision;
extern BOOL ifskip;
extern uint allocsize;
extern int sectionnum;

long basealign = 2;
int usedrevision = 0;
int branchdefault=0;
LIST *undeflist=0;
int opcodesize=0;
BYTE pcbuf[BUFLEN];
BYTE *outputbuf=0;
long org=0;
long execadr=0;

void setarg(EXPRESSION *arg,int size)
{
	arg->size = size;
	arg->x.value = 0;
	arg->isdef = 1;
	arg->isextern = 0;
	arg->islabel = 0;
	arg->relmode = RM_NONE;
	arg->relpc = 0;
	arg->ismacro = 0;
	arg->isopcode = 0;
	arg->swapper = 0xffff;
	arg->section = sectionnum;
	arg->name = 0;
}
int NoCPU32()
{
	if (prm_procrevision == 5) {
		proctype(100);
		return FALSE;
	}
	return TRUE;
}
void illprepost(OPERANDDATA *dest)
{
	if (dest->type == TPOSTINC || dest->type == TPREDEC)
		illop();
}
void setsize(int size, int sizepos)
{
  long temp;
  if (sizepos == -1)
		return;
	if (size)
		size--;
	else
#ifdef OLDSIZING
		size = TLONG-1;
#else
		size = TWORD-1;
#endif
  temp = pcbuf[1] + 256 * pcbuf[0];
  temp |= size << sizepos;
  pcbuf[1] = temp & 255;
  pcbuf[0] = temp >> 8;
}
void putadr(EXPRESSION *data)
{
  if (iswordsigned(data)) {
		data->size = TWORD;
		pcbuf[1] |= EAWORD;
		putword(data,FALSE);
	}
	else {                                              
		data->size = TLONG;
		pcbuf[1] |= EALONG;
		putdword(data,FALSE);
	}
}
BOOL putconst(int size, EXPRESSION *data)
{
			switch(size) {
				case TBYTE:
					if (!isbyte(data))
						badconst();
					putbyte(data,FALSE);
					return(TRUE);
#ifndef ORGSIZING
				default:
#endif
				case TWORD:
					if (!isword(data))
						badconst();
					putword(data,FALSE);
					return(TRUE);
				case TLONG:
#ifdef ORGSIZING
				default:
#endif
					putdword(data,FALSE);
					return(TRUE);
			}
}
int getmode(OPERANDDATA *op)
{
  if ((op->reg == PCREG) || (op->reg == ZPCREG))
		if (op->type == TINDIR)
			return EAPC;
		else
			return EAPCMEM;
	else
		return(EAMEM | (op->reg & 7));
}
	
BOOL checkbase(int reg, BOOL allow)
{
  if ((reg > 7 && !allow) || (reg > ZPCREG)) {
		Error("Bad base register");
		return(TRUE);
	}
  return(FALSE);
}
void briefext(OPERANDDATA *op, BOOL baseallow)
{
  if (op->basereg->type == TAREG)
  	checkbase(op->basereg->reg, baseallow);
	if (op->basereg->size)
		proctype(2);
  pcbuf[opcodesize ] = 0;
  pcbuf[opcodesize+1] = 0;
	if (op->basereg->adrtype == TAREG)
		pcbuf[opcodesize] |= 0x80;
	pcbuf[opcodesize]|= (op->basereg->reg&7) <<4;
  if (op->basereg->type == TBYTE)
		Error("Can't use byte base reg");
	if (op->basereg->type == TLONG)
		pcbuf[opcodesize]|=0x8;
	pcbuf[opcodesize] |= op->basereg->size<<1;
	if (op->basedisp) {
		if (op->basedisp->isfp)
			IllegalFloat();
		pcbuf[opcodesize+1] = op->basedisp->x.value & 0xff;
	}
  opcodesize += 2;
}
void fulladr(OPERANDDATA *op)
{
  proctype(2);
  pcbuf[opcodesize ] = 0x89;
 	pcbuf[opcodesize+1] = 0x87;
  checkbase(op->basereg->reg, FALSE);
	pcbuf[opcodesize] |= op->basereg->reg<<12;
	opcodesize+=2;
	putdword(op->basedisp,FALSE);
}
void fullext(OPERANDDATA *op, BOOL baseallow, BOOL indir, BOOL post)
{
  proctype(2);
  pcbuf[opcodesize ] = 0x01;
 	pcbuf[opcodesize+1] = 0;
  if (op->basereg) {
	  if (op->basereg->adrtype == TAREG) {
  		checkbase(op->basereg->reg, baseallow);
			pcbuf[opcodesize] |= 0x80;
		}
		pcbuf[opcodesize]|= (op->basereg->reg&7) <<4;
  	if (op->basereg->type == TBYTE)
			Error("Can't use byte base reg");
		if (op->basereg->type == 0 || op->basereg->type == TLONG)
			pcbuf[opcodesize]|=0x8;
		pcbuf[opcodesize] |= op->basereg->size<<1;
	}
	else {
		pcbuf[opcodesize+1] |= 0x40;
	}
	if (op->reg == -1 || op->reg == ZPCREG)
		pcbuf[opcodesize+1] |= 0x80;
	if (op->basedisp == 0)
		pcbuf[opcodesize+1] |= 0x10;
	else
		if (iswordsigned(op->basedisp))
			pcbuf[opcodesize+1] |= 0x20;
		else
			pcbuf[opcodesize+1] |= 0x30;
	if (post)
		pcbuf[opcodesize+1] |= 4;
	if (op->type != TADDRINDIRBASE)
		if (op->outerdisp == 0)
			pcbuf[opcodesize+1] |= 0x01;
		else
			if (iswordsigned(op->outerdisp))
				pcbuf[opcodesize+1] |= 0x2;
			else
				pcbuf[opcodesize+1] |= 0x3;
	
  opcodesize += 2;
  if (op->basedisp) {
		if (op->basedisp->isfp)
			IllegalFloat();
		if (iswordsigned(op->basedisp))
			putword(op->basedisp,FALSE);
		else
			putdword(op->basedisp,FALSE);
	}
	if (op->outerdisp) {
		if (op->outerdisp->isfp)
			IllegalFloat();
		if (iswordsigned(op->outerdisp))
			putword(op->outerdisp,FALSE);
		else
			putdword(op->outerdisp,FALSE);
	}
}
void relpc(OPERANDDATA *op,BOOL ismem)
{
	if (op->reg == PCREG) {
		if (op->basedisp->section)
			op->basedisp->x.value = op->basedisp->x.value - org - opcodesize;
		if (ismem)
			op->basedisp->relpc = TRUE;
	}
}
BOOL ea_fill(OPERANDDATA *op,int size, int sizepos, BOOL pcallowed, 
			BOOL anallowed, BOOL dnallowed, BOOL constallowed)
{
  setsize(size, sizepos);
	if ((op->reg == PCREG || op->reg == ZPCREG) && !pcallowed)
		Error("PC relative addressing not allowed as destination");
	switch (op->type) {
		case TAREG:
			if (!anallowed)
				illop();
			checkbase(op->reg, FALSE);
			pcbuf[1] |= EAADDR | op->reg;
			return(TRUE);
		case TDREG:
			if (!dnallowed)
				illop();
			pcbuf[1] |= EADATA | op->reg;
			return(TRUE);
		case TFREG:
			illop();
			break;
		case TCONST:
			if (!constallowed)
				illop();
			else
				if (op->basedisp->isfp)
					IllegalFloat();
			pcbuf[1] |= EACONST;
			return(putconst(size, op->basedisp));
		case TADDR:
			putadr(op->basedisp);
			return(TRUE);
		case TINDIR:
			pcbuf[1] |= EAINDIR | op->reg;
			return(TRUE);
		case TPREDEC:
			pcbuf[1] |= EAPREDEC | op->reg;
			return(TRUE);
		case TPOSTINC:
			checkbase(op->reg, FALSE);
			pcbuf[1] |= EAPOSTINC | op->reg;
			return(TRUE);
		case TADDRINDIRBASE: 
			relpc(op,TRUE);
			if (op->basereg == 0 && op->basedisp && !op->basedisp->size && prm_procrevision < 2)
				op->basedisp->size = TWORD;
			if (op->basereg == 0 && op->basedisp && iswordsigned(op->basedisp)&& !(op->reg == ZPCREG)) {
				BOOL isrel = FALSE;
				op->basedisp->relpc = FALSE;
				if (op->reg == PCREG) {
					isrel = TRUE;
					pcbuf[1] |= EAPC | op->reg;
				}
				else
					pcbuf[1] |= EAINDIR16 | op->reg;
				putword(op->basedisp,isrel);
			}
			else {
				pcbuf[1] |= getmode(op);
				if (prm_procrevision < 2 || ((!op->basedisp || isbytesigned(op->basedisp)) && op->basereg && !(op->reg==ZPCREG))) {
					if (!op->basereg || (op->reg==ZPCREG) || op->reg ==-1)
						proctype(2);
					else
						briefext(op,FALSE);
				}
				else {
					fullext(op,TRUE,TRUE,FALSE);
				}
			}
			return(TRUE);
		case TMEMPRE:
			pcbuf[1] |= getmode(op);
			relpc(op,TRUE);
			if (NoCPU32())
				fullext(op,TRUE,FALSE,FALSE);
			return(TRUE);
		case TMEMPOST:
			pcbuf[1] |= getmode(op);
			relpc(op,TRUE);
			if (NoCPU32())
				fullext(op,TRUE,FALSE,TRUE);
			return(TRUE);
		case TBITFIELD:
		case TREGLIST:
		case TRQ:
			illop();
			return(FALSE);
	}
  return(FALSE);
}
void op_decimal(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  if (!source || !dest) {
		missingop();
		return;
	}
  if (source->type != dest->type) {
		illop();
		return;
	}
  if (op->size != 0 && op->size != TBYTE)
		badsize();
	if (!checkbase(source->reg,FALSE))
  	checkbase(dest->reg,FALSE);
	pcbuf[0] |= (dest->reg & 7) << 1;
	pcbuf[1] |= source->reg & 7;
	if (source->type == TPREDEC)
		pcbuf[1] |= 8;
	else
		if (source->type != TDREG)
			illop();
}
void op_aaddsub(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  if (!source || !dest) {
		missingop();
		return;
	}
  if (dest->type != TAREG) {
		illop();
	}
	else
		checkbase(dest->reg,FALSE);
	ea_fill(source,op->size,-1,TRUE,TRUE,TRUE,TRUE);
	pcbuf[0] |= (dest->reg& 7) << 1;
	pcbuf[1] |= 0xc0;
	badbyte(op->size);
	badfloat(op->size);
#ifdef OLDSIZING
	if (op->size == TLONG || op->size == 0)
#else
	if (op->size == TLONG)
#endif
		pcbuf[0] |= 1;
}
void op_qaddsub(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  if (!source || !dest) {
		missingop();
		return;
	}
	badfloat(op->size);
  if (source->type != TCONST)
		constexpect();
	if ((source->basedisp->x.value > 8) || (source->basedisp->x.value < 1))
		badconst();
	pcbuf[0] |= (source->basedisp->x.value & 7) << 1;
	if (dest->type == TAREG)
		badbyte(op->size);
	ea_fill(dest,op->size,6,FALSE,TRUE,TRUE,FALSE);
}
void op_iaddsub(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  if (!source || !dest) {
		missingop();
		return;
	}
	badfloat(op->size);
  if (source->type != TCONST)
		constexpect();
	else  {
			putconst(op->size, source->basedisp);
			ea_fill(dest,op->size,6,FALSE,FALSE,TRUE,FALSE);
	}
}
void op_addsub(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  if (!source || !dest) {
		missingop();
		return;
	}
	badfloat(op->size);
	if (dest->type == TAREG) {
		op_aaddsub(op,source,dest);
		return;
	}
	{
		if (source->type != TDREG && dest->type != TDREG) {
			illop();
		}
		else {
			if (dest->type == TDREG) {
				if (source->type == TAREG)
					badbyte(op->size);
				ea_fill(source,op->size,6,TRUE,TRUE,TRUE,TRUE);
				pcbuf[0] |= ((dest->reg & 7) << 1);
			}
			else {
				ea_fill(dest,op->size,6,FALSE,FALSE,FALSE,FALSE);
				pcbuf[0] |= ((source->reg & 7) << 1) | 1;
			}
		}
	}
}
void op_logimm(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  if (!source || !dest) {
		missingop();
		return;
	}
	badfloat(op->size);
  if (source->type != TCONST)
		constexpect();
  if (dest->type == TAREG) {
		if (dest->reg == CCRREG) {
			if (op->size != 0 && op->size != TBYTE)
				illop();
			putconst(TBYTE,source->basedisp);
			pcbuf[1] |= 074;
		}
		else
			if (dest->reg == SRREG) {
				if (op->size != 0 && op->size != TWORD)
					illop();
				putconst(TWORD,source->basedisp);
				pcbuf[1] |= 0174;
			}
			else
				illop();
	}
	else {
		putconst(op->size,source->basedisp);
		ea_fill(dest,op->size,6,FALSE,FALSE,TRUE,FALSE);
	}
}
void op_logical(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  if (!source || !dest) {
		missingop();
		return;
	}
	badfloat(op->size);
	if (dest->type == TAREG) {
		illop();
	}
	{
		if (source->type != TDREG && dest->type != TDREG) {
			illop();
		}
		else {
			if (dest->type == TDREG) {
				if (source->type == TAREG)
					badbyte(op->size);
				ea_fill(source,op->size,6,TRUE,FALSE,TRUE,TRUE);
				pcbuf[0] |= ((dest->reg & 7) << 1);
			}
			else {
				ea_fill(dest,op->size,6,FALSE,FALSE,FALSE,FALSE);
				pcbuf[0] |= ((source->reg & 7) << 1) | 1;
			}
		}
	}
}
void op_shift(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (!dest) {
		missingop();
		return;
	}
	badfloat(op->size);
	if (!source) {
		if (op->size != TWORD && op->size)
			badsize();
		pcbuf[1] &=~0x18;
		ea_fill(dest,op->size,-1,FALSE,FALSE,FALSE,FALSE);
		pcbuf[1] |= 0xc0;
	}
	else {
		if (dest->type != TDREG)
			illop();
		else {
			setsize(op->size,6);
			pcbuf[0] &= ~0x0e;
			pcbuf[1] |= dest->reg & 7;
			if (source->type == TCONST)
				if ((source->basedisp->x.value > 8) || (source->basedisp->x.value < 1))
					badconst();
				else
					pcbuf[0] |= ((source->basedisp->x.value)&7)<<1;
			else
				if (source->type == TDREG) {
					pcbuf[1] |= 0x20;
					pcbuf[0] |= ((source->reg&7)<< 1);
				}
				else
					illop();
		}
	}
}
void op_branch(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  EXPRESSION offset = *dest->basedisp;
	if (source) {
		extraop();
		return;
	}
	if (!dest) {
		missingop();
	}
	badfloat(op->size);
	if (!op->size)
		op->size = branchdefault;
	if (!offset.size)
		offset.size = op->size;
	if (!offset.size && (offset.isextern || offset.relmode || offset.section != sectionnum)) {
		if (prm_procrevision == 2)
			offset.size = TLONG;
		else
			offset.size = TWORD;
	}
	if (op->size == TLONG)
		proctype(2);
  if (dest->type != TADDR && dest->type != TCONST)
		illop();
	offset.x.value = 4;
	if (offset.isdef && !(offset.isextern || offset.relmode))
		offset.x.value = dest->basedisp->x.value-(org+2);
	if (isbytesigned(&offset) && offset.x.value != 0 && offset.x.value != 0xff) {
		if (offset.x.value > 0x7f || offset.x.value < -0x80)
			badsize();
		linkadr(&offset,TBYTE,TRUE);
		pcbuf[1] = offset.x.value;
	}
	else
		if (iswordsigned(&offset)) {
			pcbuf[1] = 0;
			putword(&offset,TRUE);
		}
		else {
			pcbuf[1] = 0xff;
			putdword(&offset,TRUE);
		}
}
void op_bit(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  int ts;
  if (!source || !dest) {
		missingop();
		return;
	}
	badfloat(op->size);
	if (source->type == TDREG) {
		pcbuf[0] |= (source->reg << 1)+ 1;

	}
	else
		if (source->type == TCONST) {
			putbyte(source->basedisp,FALSE);
		 pcbuf[0] |= 8;
		}
		else
			illop();
	if (dest->type == TDREG)
		ts = TLONG;
	else
		ts = TBYTE;
	if (ts != op->size && op->size != 0)
		badsize();
	ea_fill(dest,op->size,-1, FALSE,FALSE,TRUE,FALSE);
}
void op_bitfield(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  EXPRESSION arg;
	proctype(2);
	NoCPU32();
	setarg(&arg,0);
  if (!source || !dest) {
		missingop();
		return;
	}
	badfloat(op->size);
	if (source->type != TBITFIELD) {
		illop();
	}
	if (op->size != 0)
		badsize();
	op->size = TLONG;
	if (source->reg & BFDO)
    arg.x.value |= 0x800;
	else
		if (source->basedisp->x.value > 31 || source->basedisp->x.value < 0)
			illop();
	if (source->reg & BFDW)
		arg.x.value |= 0x20;
	else
		if (source->outerdisp->x.value > 31 || source->outerdisp->x.value < 0)
			illop();
	arg.x.value |= (source->basedisp->x.value & 0x1f) << 6;
	arg.x.value |= (source->outerdisp->x.value & 0x1f);
	putword(&arg,FALSE);
	illprepost(dest);
	ea_fill(dest,op->size,-1,FALSE,FALSE,TRUE,FALSE);
}
void op_bitfieldret(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	proctype(2);
  if (!(source->reg & ISDESTREG))
		illop();
  op_bitfield(op, source, dest);
	pcbuf[2] |= (source->reg & 7) << 4;
}
void op_bitfieldget(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	proctype(2);
	if (!(source->reg & ISSOURCEREG))
		illop();
  op_bitfield(op, source, dest);
	pcbuf[2] |= (source->reg & 7) << 4;
}
void op_bkpt(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	proctype(2);
	if (source) {
		extraop();
	}
	badfloat(op->size);
	if (dest->type != TCONST)
		constexpect();
	if (dest->basedisp->x.value > 7 || dest ->basedisp->x.value < 0)
		badconst();
	pcbuf[1] |= dest->basedisp->x.value & 7;
}
void op_callm(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (prm_procrevision != 2)
		invproc();
  if (!source || !dest) {
		missingop();
		return;
	}
	if (op->size)
		badsize();
	op->size = TLONG;
  if (source->type != TCONST)
		badconst();
	putbyte(source->basedisp,FALSE);
	illprepost(dest);
  ea_fill(dest,op->size,-1,TRUE,FALSE,FALSE,FALSE);
}
void op_cas(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest, OPERANDDATA *extra)
{
	EXPRESSION arg;
	proctype(2);
	NoCPU32();
	setarg(&arg,0);
	if (!source || !dest || !extra) {
		missingop();
		return;
	}
	badfloat(op->size);
	if (source->type != TDREG || dest->type != TDREG)
		illop();
	arg.x.value = ((dest->reg & 7) << 6) | (source->reg & 7);
	putword(&arg,FALSE);
	ea_fill(extra,op->size,-1,FALSE,FALSE,FALSE,FALSE);
	switch (op->size) {
		case TBYTE:
			pcbuf[0] |= 2;
			break;
#ifndef OLDSIZING
		default:
#endif
		case TWORD:
			pcbuf[0] |= 4;
			break;
		case TLONG:
#ifdef OLDSIZING
		default:
#endif
			pcbuf[0] |= 6;
			break;
	}
}
void op_cas2(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest, OPERANDDATA *extra)
{
	EXPRESSION arg;
	proctype(2);
	NoCPU32();
	setarg(&arg,0);
	if (!source || !dest || !extra) {
		missingop();
		return;
	}
	badfloat(op->size);
#ifdef OLDSIZING
	if (op->size == TLONG || op->size == 0)
#else
	if (op->size == TLONG)
#endif
		pcbuf[0] |= 0x2;
	if (source->type != TRQ || dest->type != TRQ || extra->type != TRQI)
		illop();
	else {
		if (extra->reg > 16 || extra->basedisp->x.value > 16)
			illop();
		else {
			arg.x.value = (extra->reg << 12) + (dest->reg << 6) + source->reg;
			putuword(arg.x.value);
			arg.x.value = (extra->basedisp->x.value << 12) + (dest->basedisp->x.value << 6) + source->basedisp->x.value;
			putuword(arg.x.value);
			badbyte(op->size);
		}
	}
}
void op_chk(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  if (!source || !dest) {
		missingop();
		return;
	}
	badfloat(op->size);
  if (dest->type != TDREG)
		illop();
	pcbuf[0] |= ((dest->reg & 7) << 1)+ 1;
  if (op->size == TBYTE)
		badsize();
#ifdef OLDSIZING
	if (op->size == TWORD)
#else
	if (op->size == TWORD || !op->size)
#endif
		pcbuf[1] |= 0x80;
	ea_fill(source,op->size,-1,TRUE,FALSE,TRUE,TRUE);
}
void op_chk2(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	EXPRESSION arg;
	proctype(2);
	setarg(&arg,0);
  arg.x.value=0x0800;
  if (!source || !dest) {
		missingop();
		return;
	}
	badfloat(op->size);
  if (dest->type != TDREG && dest->type != TAREG)
		illop();
  if (dest->type == TAREG) {
		arg.x.value |= 0xffff8000L;
		checkbase(dest->reg,FALSE);
	}
  arg.x.value |= (dest->reg ) << 12;
	putword(&arg,FALSE);
	illprepost(source);
	ea_fill(source,op->size,9,TRUE,FALSE,FALSE,FALSE);
}
void op_clear(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (source)
		extraop();
	if (!dest)
		missingop();
	badfloat(op->size);
  ea_fill(dest,op->size,6,FALSE,FALSE,TRUE,FALSE);
}
void op_cmp2(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	proctype(2);
  op_chk2(op,source,dest);
	pcbuf[2] &= ~0x8;
}
void op_cmpm(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  if (!source || !dest) {
		missingop();
		return;
	}
	if (source->type != TPOSTINC || dest->type != TPOSTINC)
		illop();
	badfloat(op->size);
  checkbase(source->reg,FALSE);
  checkbase(dest->reg,FALSE);
	pcbuf[1] |= source->reg & 7;
  pcbuf[0] |= (dest->reg & 7 ) << 1;
	setsize(op->size,6);
}
void op_dbranch(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  if (!source || !dest) {
		missingop();
		return;
	}
	if (op->size && op->size != TWORD)
		badsize();
  if (source->type != TDREG || (dest->type != TADDR && dest->type != TCONST))
		illop();
	pcbuf[1] |= source->reg & 7;
	if (dest->basedisp->isdef)
		dest->basedisp->x.value = dest->basedisp->x.value - (org+2);
	else
		dest->basedisp->x.value = 0x02;
	if (!iswordsigned(dest->basedisp))
		Error("Branch param out of range");
  putword(dest->basedisp,TRUE);
}
void op_muldiv(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  EXPRESSION arg;
	setarg(&arg,0);
	if (!source || !dest) {
		missingop();
		return;
	}
	badfloat(op->size);
	if (dest->type == TRQ) { 
#ifdef OLDSIZING
	  if (op->size != TLONG && op->size != 0)
#else
	  if (op->size != TLONG)
#endif
			badsize();
	  proctype(2);
		opcodesize = 0;
		putuword(op->op2);
		arg.x.value  |= 0x0c00;
		arg.x.value |= (dest->basedisp->x.value&7) << 12;
		arg.x.value |= dest->reg&7;
		putword(&arg,FALSE);
	}
	else {
		if (op->size == 0) {
		  op->size = TWORD;
		}
		if (dest->type == TDREG) {
			switch(op->size) {
				case TBYTE:
					illop();
					break;
				case TWORD:
					pcbuf[0] |= (dest->reg & 7)<<1;
					break;
				case TLONG:
					proctype(2);
					opcodesize = 0;
					putuword(op->op2);
					arg.x.value |= ((dest->reg& 7) << 12) | (dest->reg & 7) | 0x800;
					putword(&arg,FALSE);
					break;
			}
		}
		else illop();
	}
	ea_fill(source,TWORD,-1,TRUE,FALSE,TRUE,TRUE);
}    
void op_muldivl(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  EXPRESSION arg;
	setarg(&arg,0);
	arg.x.value = 0x0800;
	proctype(2);
	if (!source || !dest) {
		missingop();
		return;
	}
	if (dest->type != TRQ)
		illop();
	else {
#ifdef OLDSIZING
	  if (op->size != TLONG && op->size != 0)
#else
	  if (op->size != TLONG)
#endif
			badsize();
		arg.x.value |= dest->basedisp->x.value << 12;
		arg.x.value |= dest->reg;
		putword(&arg,FALSE);
	}
	ea_fill(source,TLONG,-1,TRUE,FALSE,TRUE,TRUE);
}    
void op_muldivu(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{  
	EXPRESSION arg;
	setarg(&arg,0);
	if (!source || !dest) {
		missingop();
		return;
	}
	badfloat(op->size);
	if (dest->type == TRQ) { 
#ifdef OLDSIZING
	  if (op->size != TLONG && op->size != 0)
#else
	  if (op->size != TLONG)
#endif
			badsize();
	 	proctype(2);
		opcodesize = 0;
		putuword(op->op2);
		arg.x.value |= 0x0400;
		arg.x.value |= (dest->basedisp->x.value) << 12;
		arg.x.value |= dest->reg;
		putword(&arg,FALSE);
	}
	else {
		if (op->size == 0) {
			op->size = TWORD;
		}
		if (dest->type == TDREG) {
			switch(op->size) {
				case TBYTE:
					illop();
					break;
				case TWORD:
					pcbuf[0] |= (dest->reg & 7)<<1;
					break;
				case TLONG:
					proctype(2);
					opcodesize = 0;
					putuword(op->op2);
					arg.x.value |= ((dest->reg& 7) << 12) | (dest->reg & 7);
					putword(&arg,FALSE);
					break;
			}
		}
		else
			illop();
	}
	ea_fill(source,TWORD,-1,TRUE,FALSE,TRUE,TRUE);
}    
void op_muldivul(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  EXPRESSION arg;
	setarg(&arg,0);
	if (!source || !dest) {
		missingop();
		return;
	}
	if (dest->type != TRQ)
		illop();
	else {
	  if (op->size != TLONG && op->size != 0)
			badsize();
		arg.x.value |= dest->basedisp->x.value << 12;
		arg.x.value |= dest->reg;
		putword(&arg,FALSE);
	}
	ea_fill(source,TLONG,-1,TRUE,FALSE,TRUE,TRUE);
}    
void op_exg(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (!source || !dest) {
		missingop();
		return;
	}
	badfloat(op->size);
	if (source->type == TAREG && dest->type == TDREG) {
		OPERANDDATA *t =source;
		source = dest;
		dest = t;
	}
	if (dest->type == TAREG) {
		checkbase(dest->reg, FALSE);
		if (source->type == TAREG) {
			checkbase(source->reg, FALSE);
			pcbuf[1] |= 0x48;
		}
		else
			if (source->type == TDREG)
				pcbuf[1] |= 0x88;
			else {
				pcbuf[1] = 0x48;
				illop();
			}
	}
	else
		if (dest->type == TDREG && source->type == TDREG)
			pcbuf[1] |= 0x40;
		else
			illop();
	pcbuf[0] |= (source->reg & 7) << 1;
	pcbuf[1] |= (dest->reg & 7);
}
void op_ext(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  uint om;
  if (source)
		extraop();
	if (!dest)
		missingop();
  if (strlen(op->text) == 4) {
		proctype(2);
		om = 7;
#ifdef OLDSIZE
		if (op->size != TLONG && op->size != 0)
#else
		if (op->size != TLONG)
#endif
			illop();
	}
	else
		if (op->size == TBYTE)
			illop();
		else
#ifdef OLDSIZING
			om = 3-(op->size == TWORD);
#else
			om = 3-(op->size == TWORD || op->size == 0);
#endif

	pcbuf[1] |= ((om & 3) << 6) | (dest->reg & 7);
	pcbuf[0] |= (om >> 2) & 1;
}
void op_jmp(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  if (source)
		extraop();
	badfloat(op->size);
	illprepost(dest);
	ea_fill(dest,op->size,-1,TRUE,FALSE,FALSE,FALSE);
}
void op_lea(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (dest->type == TAREG) {
		checkbase(dest->reg,TRUE);
		pcbuf[0] |= (dest->reg &7) << 1;
	}
	else
		illop();
	badbyte(op->size);
	badfloat(op->size);
	if (op->size == TWORD)
		badbyte(TBYTE);
	illprepost(source);
	ea_fill(source,op->size,-1,TRUE,FALSE,FALSE,FALSE);
}
void op_link(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (!source || !dest) {
		missingop();
		return;
	}
	badfloat(op->size);
  if (source->type != TAREG)
    illop();
	else
		pcbuf[1] |= (source->reg & 7); 
	if (dest->type != TCONST)
		illop();
	badbyte(op->size);
	if (op->size != TLONG) {
		if (!iswordsigned(dest->basedisp))
			badconst();
		op->size = TWORD;
		pcbuf[0] |= 0x06;
		pcbuf[1] |= 0x50;
	}
	else {
		proctype(2);
		pcbuf[1] |= 8;
	}
	putconst(op->size,dest->basedisp);
}
void op_movea(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	int size = op->size;
	switch(size) {
#ifdef ORGSIZING
		case 0:
#endif
		case TLONG:
			size = 3;
			break;
		case TBYTE:
			size = 2;
			break;
#ifndef ORGSIZING
		case 0:
#endif
		case TWORD:
			size = 4;
			break;
		default:
			badsize();
	}
	if (!source || !dest) {
		missingop();
		return;
	}
	if (dest->type != TAREG)
		illop();
	badbyte(op->size);
	ea_fill(source,op->size,-1,TRUE,TRUE,TRUE,TRUE);
	setsize(size,12);
	checkbase(dest->reg,FALSE);
	pcbuf[0] |= ((dest->reg & 7) << 1);
	pcbuf[1] |= 0x40;
}
void op_move(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	int size = op->size;
	switch(size) {
#ifdef ORGSIZING
		case 0:
#endif
		case TLONG:
			size = 3;
			break;
		case TBYTE:
			size = 2;
			break;
#ifndef ORGSIZING
		case 0:
#endif
		case TWORD:
			size = 4;
			break;
	}
	if (!source || !dest) {
		missingop();
		return;
	}
	badfloat(op->size);
	if (dest->type == TAREG && dest->reg > 7)
		if (dest->reg == CCRREG || dest->reg == SRREG) {
			if (dest->reg == CCRREG) {
				if (op->size == 0)
					op->size = TBYTE;
				else
					if (op->size != TBYTE)
						badsize();
			}
			else
				if (op->size == 0)
					op->size = TWORD;
				else
					if (op->size != TWORD)
						badsize();
			opcodesize = 0;
			putuword(op->op2 | 0x480);
			if (dest->reg == SRREG)
				pcbuf[0] |= 2;
			ea_fill(source,op->size,-1,TRUE,FALSE,TRUE,TRUE);
			return;
		
		}
		else 
			if (dest->reg == USPREG)
			  if (source->type == TAREG) {
					checkbase(source->reg,FALSE);
					if (op->size != TLONG && op->size != 0)
						badsize();
					opcodesize = 0;
					putuword(op->op2 | 0xe20);
					pcbuf[0] |= 6;
					pcbuf[1] |= (source->reg & 7) |0x20;
					return;
				}
				else
					illop();
			else
				illop();
	else {
		unsigned temp;
		unsigned temp1;
		if (source->type == TAREG) {
			if (source->reg == CCRREG || source->reg == SRREG){
				if (op->size != 0)
					if (source->reg == CCRREG) {
						if (op->size != TBYTE)
							badsize();
					}
					else
						if (op->size != TWORD)
							badsize();
				opcodesize = 0;
				putuword(op->op2 | 0x80);
				if (source->reg == CCRREG)
					pcbuf[0] |= 2;
				ea_fill(dest,op->size,-1,FALSE,FALSE,TRUE,FALSE);
				return;
			}
			else
				if (source->reg == USPREG) {
					if (dest->type != TAREG)
						illop();
					if (op->size != TLONG && op->size != 0)
						badsize();
					checkbase(dest->reg,FALSE);
					opcodesize = 0;
					putuword(op->op2 | 0xe28);
					pcbuf[0] |= 6;
					pcbuf[1] |= 0x28 | (dest->reg & 7);
					return;
				}
				else
					if (dest->type == TAREG) {
						op_movea(op,source,dest);
						return;
					}
		}
		else
			if (dest->type == TAREG) {
				op_movea(op,source,dest);
				return;
			}
		ea_fill(source,op->size,-1,TRUE,TRUE,TRUE,TRUE);
		temp = ((pcbuf[0] << 8) + pcbuf[1]);
		pcbuf[0] = pcbuf[1] = 0;
		ea_fill(dest,op->size,-1,FALSE,FALSE,TRUE,FALSE);
		temp1 = ((pcbuf[0] << 8) + pcbuf[1]);
		temp1 = (temp1 >> 3) | ((temp1 & 7) << 3);
		temp1 = (temp1 << 6) | temp;
		pcbuf[0] = temp1 >> 8;
		pcbuf[1] = temp1 & 255;
		setsize(size,12);
	}
}
void op_movec(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{     
  EXPRESSION arg;
	proctype(1);
	setarg(&arg,0);
	if (!source || !dest) {
		missingop();
		return;
	}
	badfloat(op->size);
	if (dest->type == TAREG && dest->reg >= CONTROLREGS) {
		if (source->type == TAREG) {
			checkbase(source->reg,FALSE);
			arg.x.value |= 0x8000;
		}
		else
			if (source->type != TDREG)
				illop();
		arg.x.value |= (dest->reg & 0xfff) | ((source->reg & 7) <<12);
		pcbuf[1] |= 1;
	}
	else
		if (source->type == TAREG && source->reg >= CONTROLREGS) {
			if (dest->type == TAREG) {
				checkbase(dest->reg,FALSE);
				arg.x.value |= 0x8000;
			}
			else
				if (dest->type != TDREG)
					illop();
			arg.x.value |= (source->reg & 0xfff) | ((dest->reg & 7) <<12);
		}
		else
			illop();
	badbyte(op->size);
	if (op->size == TWORD)
		badbyte(TBYTE);
	putuword(arg.x.value);
}
void op_movem(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (!source || !dest) {
		missingop();
		return;
	}
	badfloat(op->size);
	badbyte(op->size);
	if (source->type == TREGLIST) {	
		if (dest->type == TPOSTINC)
			illop();
		if (dest->type == TPREDEC) {
			unsigned temp = 0;
			int i;
			unsigned mask1 = 1;
			unsigned mask2 = 0x8000;
			for (i=0; i < 16; i++) {
				if (source->reg & mask1)
					temp |= mask2;
				mask1 <<=1;
				mask2 >>=1;
			}
			source->reg = temp;
		}
		putuword(source->reg);
		ea_fill(dest,op->size,-1,FALSE,FALSE,FALSE,FALSE);
	}
	else
		if (dest->type == TREGLIST) {
			if (source->type == TPREDEC)
				illop();
			putuword(dest->reg);
			pcbuf[0] |= 4;
			ea_fill(source,op->size,-1,TRUE,FALSE,FALSE,FALSE);
		}
		else
			illop();
#ifdef OLDSIZING
	if (op->size != TWORD)
#else
	if (op->size == TLONG)
#endif
		pcbuf[1] |= 0x40;
}
void op_movep(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (!source || !dest) {
		missingop();
		return;
	}
	badfloat(op->size);
	badbyte(op->size);
	if (source->type == TDREG) {
		if (dest->type != TADDRINDIRBASE)
			illop();
		else
			checkbase(dest->reg, FALSE);
		if (!isword(dest->basedisp))
			illop();
		pcbuf[0] |= 1 | ((source->reg & 7) << 1);
		pcbuf[1] |= 0x80 | (dest->reg & 7);
		putuword(dest->basedisp->x.value);
	}
	else
	  if (dest->type == TDREG) {
			if (source->type != TADDRINDIRBASE)
				illop();
			else
				checkbase(source->reg, FALSE);
			if (!isword(source->basedisp))
				illop();                   
			pcbuf[0] |= 1 | ((dest->reg&7)<<1);
			pcbuf[1] |= (source->reg & 7);
			putuword(source->basedisp->x.value);
		}
		else
			illop();
#ifdef OLDSIZING
	if (op->size != TWORD)
#else
	if (op->size == TLONG)
#endif
		pcbuf[1] |= 0x40;
}
void op_moveq(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (!source || !dest) {
		missingop();
		return;
	}
	badfloat(op->size);
	if (op->size != TLONG && op->size != 0)
		badsize();
	if (source->type != TCONST)
		badconst();
	else 
		if (dest->type != TDREG)
			illop();
		else
			if (!isbyte(source->basedisp))
				badconst();
	
	pcbuf[1] = source->basedisp->x.value & 0xff;
	pcbuf[0] |= (dest->reg & 7 ) << 1;
}
void op_moves(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	EXPRESSION arg;
	proctype(1);
	setarg(&arg,0);
	if (!source || !dest) {
		missingop();
		return;
	}
	badfloat(op->size);
	if (dest->type == TAREG || dest->type == TDREG) {
		if (dest->type == TAREG) {
			checkbase(dest->reg,FALSE);
			arg.x.value |= 0x8000;
		}
		arg.x.value |= ( dest->reg & 7) << 12;
		putword(&arg,FALSE);
		ea_fill(source,op->size,6,FALSE,FALSE,FALSE,FALSE);
	}
	else
		if (source->type == TAREG || source->type == TDREG) {
			if (source->type == TAREG) {
				checkbase(source->reg,FALSE);
				arg.x.value |= 0x8000;
			}
			arg.x.value |= (( source->reg & 7) << 12) | 0x0800;
			putword(&arg,FALSE);
			ea_fill(dest,op->size,6,FALSE,FALSE,FALSE,FALSE);
		}
		else
			illop();
}
void op_neg(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (source)
		extraop();
	if (!dest) {
		missingop();
		return;
	}
	badfloat(op->size);
	ea_fill(dest,op->size,6,FALSE,FALSE,TRUE,FALSE);
	
}
void op_1word(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (source || dest)
		extraop();
	if (op->size)
		badsize();
}
void op_pack(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest, OPERANDDATA *extra)
{
	proctype(2);
	NoCPU32();
  if (!source || !dest || !extra) {
		missingop();
		return;
	}
	if (op->size)
		badsize();
	if (source->type == dest->type && (source->type == TDREG || source->type == TPREDEC)      
			&& (extra->type == TCONST)) {
		if (source->type == TPREDEC) {
			pcbuf[1] |= 8;
			checkbase(source->reg,FALSE);
			checkbase(dest->reg,FALSE);
		}
		if (!isword(extra->basedisp))
			badconst();
		pcbuf[1] |= source->reg & 7;
		pcbuf[0] |= (dest->reg &7) << 1;
		putuword(extra->basedisp->x.value);
	}
	else
		illop();
		
}
void op_rtd(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	proctype(1);
  if (source)
		extraop();
	if (!dest) {
		missingop();
		return;
	}
	if (op->size)
		badsize();
	if (dest->type != TCONST)
		constexpect();
  if (!isword(dest->basedisp))
		badconst();
	putuword(dest->basedisp->x.value);
}
void op_rte(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	op_1word(op,source,dest);
}
void op_rtm(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (prm_procrevision != 2)
		invproc();
  if (source)
		extraop();
	if (!dest) {
		missingop();
		return;
	}
	if (op->size)
		badsize();
	if (dest->type != TDREG && dest->type != TAREG)
		illop();
	if (dest->type == TAREG) {
		checkbase(dest->reg,FALSE);
		pcbuf[1] |= 8;
	}
	pcbuf[1] |= (dest->reg & 7);

}

void op_stop(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  if (source)
		extraop();
	if (!dest) {
		missingop();
		return;
	}
	if (op->size)
		badsize();
  if (dest->type != TCONST)
		constexpect();
	else
		if (!isword(dest->basedisp))
			badconst();
		else
			putuword(dest->basedisp->x.value);
}
void op_swap(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  if (source)
		extraop();
	if (!dest) {
		missingop();
		return;
	}
	if (op->size)
		badsize();
	if (dest->type != TDREG)
		illop();
	else
		pcbuf[1] |= dest->reg;
}

void op_trap(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  if (source)
		extraop();
	if (!dest) {
		missingop();
		return;
	}
	if (op->size)
		badsize();
  if (dest->type != TCONST)
		constexpect();
	else
		if (dest->basedisp->x.value > 16 || dest->basedisp->x.value < 0)
			illop();
		else
			pcbuf[1] |= dest->basedisp->x.value & 0x0f;
}
void op_trapcc(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	proctype(2);
	if (source)
		extraop();
	badfloat(op->size);
	if (dest) {
		if (op->size == TBYTE)
			badsize();
#ifdef OLDSIZING
		if (op->size == TWORD) {
#else
		if (op->size == TWORD || !op->size) {
#endif
			putword(dest->basedisp,FALSE);
		  pcbuf[1] |= 2;
		}
		else {
			putdword(dest->basedisp,FALSE);
			pcbuf[1] |= 3;
		}
	}
	else
		pcbuf[1] |= 4;
}
void op_tst(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	op_neg(op,source,dest);
}
void op_unlk(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (source)
		extraop();
	if (!dest || dest->type != TAREG)
		illop();
	if (op->size)
		badsize();
	checkbase(dest->reg,FALSE);
	pcbuf[1] |= dest->reg & 7;
}
void op_negdecimal(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (op->size == 0)
		op->size = TBYTE;
	if (op->size != TBYTE)
		badsize();
	op_neg(op,source,dest);
}
void op_pea(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (source)
		extraop();
	if (!dest) {
		missingop();
		return;
	}
	if (op->size != 0 && op->size != TLONG)
		badsize();
	ea_fill(dest,op->size,-1,TRUE,FALSE,FALSE,FALSE);
}
void op_xaddsub(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  if (!source || !dest) {
		missingop();
		return;
	}
  if (source->type != dest->type) {
		illop();
		return;
	}
	badfloat(op->size);
	if (!checkbase(source->reg,FALSE))
  	checkbase(dest->reg,FALSE);
	pcbuf[0] |= (dest->reg & 7) << 1;
	pcbuf[1] |= source->reg & 7;
	setsize(op->size,6);
	if (source->type == TPREDEC)
		pcbuf[1] |= 8;
	else
		if (source->type != TDREG)
			illop();
}
void op_icmp(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  if (!source || !dest) {
		missingop();
		return;
	}
  if (source->type != TCONST)
		constexpect();
	badfloat(op->size);
	putconst(op->size, source->basedisp);
	ea_fill(dest,op->size,6,TRUE,FALSE,TRUE,FALSE);
}
void op_eor(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  if (!source || !dest) {
		missingop();
		return;
	}
	badfloat(op->size);
	if (source->type == TCONST && (dest->type != TAREG || dest->reg > 7)) {
		pcbuf[0] =0x0a;
		pcbuf[1] = 0;
		op_logimm(op,source,dest);
		return;
	}
	if (source->type != TDREG) {
		illop();
	}
	else {
		ea_fill(dest,op->size,6,FALSE,FALSE,TRUE,FALSE);
		pcbuf[0] |= ((source->reg & 7) << 1) | 1;
	}
}

void op_cmp(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
  if (!source || !dest) {
		missingop();
		return;
	}
	if (source->type == TCONST && dest->type != TAREG) {
		pcbuf[0] = 0x0c;
		pcbuf[1] = 0;
		op_icmp(op,source,dest);
		return;
	}
	if (dest->type == TAREG) {
		op_aaddsub(op,source,dest);
		return;
	}
	badfloat(op->size);
	if (dest->type != TDREG) {
		illop();
	}
	else {
		ea_fill(source,op->size,6,TRUE,TRUE,TRUE,TRUE);
		pcbuf[0] |= ((dest->reg & 7) << 1);
	}
}
void op_addgeneric(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (source->type == TCONST)
		if ((source->basedisp->x.value <9) && (source->basedisp->x.value >0)) {
			pcbuf[0] = 0x50;
			pcbuf[1] = 0;
			op_qaddsub(op,source,dest);
		}
		else {
			if (dest->type == TAREG)
				goto oagcom;
			pcbuf[0] = 0x06;
			pcbuf[1] = 0;
			op_iaddsub(op,source,dest);
		}
	else
oagcom:
		op_addsub(op,source,dest);
}
void op_andgeneric(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (source->type == TCONST && (dest->type != TAREG || dest->reg > 7)) {
			pcbuf[0] = 0x02;
			pcbuf[1] = 0;
		op_logimm(op,source,dest);
	}
	else
		op_logical(op,source,dest);
}
void op_orgeneric(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (source->type == TCONST && (dest->type != TAREG || dest->reg > 7)) {
			pcbuf[0] = 0x00;
			pcbuf[1] = 0;
		op_logimm(op,source,dest);
	}
	else
		op_logical(op,source,dest);
}
void op_subgeneric(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (source->type == TCONST)
		if ((source->basedisp->x.value <9) && (source->basedisp->x.value >0)) {
			pcbuf[0] = 0x51;
			pcbuf[1] = 0;
			op_qaddsub(op,source,dest);
		}
		else {
			if (dest->type == TAREG)
				goto osgcom;
			pcbuf[0] = 0x04;
			pcbuf[1] = 0;
			op_iaddsub(op,source,dest);
		}
	else
osgcom:
		op_addsub(op,source,dest);
}
void op_movegeneric(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (!source || !dest)
		op_move(op,source,dest);
	else
#ifdef ORGSIZING
		if ((op->size == TLONG || !op->size) && source->type == TCONST && dest->type == TDREG && isbytesigned(source->basedisp) && !source->basedisp->islabel) {
#else
		if ((op->size == TLONG) && source->type == TCONST && dest->type == TDREG && isbytesigned(source->basedisp) && !source->basedisp->islabel) {
#endif
				pcbuf[1] = source->basedisp->x.value & 0xff;
				pcbuf[0] = 0x70 | ((dest->reg & 7 ) << 1);
		}
		else
			op_move(op,source,dest);
}
void op_lpstop(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	if (prm_procrevision != 5)
		proctype(100);
  if (source)
		extraop();
	if (!dest) {
		missingop();
		return;
	}
	if (op->size && op->size != TWORD)
		badsize();
	if (dest->type != TCONST)
		constexpect();
  if (!isword(dest->basedisp))
		badconst();
	putuword(0x01c0);
	putuword(dest->basedisp->x.value);
}
void op_tbl(OPCODEDATA *op, OPERANDDATA *source, OPERANDDATA *dest)
{
	unsigned size =op->size;
	if (prm_procrevision != 5)
		proctype(100);
	if (!source || !dest) {
		missingop();
		return;
	}
	pcbuf[2] = pcbuf[0];
	pcbuf[3] = pcbuf[1];
	pcbuf[0] = 0xf8;
	pcbuf[1] = 0;
	opcodesize+=2;
	if (op->size > TLONG)
		badsize();
	if (size)
		size--;
	else
		size = TLONG-1;
	size <<= 6;
	pcbuf[3] |= size;
	if (dest->type != TDREG) 
		illop();
	if (source->type == TTBLOP) {
		int dm,dn,dx;
		dm = source->reg & 0x07;
		dn = source->reg >> 3;
		dx = dest->reg;
		pcbuf[1] |= dm;
		pcbuf[2] |= dx << 4;
		pcbuf[3] |= dn;
	}
	else {
		if (source->type == TPOSTINC)
			illop();
		pcbuf[2] |= 1 | (dest->reg << 4);
		ea_fill(source,0,-1,TRUE,FALSE,FALSE,FALSE);
	}
}

void (* optable[])() = { /* NOPROTOTYPE */
  0, op_decimal , op_addsub , op_aaddsub , op_iaddsub , op_qaddsub , op_logical ,
  op_logimm , op_shift , op_branch , op_bit , op_bitfield , op_bitfieldret ,
  op_bitfieldget , op_bkpt , op_callm , op_cas , op_cas2 , op_chk , op_chk2 ,
  op_clear , op_cmp2 , op_cmpm , op_dbranch , op_muldiv , op_muldivl ,
  op_muldivu , op_muldivul , op_exg , op_ext , op_jmp , op_lea ,
  op_link , 0 , op_move , op_movea , op_movec , op_movem , op_movep ,
  op_moveq , op_moves , op_neg , op_1word , op_pack , op_rtd , op_rte ,
  op_rtm , op_stop , op_swap , op_trap , op_trapcc , op_tst , op_unlk ,
  op_negdecimal , op_pea, op_xaddsub, op_icmp , op_eor , op_cmp,
	op_addgeneric, op_andgeneric, op_orgeneric, op_subgeneric, op_movegeneric,
	op_freg, op_fregd, op_fregt, op_fbcc, op_fdbcc, op_ftrapcc, op_fsincos,
	op_fmovecr, op_fmove, op_fmovem, op_fnop, op_fsaverest, op_fscc,
	op_fsreg, op_fdreg, op_cinvpush, op_pflush, op_pload, op_pmove, op_ptest,
	op_lpstop, op_tbl
} ;
void align(void) 
{
	if (org & 1) {
		outputbuf[org++] = 0;
	}
}
void gencode(OPCODEDATA *zopcode, OPERANDDATA *op1, OPERANDDATA *op2)
{
  memset(pcbuf,BUFLEN,0);
	opcodesize = 0;
	align();
	putuword(zopcode->op1);
  if (!ifskip && checkAllExpr(op1) && checkAllExpr(op2))
 		(*optable[zopcode->type & OP_TYPEMASK])(zopcode,op1,op2,0L);
	dolist();
	copytomem();
  zopcode->size = 0;  
  deloperand(op1);
  deloperand(op2);
}
void gencode2(OPCODEDATA *zopcode, OPERANDDATA *op1, OPERANDDATA *op2, OPERANDDATA *op3)
{
  memset(pcbuf,BUFLEN,0);
	opcodesize = 0;
	align();
	putuword(zopcode->op1);
	if (!ifskip)
  	(*optable[zopcode->type & OP_TYPEMASK])(zopcode,op1,op2,op3);
	dolist();
	copytomem();
  zopcode->size = 0;
	deloperand(op1);
	deloperand(op2);
	deloperand(op3);
}
void gc_rundown(void)
{
	basealign = 2;
	usedrevision = 0;
	branchdefault = 0;
	undeflist = 0;
	opcodesize = 0;
	outputbuf = 0;
	org = 0;
	execadr = 0;
}