%{
#include <stdio.h>
#include "utype.h"
#include "umem.h"
#include "as68k.h"  /* Contains definition of `symrec'        */
#include "asmcom.h"
#include "locgen.h"
#include "locexpr.h"
extern int sectionnum;
extern BOOL ToFixup;
%}
%union {
long	reg;
long     val;  /* For returning numbers.                   */
BASE *baseptr;
OPERANDDATA *opeptr;
OPCODEDATA *opcptr;
EXPRESSION *expr;
BYTE floatptr[12];
char *string;
}

%token <reg> AREG DREG MREG FREG MMUREG 
%token <val> SCALE TYPE END ORG DC DS IC INCLUDE PUBLICX EXTERNAL ALIGN MACRO
%token <val> DCB EQU SET FAIL IGNORE LISTON LISTOFF MACEXIT PAGEON PAGEOFF
%token <val> LINES TITLE MSG SUBTTL PAGEBREAK STRUCT ENDSTRUCT
%token <val> LOGOR LOGAND NE EQ GE LE SHLEFT SHRIGHT SWAPPER
%token <val> IF IF2 REPT ELSE ELSEIF ENDIF SECTION SIZEOF MODE
%token <val> OPT OPTEQU OPTTYPE OPTEQUTYPE PHITEXTSTREAM
%token <val> FOPT NOFIX 
%token <floatptr> FNUM FNUMSPEC
%token <string> STRING
%token <opcptr> OPCODE OPCODE_MOVEM OPCODE_FPMOVEM OPCODE_MMU
%token <val>  NUM        /* Simple double precision number   */
%token <expr> SYMBOL MOVEMREGSYM OPERANDSYM STRUCTSYM MACROSYM FSYM
%type <reg> qreg reglist fpreglist
%type <opcptr> opcode opmovem opmovemfp
%type <opeptr> operand movmoperand ari armpost armpre bitfield fpmovmoperand
%type <opeptr> caches fc tightoperand
%type <baseptr> base dbase
%type <val> scale dclist
%type <expr> exp publist extlist label xlabel fexp

%left ','
%right '='
%left LOGOR
%left LOGAND
%left NE EQ
%left '>' '<' GE LE 
%left '-' '+'
%left '*' '/' '%' SCALE
%left '&' '|' '^' SHLEFT SHRIGHT
%left NEG     /* Negation--unary minus */
/* Grammar follows */

%%

input:   /* empty */
	| input line 
;

line:	  '\n'		{ dolist(); }
	| directive	{ }
	| xlabel SET exp '\n'       { setexp($1, $3) ; }
        | xlabel '=' exp '\n'       { setexp($1,$3); }
        | xlabel SET fexp '\n'       { setfpexp($1,$3); }
        | xlabel '=' fexp '\n'       { setfpexp($1,$3); }
	| label STRUCT '\n'	{ initstruct($1); }
	| STRUCTSYM STRUCT '\n'	{ initstruct($1); }
	| label DC TYPE dclist '\n'	{ processdc($3, $1); }
	| label PHITEXTSTREAM dclist '\n'	{ processphitext($1); }
	| label DCB TYPE exp ',' exp '\n'	{ processdcb($3,$1,$4,$6); }
	| label DS TYPE exp '\n'	{ processds($3, $1, $4); }
	| label	'\n'	{ dolist(); }
	| label MACRO	{ createMacro($1); };
	| label MREG reglist '\n' { setmovemreg($1,$3); }
	| label MACROSYM { OpenMacro($1,$2); }
	| MOVEMREGSYM MREG reglist '\n' { dolist(); }
	| label EQU exp '\n'	{ equexp($1, $3) ; }
	| label EQU operand { equop($1, $3); }
	| label EQU fexp '\n' { equfpexp($1, $3); }
	| OPERANDSYM EQU operand { dolist(); }
        | label command  { }
        | error '\n' { yyerrok;               }
;
dclist:	  STRING    		{ dcstring($1); }
	| exp			{ dcexp($1); }
	| fexp			{ dcexp($1); }
	| dclist ',' dclist
;
publist:  exp			{ AddPublic($1); }
	| publist ',' publist
;
extlist:  exp			{ AddExtern($1, 0); }
	| exp TYPE		{ AddExtern($1,$2); }
	| extlist ',' extlist
;
label:	/* empty */	{ $$ = 0; }
	| SYMBOL 	{ EXPRESSION *q; 
				$1->isdef = 1; 
  				$1->islabel = 1; 
    				$1->x.value = currentorg(); 
     				$1->isintermed = 0;
				if ( q =AddToTable($1))
					$$ = q;
				else $$ = $1; }
	| SYMBOL ':'	{ EXPRESSION *q;
				$1->isdef = 1; 
				$1->islabel = 1; 
				$1->x.value = currentorg(); 
				$1->isintermed = 0;
				if ( q =AddToTable($1))
					$$ = q;
				else $$ = $1; }
;
xlabel:	 SYMBOL ':'	{ $1->isdef = 1; 
				$1->isintermed = 0;
				$$ = $1; }
	| SYMBOL 	{ $1->isdef = 1; 
				$1->isintermed = 0;
				$$ = $1; }
	| FSYM ':'	{ $1->isdef = 1; 
				$1->isintermed = 0;
				$$ = $1; }
	| FSYM 	{ $1->isdef = 1; 
				$1->isintermed = 0;
				$$ = $1; }
	
	
;
directive:  ORG exp '\n'  { switchoutofsection($2->x.value,TRUE); }
	| NOFIX '\n' { ToFixup = FALSE; }
	| OPT	optlist '\n' { }
	| OPTEQU optequlist '\n' { }
	| ORG '\n'	{ switchoutofsection(0, TRUE); }
	| ENDSTRUCT '\n'	{ endstruct(1); }
	| END exp '\n'	{ doend($2); }
	| END  '\n'	{ doend(0); }
	| FOPT exp '\n' { setfopt($2); }
	| INCLUDE STRING '\n'	{ setinclude($2); dolist();}
	| IF exp '\n'	{ setif($1,$2); }
	| IF2		{ setifblank($1); }
	| REPT	exp '\n' { setrept($2); }
	| ELSE 	 '\n'	{ setelse(); }
	| ENDIF	 '\n'	{ setendif(); }
	| ELSEIF exp '\n'	{ setelseif($2); }
	| IF STRING ',' STRING '\n' { setifc($1, $2, $4); }
	| PUBLICX publist '\n'  { dolist(); }
  	| EXTERNAL extlist '\n' { dolist(); }
	| MODE SWAPPER '\n' { setmode($2); dolist(); }
    	| ALIGN exp '\n'	{ xalign($2); dolist(); }
	| FAIL exp '\n'	{ fail($2); }
	| IGNORE '\n'   { dolist() ; }
	| LISTON '\n'	{ liston(1); }
	| LISTOFF '\n'  { liston(0); }
	| MACEXIT '\n'	{ macroexit(); }
	| PAGEON '\n' { pageon(1); }
	| PAGEOFF '\n' { pageon(0); }
	| PAGEBREAK '\n' { pagebreak(TRUE); dolist(); }
	| SECTION SYMBOL '\n' { switchsection($2,TRUE,0); }
	| SECTION '\n' { switchsection(0,TRUE,0); }
	| LINES exp '\n' { pagelines($2); }
	| TITLE STRING '\n' { setitle($2); }
	| SUBTTL STRING '\n' { setsubtitle($2); }
	| MSG STRING	{ putmsg($2); }
;
optlist:  OPTTYPE	{ option($1); }
	| EQU		{ }
	| OPTTYPE '=' exp	{ if ($1 == OPTP)
					noption($3,0);
				  else BadOption(); }
	| optlist ',' optlist { }
;
optequlist: OPTEQUTYPE '=' STRING { optequstring($1,$3); }
	| OPTEQUTYPE '=' exp	{ optequexp($1,$3,0); }
	| OPTEQUTYPE '=' NUM '/' NUM %prec NEG { optequexp($1,makexpr($3,1,0,1),makexpr($5,1,0,1)); }
	| EXTERNAL '=' STRING	{ optequstring(OPTEQUXREF, $3); }
	| EXTERNAL '=' exp		{ optequexp(OPTEQUXREF, $3, 0); }
	| LISTON '=' STRING	{ optequstring(OPTEQULIST, $3); }
	| LISTON '=' exp		{ optequexp(OPTEQULIST, $3, 0); }
	| TITLE '=' STRING	{ optequexp(OPTEQUTITLE, $3, 0); }
	| optequlist ',' optequlist %prec NEG { }
;

command:  OPCODE_MMU caches ',' '(' AREG ')' '\n' { gencode ($1, $2, makeoperand($5,TINDIR,0,0,0)); }
	| OPCODE_MMU caches '\n'                  { gencode ($1, $2, 0); }
	| OPCODE_MMU fc ',' exp '\n'         { gencode ($1, $2, makeoperand(-1L,TCONST, $4,0,0)); }
	| OPCODE_MMU fc ',' exp ',' operand '\n' { gencode2($1, $2, makeoperand(-1L,TCONST,$4,0,0) , $6); }
	| OPCODE_MMU fc ',' operand '\n'		{ gencode ($1, $2, $4); }
	| OPCODE_MMU MMUREG ',' operand '\n'	{ gencode ($1, makeoperand($2,TMMUREG,0,0,0), $4); }
	| OPCODE_MMU tightoperand ',' MMUREG '\n'       { gencode ($1, $2, makeoperand($4,TMMUREG,0,0,0)); }
	| OPCODE_MMU fc ',' operand ',' '#' exp '\n' { $7->x.value <<= 10; 
							gencode2($1, $2, $4, makeoperand(-1L,TPTEST, $7,0,0)); }
	| OPCODE_MMU fc ',' operand ',' '#' exp ',' '(' AREG ')' '\n'  { $7->x.value = ($7->x.value <<10) |0x100 | (($10 & 7)<<5); 
									gencode2($1, $2, $4, makeoperand(-1L,TPTEST, $7,0,0)); }
	| OPCODE_MMU '\n' 	    		{ gencode( $1, 0, 0 ); }
	| OPCODE_MMU '(' AREG ')' '\n' 	    	{ gencode( $1, makeoperand($3,TINDIR,0,0,0), 0 ); }
	| opcode '\n' 	    		{ gencode( $1, 0, 0 ); }
 	| opcode operand '\n'                { gencode( $1, 0, $2); }
	| opcode operand ',' operand '{' '#' exp '}' '\n' { gencode2($1, $2, $4, makeoperand(0,TKFACT,$7,0,0)); }
	| opcode operand ',' operand '{' DREG '}' '\n' { gencode2($1, $2, $4, makeoperand( $6, TDREG, 0, 0, 0)); }
	| opcode operand '{' bitfield '}' '\n'	{ gencode( $1, $4, $2); }
	| opcode operand '{' bitfield '}' ',' DREG '\n' { $4->reg |= $7 | ISDESTREG; gencode($1, $4, $2); }
	| opcode operand ',' operand '{' bitfield '}' '\n'  {
								 if ($2->type != TDREG)
								   illop();
								 $6->reg |= ISSOURCEREG;
								 $6->reg |= $2->reg; gencode($1, $6, $4); }
	| opcode operand ',' operand  	'\n' { gencode( $1, $2, $4); }
	| opcode operand ',' operand ',' operand '\n'  { gencode2($1,$2,$4,$6); }
	| opmovemfp fpreglist ',' fpmovmoperand '\n'      { gencode($1, makeoperand($2,TFPREGLIST,0,0,0), $4); }
	| opmovemfp fpmovmoperand ',' fpreglist '\n' { gencode($1,$2,makeoperand($4,TFPREGLIST,0,0,0)); }
	| opmovemfp DREG ',' fpmovmoperand '\n'      { gencode($1, makeoperand($2,TDREG,0,0,0), $4); }
	| opmovemfp fpmovmoperand ',' DREG '\n' { gencode($1,$2,makeoperand($4,TDREG,0,0,0)); }
	| opmovem reglist ',' movmoperand '\n'      { gencode($1, makeoperand($2,TREGLIST,0,0,0), $4); }
	| opmovem movmoperand ',' reglist '\n' { gencode($1,$2,makeoperand($4,TREGLIST,0,0,0)); }
	| opcode DREG ':' DREG ',' DREG	'\n' { gencode($1,makeoperand(($4<<3) + $2,TTBLOP,0,0,0),
					makeoperand($6,TDREG,0,0,0)); }
;

caches:	  DC          	{ $$ = makeoperand(-1L,TCACHE,makexpr(0x40,1,0,1),0,0); }
	| IC           { $$ = makeoperand(-1L,TCACHE,makexpr(0x80,1,0,1),0,0); }
	| DC '/' IC    { $$ = makeoperand(-1L,TCACHE,makexpr(0xc0,1,0,1),0,0); }
	| IC '/' DC    { $$ = makeoperand(-1L,TCACHE,makexpr(0xc0,1,0,1),0,0); }
;
fc:	  exp		{ $1->x.value =($1->x.value & 7)+16; $$ = makeoperand(-1L,TCONST,$1,0,0); }
	| DREG          { $$ = makeoperand(-1L, TCONST,makexpr($1+8,1,0,1),0,0); }
	| AREG		{ if ($1 == SFCREG || $1 == DFCREG)
				$$ = makeoperand(-1L,TCONST,makexpr($1,1,0,1),0,0);
			  else {
				illop();
				$$ = makeoperand(-1L,TCONST,makexpr(0x10,1,0,1),0,0);
			  }; }
;
bitfield:   exp ':' exp  { $$=makeoperand(0,TBITFIELD,$1,0,$3); }
	  | exp ':' DREG { $$=makeoperand(BFDW, TBITFIELD, $1, 0, makexpr($3,1,0,1)); }
	  | DREG ':' exp { $$=makeoperand(BFDO, TBITFIELD, makexpr($1,1,0,1), 0, $3); }
	  | DREG ':' DREG { $$=makeoperand(BFDW | BFDO, TBITFIELD, makexpr($1,1,0,1), 0, makexpr($3,1,0,1)); }
;
opcode:  OPCODE		{ $1->size = 0; $$ = $1;}
	| OPCODE TYPE	{ $1->size = $2; $$ = $1; }
;
opmovem:  OPCODE_MOVEM		{ $1->size = 0; $$ = $1;}
	| OPCODE_MOVEM TYPE	{ $1->size = $2; $$ = $1; }
;
opmovemfp:  OPCODE_FPMOVEM		{ $1->size = 0; $$ = $1;}
	| OPCODE_FPMOVEM TYPE	{ $1->size = $2; $$ = $1; }
;
operand:   '#' fexp	{ $$ = makeoperand(-1L,TCONST,$2,0,0); }
	 | FREG		{ $$ = makeoperand($1,TFREG,0,0,0); }
	 | AREG		{ $$ = makeoperand($1,TAREG,0,0,0); }
	 | DREG		{ $$ = makeoperand($1,TDREG,0,0,0); }
	 | DREG ':' DREG { $$= makeoperand($1,TRQ,makexpr($3,1,0,1),0,0); }
	 | '-' '(' AREG ')' { $$ = makeoperand($3,TPREDEC,0,0,0); }
	 | '(' AREG ')' '+' { $$ = makeoperand($2,TPOSTINC,0,0,0); }
	 | exp 		{ $$ = makeoperand(-1L,TADDR,$1,0,0); }
	 | tightoperand { $$ = $1; }
;
tightoperand: '#' exp	{ $$ = makeoperand(-1L,TCONST,$2,0,0); }
	 | '#' STRING	{ $$ = makeoperand(-1L,TCONST,makexpr(stringtoconst($2),1,0,1),0,0); }
	 | '(' AREG ')'	{ $$ = makeoperand($2,TINDIR,0,0,0); }
 	 | '(' DREG ')'	{ $$ = makeoperand(-1L, TADDRINDIRBASE, 0, makebase($2,TDREG, 0, 0),0); }
         | '(' DREG TYPE ')' { $$ = makeoperand(-1L, TADDRINDIRBASE, 0, makebase($2,TDREG, $3, 0), 0); }
 	 | '(' DREG SCALE ')'	{ $$ = makeoperand(-1L, TADDRINDIRBASE, 0, makebase($2,TDREG, 0, $3),0); }
         | '(' DREG TYPE SCALE ')' { $$ = makeoperand(-1L, TADDRINDIRBASE, 0, makebase($2,TDREG, $3, $4), 0); }
	 | '(' ari ')'	{ $$ = $2; }
	 | '(' armpre ')'  { $$ = $2; }
	 | '(' armpost ')'  { $$ = $2; }
	 | '(' AREG ')' ':' '(' qreg ')' { $$ =makeoperand( $2 + 0x8, TRQI, makexpr($6, 1, 0, 1),0,0); }
	 | '(' DREG ')' ':' '(' qreg ')' { $$ =makeoperand( $2, TRQI, makexpr($6, 1, 0, 1),0,0); }
	 | OPERANDSYM		{ $$ = $1->x.xdata; }
;
movmoperand: exp 		{ $$ = makeoperand(-1L,TADDR,$1,0,0); }
	 | '(' AREG ')'	{ $$ = makeoperand($2,TINDIR,0,0,0); }
	 | '-' '(' AREG ')' { $$ = makeoperand($3,TPREDEC,0,0,0); }
	 | '(' AREG ')' '+' { $$ = makeoperand($2,TPOSTINC,0,0,0); }
	 | '(' ari ')'	{ $$ = $2; }
	 | '(' armpre ')'  { $$ = $2; }
	 | '(' armpost ')'  { $$ = $2; }
;
fpmovmoperand: exp 		{ $$ = makeoperand(-1L,TADDR,$1,0,0); }
	 | AREG		{ $$ = makeoperand($1,TAREG,0,0,0); }
	 | DREG		{ $$ = makeoperand($1,TDREG,0,0,0); }
	 | '(' AREG ')'	{ $$ = makeoperand($2,TINDIR,0,0,0); }
	 | '-' '(' AREG ')' { $$ = makeoperand($3,TPREDEC,0,0,0); }
	 | '(' AREG ')' '+' { $$ = makeoperand($2,TPOSTINC,0,0,0); }
	 | '(' ari ')'	{ $$ = $2; }
	 | '(' armpre ')'  { $$ = $2; }
	 | '(' armpost ')'  { $$ = $2; }
;

qreg:	   AREG			{ $$ = 0x8 + $1; }
	 | DREG			{ $$ = $1; }
;
reglist:   AREG			{ $$ = makebits($1,$1,8); }
	 | DREG			{ $$ = makebits($1,$1,0); }
	 | AREG '-' AREG	{ $$ = makebits($1,$3,8); }
	 | DREG '-' DREG	{ $$ = makebits($1,$3,0); }
	 | MOVEMREGSYM		{ $$ = $1->x.mregs; }
	 | reglist '/' reglist %prec NEG { $$ = $1 | $3; }
;
fpreglist: FREG			{ $$ = makefpbits($1,$1); }
	 | FREG '-' FREG	{ $$ = makefpbits($1,$3); }
	 | fpreglist '/' fpreglist %prec NEG { $$ = $1 | $3; }
;

ari:  	  exp ',' dbase		{ $$ = makeoperand(-1L, TADDRINDIRBASE, $1, $3, 0); }
	| exp ',' AREG          { $$ = makeoperand($3, TADDRINDIRBASE, $1, 0, 0); }
	| exp ',' AREG ',' base { $$ = makeoperand($3, TADDRINDIRBASE, $1, $5, 0); }
	| AREG ',' base		{ $$ = makeoperand($1, TADDRINDIRBASE, 0, $3, 0); }
;
armpost:  '[' exp ']'           { $$ = makeoperand(-1L,TMEMPOST, $2, 0, 0); }
	| '[' exp ',' AREG ']'  { $$ = makeoperand($4,TMEMPOST, $2, 0, 0); }
	| '[' AREG ']'      	{ $$ = makeoperand($2,TMEMPOST, 0, 0, 0); }
	| '[' exp ']' ',' base  { $$ = makeoperand(-1L,TMEMPOST, $2, $5, 0); }
	| '[' exp ']' ',' exp  	{ $$ = makeoperand(-1L,TMEMPOST, $2, 0, $5); }
	| '[' AREG  ']' ',' base { $$ = makeoperand($2,TMEMPOST, 0, $5, 0); }
	| '[' AREG ']' ',' exp { $$ = makeoperand($2,TMEMPOST, 0, 0, $5); }
	| '[' exp ',' AREG  ']' ',' base { $$ = makeoperand($4,TMEMPOST, $2, $7, 0); }
	| '[' exp ',' AREG ']' ',' exp { $$ = makeoperand($4,TMEMPOST, $2, 0, $7); }
	| '[' exp ']' ',' base ',' exp { $$ = makeoperand(-1L,TMEMPOST, $2, $5, $7); }
	| '[' AREG ']' ',' base ',' exp { $$ = makeoperand($2,TMEMPOST, 0, $5, $7); }
	| '[' exp ',' AREG  ']' ',' base ',' exp { $$ = makeoperand($4,TMEMPOST, $2, $7, $9); }
;
armpre:   '[' base ']'		{ $$ = makeoperand(-1L,TMEMPRE, 0, $2, 0); }
	| '[' base ']' ',' exp  { $$ = makeoperand(-1L,TMEMPRE, 0, $2, $5); }
	| '[' exp ',' AREG ',' base ']' { $$ = makeoperand($4,TMEMPRE, $2, $6, 0); }
	| '[' exp ',' base ']'  { $$ = makeoperand(-1L,TMEMPRE, $2, $4, 0); }
	| '[' exp ',' base ']' ',' exp      { $$ = makeoperand(-1L,TMEMPRE, $2, $4, $7); }
	| '[' AREG ',' base ']' ',' exp     { $$ = makeoperand($2,TMEMPRE, 0, $4, $7); }
	| '[' AREG ',' base ']'     { $$ = makeoperand($2,TMEMPRE, 0, $4, 0); }
	| '[' exp ',' AREG ',' base ']' ',' exp { $$ = makeoperand($4,TMEMPRE, $2, $6, $9); }
;
base:	  DREG scale		{ $$ = makebase($1,TDREG, 0, $2); }
	| DREG TYPE scale	{ $$ = makebase($1,TDREG, $2, $3); }
	| AREG scale             { $$ = makebase($1,TAREG, 0, $2); }
	| AREG TYPE scale        { $$ = makebase($1,TAREG, $2, $3); }
;
dbase:	  DREG scale		{ $$ = makebase($1,TDREG, 0, $2); }
	| DREG TYPE scale	{ $$ = makebase($1,TDREG, $2, $3); }
;
scale:	/* empty */             { $$ = 0; }
	| SCALE			{ $$ = $1; }
;
	

exp:      NUM                { $$ = makexpr($1,1,0,1);       }
	| '*'		     { EXPRESSION *temp= makexpr(currentorg(),1,0,1); 
					temp->section = sectionnum;
					temp->rel = TRUE;
					$$ = temp;  }
        | SYMBOL                { $$ = $1;              }
	| SIZEOF '(' exp ')'	{ $$ = sizeofexpr($3); }
	| SIZEOF '(' STRUCTSYM ')'	{ $$ = sizeofexpr($3); }
	| exp LOGOR  exp     { $$ = logor($1, $3); }
	| exp LOGAND exp     { $$ = logand($1, $3); }
        | exp EQ exp        { $$ = eqexp($1,$3);                    }
        | exp NE exp        { $$ = neexp($1,$3);                    }
        | STRING EQ STRING        { $$ = eqstring($1,$3);                    }
        | STRING NE STRING        { $$ = nestring($1,$3);                    }
        | exp '>' exp        { $$ = gtexp($1,$3);                    }
        | exp '<' exp        { $$ = ltexp($1,$3);                    }
        | exp GE exp        { $$ = geexp($1,$3);                    }
        | exp LE exp        { $$ = leexp($1,$3);                    }
        | STRING '>' STRING        { $$ = gtstring($1,$3);                    }
        | STRING '<' STRING        { $$ = ltstring($1,$3);                    }
        | STRING GE STRING        { $$ = gestring($1,$3);                    }
        | STRING LE STRING        { $$ = lestring($1,$3);                    }
        | exp '+' exp        { $$ = addexp($1,$3);                    }
        | exp '-' exp        { $$ = subexp($1, $3);                    }
        | exp '*' exp        { $$ = mulexp($1, $3);                    }
        | exp SCALE          { $$ = scaleexp($1, $2);                    }
        | exp '/' exp        { $$ = divexp($1, $3);                    }
        | exp '%' exp        { $$ = modexp($1, $3);                    }
        | '-' exp  %prec NEG { $$ = negexp($2, 0);                        }
	| exp '|' exp	     { $$ = orexp($1, $3); }
	| exp '^' exp	     { $$ = xorexp($1, $3); }
	| exp '&' exp	     { $$ = andexp($1, $3); }
	| exp SHLEFT exp	     { $$ = shlexp($1, $3); }
	| exp SHRIGHT exp	     { $$ = shrexp($1, $3); }
	| '+' exp  %prec NEG { $$ = $2; };
	| '~' exp  %prec NEG { $$ = bitcomp($2, 0); }
	| '!' exp  %prec NEG { $$ = logcomp($2, 0); }
	| ':' exp  %prec NEG { $$ = toabs($2, 0); }
        | '(' exp ')'        { $$ = $2;                         }
	| SWAPPER '(' exp ')' { $$ = swapper($1, $3); }
        | '(' exp ')' TYPE   {  if ($4 == TBYTE)
				  Error("Invalid type on expression");
				else $2->size = $4;
				$$ = $2; }
;
fexp:	  FNUM  		{ $$ = makefpexp($1,1,0,1,1); }
	| FNUMSPEC              { $$ = makefpexp($1,1,0,1,0); }
	| FSYM                  { $$ = $1; }
        | '-' fexp  %prec NEG { $$ = negfpexp($2, 0); } 
;                      
/* End of grammar */
%%