#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <dos.h>
#include "cmdline.h"
#include "umem.h"
#include "data.h"
#include "section.h"
#include "public.h"
#include "extern.h"
#include "linker.h"
#include "map.h"
#include "lexpr.h"
#include "partit.h"
#include "local.h"

#define VMVER 001
extern LIST *objlist;
extern BOOL prm_autodepends;
extern BOOL prm_debug;
extern int usedfloat;
extern LIST *sectionlist;
extern LIST *unresolvedexterns;
extern BOOL prm_relocatable;
extern HASHREC **publichash, **localhash;
extern LDESCRIPTION *partitions;
extern uint maus;
extern uint bitspermau;
extern char bigendchar;
extern unsigned long maxconfig;
extern LIST *linelist;
extern PUBLIC *entrypoint;
extern char *prm_specify;

char formext[]=".BLU";
char specname[200];
short trapvect = 0;

static void link_header(FILE *out, char *name)
{
	fprintf(out,"Bluew"); /* ID */
	fputc(0,out); /* ID trailer */
	fputc(0,out); /* M family */
	fputc(0,out); /* CPU ID */
}
	
static long blankout(FILE *file, long start, long end)
{
	long i;
	for(i=start; i < end; i++)
		fputc(0,file);
	return 0;
}
static void putsection(FILE *file, SECTION *sect)
{

	long size = sect->abssize;
  BYTE *buf = PtrToEMSMem(sect->buffer,0);
	fwrite(buf,1,size,file);
}
static void putdata(FILE *file)
{
	short traptab[256],u16;
	int i;
	if (!partitions) {
  	LIST *q = sectionlist;
		while (q) {
			SECTION *p = q->data;
			putsection(file,p);
			q = q->link;
		}
	}
	else {
		LDESCRIPTION *p = partitions;
		int i;
		int foundtraps = 0;
		long sz = 0;
		PUBLIC *pu = GetPublic("_trapdefault");
		if (pu) 
			trapvect = pu->sect->base + pu->sect->parent->absbase +pu->offset;
		else {
			trapvect = 0;
			Error("No default trap vector");
		}
		
		for (i=0;i<256; i++)
			traptab[i] = trapvect;
		i = 0;
		while (p&&!foundtraps) {
			if (p->type == TY_PARTITION) {
				LDESCRIPTION *o = p->downlink;
				while (o) {
					if (o->type == TY_OVERLAY) {
						LDESCRIPTION *r = o->downlink;
						if (!strcmp(o->name,"TRAPS")) {
							LIST *l = sectionlist;
							SECTION *found = 0;
							while (l) {
								SECTION *q = l->data;
								if (!strcmp(q->name,r->name)) {
									found = q;
									break;
								}
								l = l->link;
							}
							if (found) {
								unsigned short u16 = found->abssize/3;
								if (found->abssize %3)
									fatal("Invalid trap table");
								for (i=0; i < found->abssize; i+=3) {
									BYTE *p = PtrToEMSMem(found->buffer,i);
									int vecnum = p[0];
									short val = p[1] + 256 * p[2];
									traptab[vecnum] = val;
								}
								goto ok;
							}
							goto ok;
						}
					}
					o = o->sidelink;
				}
			}
			p = p->sidelink;
		}
ok:
		/* Write the trap tab */
		fwrite(traptab,256*2,1,file);
		fputc(0,file); /* Extra vectors */
		fputc(0,file);
		fputc(0,file);
		fputc(0,file);
		fputc(0,file);
		fputc(0,file);
		fputc(0,file); /* Timer granularity */
		fputc(0,file);
		/* Now comes the register image */
		if (!entrypoint) {
			Error("No entry point");
			u16 = 0;
		}
		else
			u16 = entrypoint->offset + entrypoint->sect->base + entrypoint->sect->parent->absbase;
		/* ip */
		fputc(u16&255,file);
		fputc(u16>>8,file);
		fputc(0xfc,file);    /* UB AND UP */
		fputc(0xff,file);
		fputc(0xfc,file);
		fputc(0xff,file);
		fputc(0xff,file);	  /* OP */
		fputc(0xff,file);
		fputc(0xff,file);
		fputc(0xff,file);
		fputc(0xff,file);   /* CP */
		fputc(0xff,file);
		fputc(0xff,file);
		fputc(0xff,file);
		fputc(0,file);	/* RR */
		fputc(0,file);
		fputc(0,file);
		fputc(0,file);
		for (i=0; i < 256*4; i++)	/* Ostack */
			fputc(0,file);
		for (i=0; i < 512*2; i++)	/* Cstack */
			fputc(0,file);

		while (p) {
			if (p->type == TY_PARTITION) {
				LDESCRIPTION *o = p->downlink;
				while (o) {
					if (o->type == TY_OVERLAY) {
						LDESCRIPTION *r = o->downlink;
						long base = 0;
						if (strcmp(o->name,"TRAPS")) {
							while (r) {
								if (r->type == TY_REGION) {
									LIST *l = sectionlist;
									SECTION *found = 0;
									while (l) {
										SECTION *q = l->data;
										if (!strcmp(q->name,r->name)) {
											found = q;
											break;
										}
										l = l->link;
									}
									if (found) {
										if (base) {
											blankout(file,base, found->absbase);
											sz += found->absbase - base;
										}
										putsection(file,found);
										sz += found->abssize;
										base = found->absbase + found->abssize;
									}
									else
										if (r->maxsize) {
											if (base) {
												blankout(file,base,r->address);
												sz += r->address - base;
											}
											sz += r->size;
											blankout(file, 0, r->maxsize);
											base = r->address + r->size;
										}
								}
								r = r->sidelink;
							}
						}
					}
					o = o->sidelink;
				}
			}
			p = p->sidelink;
		}
		/* sz has image size now */
		/* DOS limits the program size to less than 64K.  Pad the image out
			 now */
		for (i=0; i < 16; i++)
			fputc(0,file);
			
	}
}
void formatinit(char *name)
{
	if (!prm_specify) {
		char *p;
		strcpy(specname,name);
		p = strrchr(specname,'\\');
		if (!p)
			p = strrchr(specname,':');
		if (!p)
			p = specname;
		else
			p++;
		strcpy(p,"BLUEW.SPC");
		prm_specify = specname;
	}
	printf("BLUEW format linker\n");
}
void format_out(FILE *file, char*name)
{
	link_header(file, name);
	putdata(file);
}