#include <stdio.h>
#include <memory.h>
#include <string.h>
#include <ctype.h>
#include "cmdline.h"
#include "umem.h"
#include "module.h"
#include "errors.h"

#define OBJECT_BUFFER_SIZE 256

extern BOOL prm_case_sensitive;

long modnumber = 0;
long liboffset = 0;
HASHREC **publichash;
BOOL docopy = TRUE;

MODULE *modules=0, *curmod;
int procrevision = 0;

static BYTE objectbuffer[OBJECT_BUFFER_SIZE]; /* Record buffer */
static long offset;				/* Current offset in file */
static int left=0;
static BYTE *bptr;
static FILE *curfile;
static BOOL endofmodule;
static BYTE putbackbuf;

void ReadHeader(void);
void CheckSum(void);
void ModEnd(void);
void SetMAUs(void);
void Assign(void);
void DateTime(void);
void Comment(void);

void EnumeratedData(void);
void ReadFixup(void);
void PublicDefinitions(void);
void ExternDefinitions(void);
void SectionAlignment(void);
void SectionStart(void);
void SectionDefinitions(void);
void PublicSetAttribs(void);
/* List of defined MUFOM records.  Bit defs:
 *  TE_REPORT: Generate a warning message for this record 
 *  TE_IGNORE: Ignore the record
 */
static TYPEXEC main_exec_list[] = {
	{ "AD",TE_REPORT - TE_REPORT, SetMAUs },
	{ "AS",TE_REPORT - TE_REPORT, Assign },
	{ "AT",TE_REPORT - TE_REPORT, PublicSetAttribs },
	{ "CO",TE_REPORT - TE_REPORT, Comment },
	{ "CS",TE_REPORT - TE_REPORT, CheckSum },
	{ "DT",TE_REPORT - TE_REPORT, DateTime },
	{ "LD",TE_REPORT - TE_REPORT, EnumeratedData },
	{ "LR",TE_REPORT - TE_REPORT, ReadFixup },
	{ "MB",TE_REPORT - TE_REPORT, ReadHeader },
	{ "ME",TE_REPORT - TE_REPORT, ModEnd },
	{ "NI",TE_REPORT - TE_REPORT, PublicDefinitions },
	{ "NN",TE_REPORT - TE_REPORT, ExternDefinitions },
	{ "NX",TE_REPORT - TE_REPORT, ExternDefinitions },
	{ "SA",TE_REPORT - TE_REPORT, SectionAlignment },
	{ "SB",TE_REPORT - TE_REPORT, SectionStart },
	{ "ST",TE_REPORT - TE_REPORT, SectionDefinitions },
	{ "\0\0", 0, 0 }
} ;
long theoffset (void)
{
	return(offset-left);
}
/*
 * Quit with a message if a bad record is encountered
 */
void BadObjectFile(void)
{
 	fatal("Bad Object module %s near file offset 0x%x",
		(curmod)->name,theoffset());
}
void CheckForPeriod(void)
{
  if (ReadChar() != '.')
		BadObjectFile();
}
BOOL CheckForComma(BOOL musthave)
{
	BYTE rv = ReadChar();
	if (rv == ',')
		return(TRUE);
	if (musthave || rv != '.')
		BadObjectFile();
	return(FALSE);
}
void WadeToPeriod(void)
{
	while (ReadChar() != '.');
}
/*
 * Perform  function
 */
static void ReadHeader(void)
{
	BYTE rv;
	char buffer[60];
	if ((rv = ReadChar()) == '6')
		if ((rv = ReadChar()) == '8')
			if ((rv = ReadChar()) == '0') {
				rv = ReadChar() - '0';
				if (rv > procrevision)
					procrevision = rv;
			}
	while ((rv) != '.' && rv != ',') 
		rv = ReadChar();
	if (rv == ',') {
  	ReadString(buffer,60);
		(curmod)->name = AllocateMemory(strlen(buffer)+1);
		strcpy((curmod)->name, buffer);
		CheckForPeriod();
	}
}
static void ModEnd(void)
{
	WadeToPeriod();
	endofmodule = TRUE;
}
static void Comment(void)
{
	WadeToPeriod();
}
static void CheckSum(void)
{
	WadeToPeriod();
}
static void SetMAUs(void)
{
	WadeToPeriod();
}
static void Assign(void)
{
	WadeToPeriod();
}
static void DateTime(void)
{
	WadeToPeriod();
}
void EnumeratedData(void)
{
	WadeToPeriod();
}
void ReadFixup(void)
{
	WadeToPeriod();
}
void PublicDefinitions(void)
{
	char buf[NAMEMAX+1];

	ReadNumber(0);
	if (CheckForComma(FALSE)) {
		PUBLIC *p = AllocateMemory(sizeof(PUBLIC)), *q;
		ReadString(buf,NAMEMAX+1);
		p->name = AllocateMemory(strlen(buf)+1);
		strcpy(p->name, buf);
		p->mod = curmod;
		p->link = 0;
		if ((q = AddHash(publichash,p)) != 0) {
			Error("Public %s defined in both %s and %s", p->name, q->mod->name, p->mod->name);
			DeallocateMemory(p->name);
			DeallocateMemory(p);
		}
		
		CheckForPeriod();
	}
}
void ExternDefinitions(void)
{
	ReadNumber(0);
	if (CheckForComma(FALSE)) {
		ReadString(0,0);
		CheckForPeriod();
	}
}
void SectionAlignment(void)
{
	WadeToPeriod();
}
void SectionStart(void)
{
	WadeToPeriod();
}
void SectionDefinitions(void)
{
	WadeToPeriod();
}
void PublicSetAttribs(void)
{
	WadeToPeriod();
}
/*
 * Read data into the objectbuffer
 */
void ReadFile(void)
{
	if (!feof(curfile)) {
		left = fread(objectbuffer,1,OBJECT_BUFFER_SIZE,curfile);
		offset += left;
		if (left < 0)
			fatal("File read error in module %s",(curmod)->name);
		bptr = objectbuffer;
	}
}
/*
 * Read a char & do checksumming
 */
BYTE ReadCharNOCS(void)
{
	BYTE rv;
	if (putbackbuf) {
		rv = putbackbuf;
		putbackbuf = 0;
		return(rv);
	}
	while (TRUE) {
		if (!left) {
			ReadFile();
			if (!left) 
				fatal("missing modend statement in module %s", (curmod)->name);
		}
		left--;
		liboffset++;
		rv = *bptr++;
		if (docopy) {
			char *q = (char *)PtrToEMSMem((curmod)->data,(curmod)->len++);
			*q = rv;
		}
		if (rv >31)
			break;
	}
	return(rv);
}
BYTE ReadChar(void)
{
	BYTE rv = ReadCharNOCS();
	return(rv);
}
void putback(BYTE ch)
{
	putbackbuf = ch;
}
long ReadNumber(uint digits)
{
	int i;
	long rv = 0;
	if (!digits)
		digits = 200;
	for (i=0; i < digits; i++) {
		BYTE ch = ReadChar();
		if (!isxdigit(ch)) {
			putback(ch);
			break;
		}
		rv *= 16;
		ch -= '0';
		if (ch > 9)
			ch -= 7;
		rv += ch;
	}
	return(rv);
}
void ReadString(char *buf,int len)
{
	int slen = (int)(ReadNumber(2)),i;
	int rlen = slen > len-1 ? len-1 : slen;
	for (i=0; i<rlen; i++)
		if (prm_case_sensitive)
			buf[i] = ReadChar();
		else
			buf[i] = toupper(ReadChar());
	if (rlen >= 0)
		buf[rlen] = 0;
	else
		rlen = 0;
	for (i=rlen; i < slen; i++)
		ReadChar();
}
	
	
/*  
 * Read and execute an object record
 */
static uint ReadObjectRecord(void)
{
	uint command;
	TYPEXEC *p = main_exec_list;
	command = ReadChar() + (ReadChar() << 8);

  /* Search the dispatch table */

  while (p->select[0]) {
    if (*((uint *)p->select) == command) {
			uint temp = p->flags;
      if (temp & TE_REPORT)
         printf("Record type %c%c ignored at offset 0x%lx in module %s\n",p->select[0], p->select[1],theoffset()-2 , (curmod)->name);
      if (temp& TE_ERROR)
        return(MODERR);
			if ((temp & TE_IGNORE) || !p->run)	/* Undefined functions are ignored, better have the TE_REPORT bit set!!! */
			  return(MODIGNORE);

      /* Dispatch the function */
      p->run();
      break;
    }
		p++;
  }
  /* Return an error if not found */
  if (p->select[0] == 0)
    return(MODERR);

  /* Return the record type if was found */
  return(command);
}
void SetForRead(FILE *infile)
{
	offset = 0;
	curfile = infile;
	endofmodule = FALSE;
}
void UnsetForRead(void)
{
	liboffset+=2;
	left-=2;
	bptr+=2;
}	
/*
 * Read in a module
 */

uint ReadModule(FILE *infile,BOOL sof)
{
  uint temp;
	MODULE *mod,**m=&modules;
  offset = 0;
	if (sof)
		left = 0;
	curfile = infile;
	endofmodule = FALSE;
	mod = AllocateMemory(sizeof(MODULE));
	curmod = mod;
	mod->link = 0;
	mod->name = 0;
	mod->data = AllocateEMSMemory(MAX_OBJECT_SIZE,0);
	mod->len = 0;
	mod->offset = 0;

  while (!endofmodule) {
    switch(temp = ReadObjectRecord()) {
      case MODERR:
				BadObjectFile();
      case MODQUIT:
			  endofmodule = TRUE;
				break;
	  }
	}
	modnumber++;
	while (*m)
	m = *m;
	*m = mod;
	modnumber++;
	ResizeEMSMemory(mod->data, mod->len);
  return(temp);
}