#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "cmdline.h"
#include "umem.h"
#include "module.h"
#include "data.h"
#include "section.h"
#include "output.h"

#define VERSION 131

extern LIST *sectionlist;

/* Command line parameters */
BOOL prm_mode = PRM_NONE;
int prm_phipos = 0;
int prm_motoaddress =2 ;
int prm_useoffset = TRUE;
int prm_successive = FALSE;

/* Global varieables */
uint modnumber=0;										/* module number, increments sequentially */
char *objfile = 0;									/* obj file name */
char *outfile = 0;									/* output file name */
char *overlay = 0;
char *usage_text = "[/b??/m/ooutput/p/s/O] /coverlay filename";

static char *mainname = "MAIN";

void BinarySetup(char select, char *string);
void OutputSetup(char select, char *string);
void OverlaySetup(char select, char *string);
void PhiSetup(char select, char *string);
void BoolSetup(char select, char *string);

ARGLIST ArgList[] = {
	{ 'b', ARG_CONCATSTRING, BinarySetup },
  { 'c', ARG_CONCATSTRING,OverlaySetup },
  { 'o', ARG_CONCATSTRING, OutputSetup },
  { 'p', ARG_CONCATSTRING, PhiSetup },
  { 's', ARG_CONCATSTRING, BoolSetup },
  { 'O', ARG_BOOL, BoolSetup },
  { 0, 0, 0 }
} ;
void BoolSetup(char select, char *string)
{
	if (select == 's')
		prm_successive = TRUE;
	else
  	prm_useoffset = FALSE;
}
void BinarySetup(char select, char *string)
{
	while (*string) {
		switch(*string) {
			case 'm':
				if (*(string+1) == 'c') {
					prm_mode = PRM_MOTOROLA;
					string++;
					if (*(string+1) != 0) {
						if (*(string+1) > '0' && (*(string+1) < '4')) {
					  	prm_motoaddress= *(string+1) - '0';
							string++;
						}
					}
				}
				else
					prm_mode = PRM_MONK;
				break;
			case 'i':
				prm_mode = PRM_INTEL;
				break;
		}
		string++;
	} 
}
/*
 * Set up for object file name
 */
static void OutputSetup(char select, char *string)
{
	if (outfile)
		DeallocateMemory(outfile);
	outfile = AllocateMemory(strlen(string)+1);
	strcpy(outfile, string);
}
static void OverlaySetup(char select, char *string)
{
	if (overlay)
		DeallocateMemory(overlay);
	overlay = AllocateMemory(strlen(string)+1);
	strcpy(overlay, string);
}
static void PhiSetup(char select, char *string)
{
  prm_phipos = atoi(string)+1;
}
/*
 * Main routine
 *   Read command line
 *   Make obj and MAP filenames if not already extant
 *   Pass 1 init
 *   Pass 1
 *   Pass 1 rundown
 *   pass 2 init
 *   Pass 2
 *   Pass 2 rundown
 */
int main(int argc, char *argv[])
{
	BOOL tostart = 0;
	long startadr,totalsize = 0;
	FILE *file;
	LIST *p;
	SECTION *q;
	char *s;
  char buffer[100];
	banner(VMSG("DL "));

	MemoryInit(0xffff);
  /* Scan command line for switches */
  if (!parse_args(&argc,argv,TRUE) || (argc != 2))
    usage(argv[0]);

	if (!overlay)
		overlay = mainname;

	strcpy(buffer,argv[1]);
	AddExt(buffer,".abs");
	objfile = AllocateMemory(strlen(buffer)+1);
	strcpy(objfile, buffer);
	if (!outfile) {
		StripExt(buffer);
		if (prm_phipos)
			AddExt(buffer,".pmg");
		else
			if (prm_mode == PRM_MONK)
				AddExt(buffer,".mnk");
			else
				if (prm_mode == PRM_NONE)
					AddExt(buffer,".bin");
				else
					AddExt(buffer,".hex");
		outfile = AllocateMemory(strlen(buffer)+1);
		strcpy(outfile, buffer);
	}

	
	SectionTableInit();
  if ((file = fopen(objfile,"rb")) == 0)
		fatal("Missing input module %s",objfile);
	ReadModule(file,objfile,SCAN,TRUE);
	fclose(file);

	if (!(file = fopen(outfile,"wb")))
		fatal("Can't open output file");
	if (prm_phipos) {
		OutputInit(objfile,file);
	}
	else switch (prm_mode) {
		case PRM_INTEL:
			IntelInit(objfile,file);
			break;
		case PRM_MOTOROLA:
			MotorolaInit(objfile,file);
			break;
		case PRM_NONE:
		case PRM_MONK:
			OutputInit(objfile,file);
			break;
	}
	p = sectionlist;
	s = overlay;
	if (prm_phipos)
		OutputPhiHeader(0L,0L,file);
	while (TRUE) {
		char buffer[100];
		int i = 0;
		if (!*s)
			break;
		while (*s && *s != ';')
			buffer[i++] = *s++;
		buffer[i] = 0;
		if ((*s) == ';')
			s++;
		p = sectionlist;
		while (p) {
			q = p->data;
			if (!strcmp(q->name,buffer))
				break;
			p = p->link;
		}
		if (!p)
			fatal("Overlay %s not found in input file %s", buffer,objfile);
		printf("%s: %06lX %04lX\n",buffer, q->base, q->size);
		if (prm_phipos) {
			if (!tostart) {
				tostart = TRUE;
				startadr = q->base;
			}
			OutputData(q, buffer, file);
			totalsize += q->size;
		}
		else switch (prm_mode) {
			case PRM_INTEL:
				OutputIntelHex(q,buffer,file);
				break;
			case PRM_MOTOROLA:
				OutputMotorolaHex(q,buffer,file);
				break;
			case PRM_NONE:
			case PRM_MONK:
				OutputData(q, overlay, file);
				break;
		}
	}
	if (prm_phipos) {
		OutputPhiHeader(totalsize,startadr,file);
		OutputRundown(file);
	}
	else switch (prm_mode) {
		case PRM_INTEL:
			IntelRundown(file);
			break;
		case PRM_MOTOROLA:
			MotorolaRundown(file);
			break;
		case PRM_NONE:
		case PRM_MONK:
			OutputRundown(file);
			break;
	}
	fclose(file);

	SectionTableRundown();

  return(0);
}