#include <stdio.h>
#include <memory.h>
#include <string.h>
#include <ctype.h>
#include "cmdline.h"
#include "umem.h"
#include "module.h"
#include "data.h"
#include "section.h"

extern SECTION **sectiontable;

long entrypoint;
BOOL hasentry = FALSE;

static SECTION *SectionPtr;
static long base_address;
static BYTE *memptr;
static int count;

static void outbyte(char ch)
{
	*memptr++ = ch;
	if (!--count) {
		base_address += MAX_EMS_READWRITE;
		memptr = PtrToEMSMem(SectionPtr->parent->buffer, base_address);
		count = MAX_EMS_READWRITE;
	}
}
void SectionStart(int mode)
{
	int id;
	id = ReadNumber(0);
	CheckForPeriod();
	SectionPtr = sectiontable[id];
	base_address = 0;
	memptr = PtrToEMSMem(SectionPtr->parent->buffer,base_address);
	count = MAX_EMS_READWRITE;
}
void SetEntryPoint(void)
{
	if (CheckForComma(TRUE)) {
		hasentry = TRUE;
		entrypoint = ReadNumber(0);
		CheckForPeriod();
	}
}
void EnumeratedData(int mode)
{
	BYTE ch = ReadChar();
	while (ch != '.' && ch > 31) {
		int data;
		putback(ch);
		data = ReadNumber(2);
		outbyte(data);
		ch = ReadChar();
	}
	if (ch < 31)
		BadObjectFile();
}
void ReadFixup(int mode)
{
	fatal("Fixup located in object file, may not be downloaded");
}