//    Class for drawing X-Y dependences on screen.

#ifndef __GRAF_H_
#define __GRAF_H_

#include "drawtool.h"
#include "khbgi.h"

/*    There are few types of graphics. Line graf could be used for
    drawing splines (no markers). Marker graf looks nice for the set
    of few (up to 20 - 40) points. Combined graf is the combination of
    line and marker grafs (data with spline). Bar and 3 dimensional bar
    presents data as bars drawn from 0(Y) to y(Y). Stacked bar graf
    draws 3-d bars not from zero, but from the top of previous bar.
*/

enum { NO_GRAF, LINE_GRAF, MARKER_GRAF, COMBINED_GRAF, BAR_GRAF,
       BAR_3D_GRAF, STACKED_BAR_GRAF };

enum { NONE, BAR, CIRCLE, TRIANGLE, STAR5, STAR6, CROSS, X_CROSS,
       DIAMOND, TRIANGLE2, BAR2, CIRCLE2 };


struct Graf
    {
	int marker_type;
	int line_type;
	int attr;           // Color
	int bak;            // Background
	int size;           // Size of marker
	int fill;           // Fill pattern for bar graf family. In 1.x
			    // version we use BGI - not VBGI graphics.

	Graf(int m = 0, int l = 1, int a = 0, int b = 15, int s = 4, int f=1)
	    { marker_type = m; line_type = l;  attr = a; bak = b; size = s;
	      fill = f; }
	void set_type(int m, int l, int a, int b, int s, int f)
	    { marker_type = m; line_type = l; attr = a; bak = b; size = s;
	      fill = f; }
// X and Y contains integer (screen) coordinates, which was recalculated
// from double data. Data are ordered on X axe.
	void show(int* x, int* y, int number_of_points,
	    int x_left_of_graf, int y_left_of_graf, int num_in_container = 0);
	void set_type(int m_t, int l_t)
	    { line_type = l_t; marker_type = m_t; }
	void set_param(int a, int b, int s, int f)
	    { attr = a; bak = b; size = s; fill = f; }
	void show_marker(int type, loc pos, int color, int size = 4);
    };

#endif __GRAF_H_