////////////////////////////////////////////////////////////////////////////
//                                                                        //
//            File: Snap.cpp                                              //
//            started on: 30/8/93                                         //
//                                                                        //
////////////////////////////////////////////////////////////////////////////
//                                                                        //
//  Uses Shift-Tab hotkey to save screen and append it to snap.dat        //
//    Uses KBD class to hook hotkey, and DOSFREE to save data in file.    //
//                                                                        //
////////////////////////////////////////////////////////////////////////////
//                                                                        //
//                    by Ofer Laor (AKA LeucroTTA)                        //
//                                                                        //
////////////////////////////////////////////////////////////////////////////

#include <io.h>;       // open.
#include <fcntl.h>;    // O_XXXX.
#include <sys\stat.h>; // S_IXXX

#include "dosfree.h";  // DOSFREE.
#include "kbd.h";      // KBD.


// this class is my application.
class SNAP : public KBD, public DOSFREE {

      char screen[2050];                // screen temp buffer.
      virtual void hotkey(void);        // saves data in screen.
      virtual void AppFunc(void);       // save screen buffer in file.

public:
       SNAP(): KBD(KB_TAB, KBS_SHIFT) {};  // hook hotkey into SHIFT-TAB.

};


// hotkey saves screen and calls AppFunc indirectly.
void SNAP::hotkey(void)
{
    char far *pScreen= (char far *)0xb8000000L; // pointer to screen (non MDA).

    int len= 0;

    // save screen.
    for (int y= 0; y< 25; y++) {
        for (int x= 0; x< 80; x++)
            screen[len++]= pScreen[(x*2)+ (y*160)]; // skip the char attributes (save every 2nd char).

        // add CR,LF on the end of every line (so that editors can edit data easy).
        screen[len++]= 0xd; // CR.
        screen[len++]= 0xa; // LF.
    }

    // run AppFunc when dos is free.
    Go();
}

// this func. runs whenever dos is free. Save data into file.
void SNAP::AppFunc(void)
{
    const char datafile[]= "snap.dat";

    // create file if it doesn't exist.
    int handle= open(datafile, O_EXCL| O_CREAT| O_RDWR| O_BINARY, S_IWRITE| S_IREAD);
    close(handle);

    // open it in append. (There's probably a simpler way to do this but I
    // didn't wanna spend too much time on this foolery.
    handle= open(datafile, O_APPEND| O_BINARY| O_RDWR, S_IWRITE| S_IREAD);

    // could not open file for some reason. BEEP....
    if (handle== -1) {
       // notice I used TTY BIOS func. to beep. DO NOT USE DOS TTY (int21h
       // func. < 0xc!!!).
       _AH= 0xe;
       _AL= '\a';
       _BX= 0;
       asm int 10h

       return;
    }

    // write file, and close it.
    write(handle, screen, sizeof(screen));
    close(handle);
}

// activate SNAP. Stay resident if not already resident.
int main()
{
    if (ISC::is_TSR("SNAP(:-D"))
       return 1;

    // activate my app.
    new SNAP;

    // stay resident (return 0 to dos).
    return ISC::TSR(0);
}
