//////////////////////////////////////////////////////
// File: MatDemo3.cpp
// Purpose: Demonstrates use of matrix template class
// Author: Somnath Kundu

#include "matrix.h"

#ifndef _NO_NAMESPACE
using namespace std;
using namespace math;
#define STD std
#else
#define STD
#endif

#ifndef _NO_EXCEPTION
#  define TRYBEGIN   try {
#  define CATCHERROR } catch (const STD::exception e) { \
                     cout << "Error: " << e.what() << endl; }
#else
#  define TRYBEGIN
#  define CATCHERROR
#endif

typedef matrix<double> Matrix;

int main ()
{
  Matrix m(3,3);

  TRYBEGIN
   cout << "Enter a matrix of (3X3) order:\n";
   cin >> m;
   cout << "This is a ";

   if (m.IsSquare())
      cout << "Square ";

   if (m.IsSingular())
      cout << "Singular ";

   if (m.IsDiagonal())
      cout << "Diagonal ";

   if (m.IsUnit())
      cout << "Unit ";

   if (m.IsNull())
      cout << "Null ";

   if (m.IsSymmetric())
      cout << "Symmetric ";

   if (m.IsSkewSymmetric())
      cout << "SkewSymmetric ";

   if (m.IsUpperTiangular())
      cout << "UpperTiangular ";

   if (m.IsLowerTiangular())
      cout << "LowerTiangular ";

   if (m.IsScalar())
      cout << "Scaler ";
  CATCHERROR
  cout << "matrix.\n";

   return 0;
}
