
/*
	STRING.HPP
	Created 1995 by Dejvid Zaninovic
*/

#ifndef STRING_HPP
#define STRING_HPP

#include <string.h>
#include "c.hpp"

char *strror (char *s);              		// rotate string right
char *strrol (char *s);                     // rotate string left
char *strshr (char *s);                     // shift string right
char *strshl (char *s);                     // shift string left
boolean isblank (const char *s);            // is string blank ?
char *strchg (char *s, const char *o, const char *n); // search and replace
char *stralltrim (char *s);					// trim blanks
char *strrtrim (char *s);					// trim trailing blanks
char *strltrim (char *s);					// trim leading blanks
char *strrem (char *s);						// remove remark
char *skipb (const char *s);				// skip blank characters
boolean strwild (const char *s, const char *w); // wildcard equality
word chksum (const char *s);				// 16 bit checksum of string
boolean strin (char c, const char *s);      // is char c in string s
char *strsfrag (const char *s, const char *f); // get fragment
byte *memror (byte *m, word len);      		// rotate memory right
byte *memrol (byte *m, word len);           // rotate memory left
byte *memshr (byte *m, word len);           // shift memory right
byte *memshl (byte *m, word len);           // shift memory left

#endif
