
/*
	SCREEN.CPP
	Created 1994 by Dejvid Zaninovic
*/

#include <conio.h>
#include <alloc.h>
#include <dos.h>
#include "c.hpp"
#include "screen.hpp"
#include "misc.hpp"

text_info ti;           // text mode info
void *scrbuf;           // saved screen buffer
unsigned cursor0;       // saved cursor
unsigned x0, y0;        // saved cursor position

char bsingle[] = "Ŀ";		// box single
char bdouble[] = "ͻͼ";		// box double

int c_fill	= C (LIGHTGRAY, BLACK);		// fill
int c_box 	= C (LIGHTGRAY, BLACK);		// box
int c_item  = C (LIGHTGRAY, BLACK);		// items
int c_sitem = C (BLACK, LIGHTGRAY);		// selected item


/*
	void scr_init()

    - save info about screen to text_info
    - save screen to buffer *scrbuf, if there is not enough memory execute
	  error (E_NOMEM)
    - save cursor shape to cursor0
    - save cursor position to x0 and y0
    - clear screen
*/

void scr_init()
{
	gettextinfo (&ti);
	scrbuf = malloc (ti.screenwidth * 2 * ti.screenheight);
	if (scrbuf == NULL)
		error (E_NOMEM);
	gettext (1, 1, ti.screenwidth, ti.screenheight, scrbuf);
	cursor0 = getcursorshape();
	x0 = wherex();
	y0 = wherey();
	clrscr();
}


/*
	void scr_close()

    - restore screen, cursor shape and position
*/

void scr_close()
{
	puttext (1, 1, ti.screenwidth, ti.screenheight, scrbuf);
	free (scrbuf);
	setcursorshape (cursor0);
	gotoxy (x0, y0);
}


/*
	unsigned getcursorshape()

    - get cursor shape
*/

unsigned getcursorshape()
{
	_AH = 3;
	_BH = 0;
	geninterrupt (0x10);
	return _CX;
}


/*
	void setcursorshape (unsigned shape)

    - set cursor shape
*/

void setcursorshape (unsigned shape)
{
	_CX = shape;
	_AH = 1;
	geninterrupt (0x10);
}


/*
	int putxych (int x, int y, int c)

	- put char on x,y
	- return char
*/

int putxych (int x, int y, int c)
{
	if ((x > 0) && (x < ti.screenwidth) &&
		(y > 0) && (y < ti.screenheight)) {
		gotoxy (x, y);
		putch (c);
	}
	return c;	
}


/*
	int cputc (int c)

	- put char c with no cursor update
	- return c
*/

cputc (int c)
{
	cputcn (c, 1);
	return c;
}


/*
	int cputxyc (int x, int y, int c)

	- put on x,y
*/

cputxyc (int x, int y, int c)
{
	if ((x > 0) && (x < ti.screenwidth) &&
		(y > 0) && (y < ti.screenheight)) {
		gotoxy (x, y);
		cputc (c);
	}
	return c;	
}


/*
	int cgetc()

	- return char under cursor
*/

cgetc()
{
	int c, attr;

	return cgetca (c, attr);
}


/*
	int cputca (int c, int attr)

	- put char c and attribute attr with no cursor update
	- return c
*/

cputca (int c, int attr)
{
	_AH = 9;
	_AL = c;
	_BH = 0;
	_BL = attr;
	_CX = 1;
	geninterrupt (0x10);
	return c;
}


/*
	cputxyca (int x, int y, int x, int attr)

	- put on x,y
*/

cputxyca (int x, int y, int c, int attr)
{
	if ((x > 0) && (x < ti.screenwidth) &&
		(y > 0) && (y < ti.screenheight)) {
		gotoxy (x, y);
		cputca (c, attr);
	}
	return c;	
}


/*
	int cgetca (int &c, int &attr)

	- get char c and attribute attr under cursor
	- return c
*/

cgetca (int &c, int &attr)
{
	_AH = 8;
	_BH = 0;
	geninterrupt (0x10);
	c = _AL;
	attr = _AH;
	return c;
}


/*
	int cputcn (int c, int repeat)

	- put char c repeat times with no cursor update
	- return c
*/

cputcn (int c, int repeat)
{
	if (repeat > 0) {
		_AH = 9;
		_AL = c;
		_BH = 0;
		_BL = ti.attribute;
		_CX = repeat;
		geninterrupt (0x10);
	}
	return c;
}


/*
	int cputxycn (int x, int y, int c, int repeat)

	- put on x,y
*/

int cputxycn (int x, int y, int c, int repeat)
{
	if ((x > 0) && (x < ti.screenwidth) &&
		(y > 0) && (y < ti.screenheight)) {
		gotoxy (x, y);
		cputcn (c, repeat);
	}
	return c;	
}


/*
	int cputcan (int c, int attr, int n)

	- put char c and attribute attr n times with no cursor update
	- return c
*/

cputcan (int c, int attr, int n)
{
	_AH = 9;
	_AL = c;
	_BH = 0;
	_BL = attr;
	_CX = n;
	geninterrupt (0x10);
	return c;
}


/*
	int cputxycan (int x, int y, int c, int attr, int n);

	- put char c and attribute attr n times with no cursor update at x,y
	- return c
*/

int cputxycan (int x, int y, int c, int attr, int n)
{
	if ((x > 0) && (x < ti.screenwidth) &&
		(y > 0) && (y < ti.screenheight)) {
		gotoxy (x, y);
		cputcan (c, attr, n);
	}
	return c;	
}


/*
	int fill (int x1, int y1, int x2, int y2, int c)

	- popunjava regiju znakom c i atributom u globalnoj c_fill
	- return c
*/

fill (int x1, int y1, int x2, int y2, int c)
{
	int a;

	for (a = y1; a <= y2; a++) 
		cputxycan (x1, a, c, c_fill, x2 - x1 + 1);

	return c;
}


/*
	int fillall (int c)

    - fill whole screen with char c and attrib c_fill
	- return c
*/

fillall (int c)
{
	fill (1, 1, ti.screenwidth, ti.screenheight, c);
	return c;
}


/*
	int select (int x, int y, int len)

    - select field
	- return len
    - attrib of selected field is in c_sitem
*/

int select (int x, int y, int len)
{
	for (len--; len>=0; len--) 
		cputxyca (x+len, y, cgetc(), c_sitem);

	return len;
}


/*
	int unselect (int x, int y, int len)

    - deselect field
	- return len
    - attrib of unselected field is in c_item
*/

int unselect (int x, int y, int len)
{
	for (len--; len>=0; len--) 
		cputxyca (x+len, y, cgetc(), c_item);

	return len;
}


/*
	void box (int x1, int y1, int x2, int y2, char *boxchar)

    - draw box with frame in *boxchar
    - attrib is in c_box
    - in vars bsingle and bdouble are ready defs for single and double frame
*/

void box (int x1, int y1, int x2, int y2, char *boxchar)
{
	int a, y0;
	int cx;

	textattr (c_box);
	y0 = y1;
	cx = x1;
	putxych (cx++, y0, boxchar[0]);
	for (a=0; a <= x2-x1-2; a++)
		putxych (cx++, y0, boxchar[1]);
	putxych (cx++, y0++, boxchar[2]);
	do {
		putxych (x1, y0, boxchar[3]);
		putxych (x2, y0++, boxchar[4]);
	} while (y0 <= y2-1);
	putxych (x1, y0, boxchar[5]);
	cx = x1;
	for (a=0; a <= x2-x1-2; a++)
		putxych (++cx, y0, boxchar[6]);
	cputxyca (++cx, y0, boxchar[7], c_box);
}
