
/*
    KBD.CPP
    Created 1995 by Dejvid Zaninovic
*/

#include <conio.h>
#include <ctype.h>
#include <string.h>
#include <dos.h>
#include "c.hpp"
#include "kbd.hpp"

struct sk_stat far *kbstat = (sk_stat far *) MK_FP (0x40, 0x17);


/*
	void keybflush()

	- flush keyboard buffer
*/

void kbflush()
{
	while (kbhit())
		getch();
}


/*
	int getchf (char list[])

	- vraca pritisnutu tipku koja je u listi
*/

int getchf (char list[])
{
	char ch;
	int ok;

	strupr (list);
	ok = FALSE;
	do {
		int a;

		ch = toupper (getch());
		for (a=0; list[a] != 0; a++)
			if (list[a] == ch) {
				ok = TRUE;
				break;
			}
	} while (!ok);

	return ch;
}


/*
	int getpassf (char buff[], int len)

	- get password in buff, length in len
	- return real len
*/

int getpassf (char buf[], int len)
{
	int ch, n = 0, ok = FALSE;

	do {
		ch = getch();
		switch (ch) {
		case K_ENTER:
			ok = TRUE;
			break;
		case 0:
			getch();
			break;
		case K_BKSP:
			if (n>0)
				n--;
			cputs ("\b \b");
			break;
		default:
			buf[n++] = toupper (ch);
			putch('*');
		}
	} while ((n < len) && !ok);
	buf[n] = 0;

	return n;
}


/*
	int getkey()

	- get key from keyboard, if extended key +256
*/

int getkey()
{
	int ch;

	if (!(ch = getch())) 
		ch = 256 + getch();

	return ch;
}


/*
	int ungetkey (int key)

	- put key into keyboard buffer
*/

int ungetkey (int key)
{
	if (key > 255) {
		ungetch (key);
		ungetch (0);
	} 
	else {
		ungetch (key);
    }

	return key;
}


/*
    void kbset (int rate, int delay);

    - set keybord rate and delay
*/

void kbset (int rate, int delay)
{
	asm {
		mov al,5
		mov bl,rate
		mov bh,delay
		int 16h
	}
}

