
/*
	DATE.HPP
    Created 1995 by Dejvid Zaninovic
*/

#ifndef DATE_HPP
#define DATE_HPP

#include <dos.h>
#include "c.hpp"

#define QCENTDAYS (365L * 400L + 100L - 3L)	// 146097 days in 4 centuries
#define CENTDAYS (365L * 100L + 24L) 	// 36524 days in 1 non-leap century
#define QUADDAYS (365L * 4L + 1L) 		// 1461 days in leap quad
#define YEARDAYS 365L					// days in 1 non-leap year

boolean isdate (word year, byte month, byte day);// is date ok
boolean isleap (word year);					// is leap year ?
byte mlen (byte month);						// get len of month

class xdate {
	word year;
	byte month;
	byte day;
public:
	xdate() {xdate::null();}				// init all to nul
	xdate (word year, byte month=1, byte day=1); // init all
	word getyear() const {return year;};	// return year
	byte getmonth() const {return month;};  // return month
	byte getday() const {return day;};		// return day
	xdate null(); 							// set date to null
	boolean isnull() const;					// is date null
	word setyear (word n);					// set year, return year
	byte setmonth (byte n);					// set month, return month
	byte setday (byte n); 					// set day, return day
	boolean set (word year, byte month=1, byte day=1); // set all
	boolean isdate() const {                // is date ok
		return ::isdate (year, month, day);
	}
	dword dton() const;						// return numeric from date
	xdate ntod (dword n);					// set date from numeric
	char dayofweek() const;					// day of week, 0 - ned, 1 - pon...
	friend xdate today();					// get today date
	xdate today();							// set date to today
	xdate operator + (dword n); 			// add num to date
	xdate operator - (dword n); 			// sub num from date
	long operator - (xdate d); 				// sub date from date
	boolean operator > (xdate d) const;		// compare dates
	boolean operator < (xdate d) const;		// compare dates
	boolean operator >= (xdate d) const;	// compare dates
	boolean operator <= (xdate d) const;	// compare dates
	boolean operator == (xdate d) const;	// compare dates
	boolean operator != (xdate d) const;	// compare dates
};

#endif
