{$U-,C-,R-,K-}
CONST
     MASTER_FILE_NAME = 'WXTERM.MST';
TYPE
    MasterRec        = RECORD
                       mdbits      : 7..8;
                       mparity     : parity_set;
                       mstop_bits  : 1..2;
                       mcom_port   : com1..com2;
                       mspeed      : INTEGER;
                       mjropt      : BOOLEAN;
                       END;
VAR
   msrecord              : MasterRec;
   msfile                : FILE OF MasterRec;

PROCEDURE setup;
{initialize most stuff - you may want to replace this routine completely}

BEGIN
  WITH msrecord DO
  BEGIN
     Assign(msfile,MASTER_FILE_NAME);
     IF exists(MASTER_FILE_NAME) THEN
     BEGIN
        RESET(msfile);
        READ(msfile, msrecord)
     END
     ELSE
     BEGIN
        REWRITE(msfile);
        mdbits      := 7;
        mparity     := EVEN;
        mstop_bits  := 1;
        mcom_port   := com1;
        mspeed      := DEFAULT_BAUD;
        mjropt      := FALSE;
        WRITE(msfile, msrecord);
        Flush(msfile);
     END;
     dbits        := mdbits;
     parity       := mparity;
     stop_bits    := mstop_bits;
     speed        := mspeed;
     Cport        := mcom_port;
     pcjrmode     := mjropt;
     CLOSE(msfile);
  END;
END;


PROCEDURE GetParms;
VAR
   p : STRING[4];
   yy: STRING[2];
   cp: STRING[5];
BEGIN
     WRITELN('Current Parameters:');
     WRITELN('Baud Rate:',speed:6);
     WRITELN('Data Bits:',dbits:6);
     WRITELN('Stop Bits:',stop_bits:6);
     CASE parity OF
          even : p := 'EVEN';
          none : p := 'NONE';
          ELSE   p := '????'
     END;
     WRITELN('Parity:   ',p:6);
     IF Cport = com1 THEN cp := 'COM1'
     ELSE                 cp := 'COM2';
     WRITELN('Comm Port: ',cp);
     WRITELN('PcJr Mode: ',pcjrmode);
     WRITELN;
     WRITE('Change? (Y/N) ');
     READLN(p);
     IF LENGTH(p) > 0 THEN
        IF UpCase(p) = 'Y' THEN
        BEGIN
          WRITE('New Baud Rate (<cr> to keep): ');
          READLN(speed);
          WRITE('New Data Bits (<cr> to keep): ');
          READLN(dbits);
          WRITE('New Stop Bits (<cr> to keep): ');
          READLN(stop_bits);
          WRITE('New Parity (E or N or <cr> to keep): ');
          READLN(p);
          WRITE('New com port (1 or 2 or <cr> to keep:  ');
          READLN(cp);
          WRITE('New PcJr mode (Y or N or <cr> to keep: ');
          READLN(yy);
          IF LENGTH(p) > 0 THEN
             CASE UpCase(p) OF
               'E' : parity := even;
               ELSE parity := none;
             END;
         IF LENGTH(yy) > 0 THEN
            BEGIN
               IF UpCase(yy) = 'Y' THEN
                  pcjrmode := TRUE
               ELSE
                  pcjrmode := FALSE;
            END;
         IF LENGTH(cp) > 0 THEN
            BEGIN
               remove_port;
               IF cp = '1' THEN
                  Cport := com1;
               IF cp = '2' THEN
                  Cport := com2;
               init_port;
               term_ready(TRUE);
            END;
         WRITE('Save changes?  (Enter Y if yes): ');
         READLN(yy);
         IF LENGTH(yy) > 0 THEN
            IF UpCase(yy) = 'Y' THEN
            BEGIN
               WITH msrecord DO
               BEGIN
                  mdbits        := dbits;
                  mparity       := parity;
                  mstop_bits    := stop_bits;
                  mspeed        := speed;
                  mcom_port     := Cport;
                  mjropt        := pcjrmode;
                  RESET(msfile);
                  WRITE(msfile, msrecord);
                  CLOSE(msfile);
               END;
            END;
     END
END;

PROCEDURE NewParms;
BEGIN
     OpenTemp(15,3,60,23,2);
     GetParms;
     CloseTemp;
     update_uart;
     New_Baud(speed)
END;
