unit chrres;

interface

uses objects,views,dialogs,drivers,crt,app,ShowView,MsgBox,chrhelp;

type pChemRec  = ^ChemLabel;
     ChemLabel = record
                  name : string;
                  Kv : real;
                  mol: real;
                  tr : real;
                  SMol,SKv: string;
                 end;
     pChemCollection  = ^tChemCol;
     tChemCol  = object(tSortedCollection) {Lijst met chemicals}
                  Constructor Init;
                  Procedure PutItem(var S:tStream;Item:pointer); virtual;
                  Function Compare(Key1,Key2:pointer):integer; virtual;
                  Function GetItem(var S:tStream):pointer; virtual;
                 end;
     pTrSortedList = ^tTrSortedList;
     tTrSortedList = object(tSortedCollection)
                      Constructor Init(ALimit,ADelta:integer);
                      Function Compare(Key1,Key2:pointer):integer; virtual;
                     end;
     pPieks       = ^tPieks;
     tPieks       = object(tdialog)
                     pShow : pShowViewer;
                     Constructor init(var Bounds:tRect;pOldList:pChemCollection);
                     Procedure HandleEvent(var Event:Tevent); virtual;
                    end;
     pResolutionf = ^tResolutionf;
     tResolutionf = object(tDialog)
                     pShow : pShowViewer;
                     Constructor Init(var Bounds:tRect;pOldList:pChemCollection);
                     Procedure HandleEvent(Var Event:tEvent); virtual;
                    end;
     pChrOpt   = ^tChrOpt;{Dialog box that pops up when pressed "Chromatogram"}
     tChrOpt   = object(tdialog)
                  yLow,yHigh,YStep,
                  XLow,XHigh,XStep : pinputline;
                  Constructor Init;
                  Procedure HandleEvent(var Event:Tevent); virtual;
                  Procedure EndModal(Command:word); virtual;
                 end;

Function get10(aa:real):string;

const cmChrom     = 200;
      cmChromPrint= 201;
      hcViewPieks = 10;
      hcViewRes   = 11;
      SuperScript : string =
       'Peek nr            Name             Quant.(mol)    Kv     Ret.time(s)Cmax(mol/l) Stand. dev.';
      SuperScr2 : string =
       '           Name of Peek 1         -           Name of Peek 2          Resolution Factor ';

var schotels    : real;
    snelh       : real;
    verh        : real;
    debiet      : real;
    pTr         : pTrSortedList;
    pPiek       : pPieks;
    ChemChanged : boolean;

    {varialbles for graph}
    yL,yH,xL,xH,yS,xS : real;
    cmax,cmax2,tmax : real;

Implementation

Function get10(aa:real):string;

var bb : string[10];

begin
 str(aa:10:10,bb);
 get10 := bb;
end;

Constructor tChemCol.Init;

var ptxt,ptxt2 : pstring;

begin
 inherited Init(10002,1);
 Duplicates := True;
end;

Function tChemCol.Compare(Key1,Key2:pointer):Integer;

var Tellen : word;
    txt1,txt2 : string;
    Difference : integer;

begin
 txt1 := pChemRec(Key1)^.Name;
 txt2 := pChemRec(Key2)^.Name;
 Tellen := 0; Difference := 0;
 repeat
  Tellen := Tellen+1;
  if UpCase(txt1[Tellen]) < UpCase(txt2[Tellen]) then
   Difference := -1;
  if UpCase(txt1[Tellen]) > UpCase(txt2[Tellen]) then
   Difference := 1;
  if (Length(txt1) = Tellen) and (Length(txt2) > Tellen) then
   Difference := -1;
  if (Length(txt1) > Tellen) and (Length(txt2) = Tellen) then
   Difference := 1;
 until ((Length(txt1) = Length(txt2)) and (Length(txt1) = Tellen)) or (Difference <> 0);
 Compare := Difference;
end;

Procedure tChemCol.PutItem(var S:tStream;Item:pointer);

begin
 S.WriteStr(@(pChemRec(Item)^.Name));
 S.Write(pChemRec(Item)^.Mol,6);
 S.Write(pCHemRec(Item)^.Kv,6);
 S.WriteStr(@(pChemRec(Item)^.SMol));
 S.WriteStr(@(pChemRec(Item)^.SKv));
end;

Function tChemCol.GetItem(var S:tStream):pointer;

var Item : pChemRec;

begin
 GetMem(Item,SizeOf(ChemLabel));
 Item^.Name := S.ReadStr^;
 S.Read(Item^.Mol,6);
 S.Read(Item^.Kv,6);
 Item^.tr := 0;
 Item^.SMol := S.ReadStr^;
 Item^.SKv := S.ReadStr^;
 GetItem := Item;
end;

Constructor tTrSortedList.Init(ALimit,ADelta:integer);

begin
 inherited Init(ALimit,ADelta);
 Duplicates := true;
end;

Function tTrSortedList.Compare(Key1,Key2:pointer):integer;

begin
 if pChemRec(Key1)^.tr < pChemRec(Key2)^.tr then
  Compare := -1;
 if pChemRec(Key1)^.tr = pChemRec(Key2)^.tr then
  Compare := 0;
 if pChemRec(Key1)^.tr > pChemRec(Key2)^.tr then
  Compare := 1;
end;

Constructor tPieks.Init(var Bounds:tRect;pOldList:pChemCollection);

var R   : tRect;
    pList    : pTrSortedList;
    Chemical : pChemRec;
    forl     : word;
    var2,var3  : real;
    Output,txt : string;
    pScrl1,pScrl2: pScrollBar;

begin
 inherited init(Bounds,'Information on Pieks');
 Flags := wfMove+wfClose+wfZoom;
 R.Assign(Bounds.A.X,Bounds.B.Y-2,Bounds.B.X-2,Bounds.B.Y-1);
 pScrl1 := New(pScrollBar,init(R));
 R.Assign(Bounds.B.X-2,Bounds.A.Y,Bounds.B.X-1,Bounds.B.Y-2);
 pScrl2 := new(pScrollBar,init(R));
 R.assign(Bounds.A.X,Bounds.A.Y,Bounds.B.X-2,Bounds.B.Y-2);
 pShow := new(pShowViewer,init(R,pScrl1,pScrl2));
 pShow^.GrowMode := gfGrowHiX+gfGrowHiY;
 Insert(pScrl1);
 Insert(pScrl2);
 Insert(pShow);
 pShow^.SetText(1,SuperScript);

 HelpCtx := hcViewPieks;

 {Invoegen Pieken}

 If pOldList <> nil then
 begin
  pList := New(pTrSortedList,init(pOldList^.Count-1,1));
  for forl := 0 to pOldList^.Count-1 do
   pList^.Insert(pOldList^.At(forl));
  For forl := 0 to pList^.Count-1 do
  begin
   Chemical := pChemRec(pList^.At(forl));

   var3 := Chemical^.tr/sqrt(schotels);
   var2 := (Chemical^.mol*1e-3)/(debiet*var3*sqrt(2*pi));

   str(Forl+1:6,OutPut);
   txt := ' '+Copy(Chemical^.name,1,29);
   while length(txt) <= 30 do
    txt := txt+' ';
   Output := Output+txt+''+get10(Chemical^.mol)+' '+get10(Chemical^.Kv)+' '+
              get10(Chemical^.tr)+' '+get10(var2)+' '+get10(var3);

   pShow^.SetText(1,Output);
  end;
 end;
end;

Procedure tPieks.HandleEvent(var Event:tEvent);

begin
 inherited HandleEvent(Event);
 if Event.What = evBroadCast then
 begin
  if (Event.Command = cmDefault) and GetState(sfActive) then
  begin
   EndModal(cmCancel);
   ClearEvent(Event);
  end;
  if (Event.Command = cmScrollBarChanged) or
     (Event.Command = cmScrollBarClicked) then
  begin
   Message(pShow,evBroadCast,cmScrollBarChanged,nil);
   ClearEvent(Event);
  end;
 end;
end;

Constructor tResolutionf.Init(var Bounds:tRect;pOldList:pChemCollection);

var R : tRect;
    pScrl1,pScrl2 : pScrollBar;
    pList : pTrSortedList;
    pItem1,pItem2 : pChemRec;
    var2,var3,Rf  : real;
    txt,txt2      : String;
    forl          : word;

begin
 inherited init(Bounds,'Resolution factors');
 Flags := wfClose+wfZoom+wfMove;
 R.assign(1,Size.Y-1,Size.X-2,Size.Y);
 pScrl1 := new(pScrollBar,Init(R));
 Insert(pScrl1);
 R.Assign(Bounds.B.X-2,Bounds.A.Y,Bounds.B.X-1,Bounds.B.Y-2);
 pScrl2 := new(pScrollBar,init(R));
 Insert(pScrl2);
 R.assign(Bounds.A.X,Bounds.A.Y,Bounds.B.X-2,Bounds.B.Y-2);
 pShow := new(pShowViewer,init(R,pScrl1,pScrl2));
 pShow^.GrowMode := gfGrowHiX+gfGrowHiY;
 Insert(pShow);
 pShow^.SetText(1,SuperScr2);

 HelpCtx := hcViewRes;

 If pOldList <> nil then
 begin
  pList := New(pTrSortedList,init(pOldList^.Count-1,1));
  for forl := 0 to pOldList^.Count-1 do
   pList^.Insert(pOldList^.At(forl));
  For forl := 0 to pList^.Count-2 do
  begin
   pItem1 := pChemRec(pList^.At(forl));
   pItem2 := pChemRec(pList^.At(forl+1));
   var2 := pItem1^.tr/sqrt(schotels);
   var3 := pItem2^.tr/sqrt(schotels);
   Rf := (pItem2^.tr-pItem1^.tr)/(0.5*(4*var3+4*var2));
   txt2 := copy(pItem1^.name,1,33);
   while length(txt2) < 33 do
    txt2 := txt2+' ';
   txt := txt2;
   txt2 := copy(pItem2^.name,1,32);
   while length(txt2) < 32 do
    txt2 := txt2+' ';
   txt := txt+' - '+txt2+'  ';
   Str(Rf:15:10,txt2);
   txt := txt+txt2;
   pShow^.SetText(1,txt);
  end;
 end;
end;

Procedure tResolutionf.HandleEvent(var Event:tEvent);

begin
 inherited HandleEvent(Event);
 if Event.What = evBroadCast then
 begin
  case Event.Command of
   cmDefault : EndModal(cmDefault);
   cmScrollBarClicked,cmScrollBarChanged : Message(pShow,evBroadCast,cmScrollBarChanged,nil);
  end;
  ClearEvent(Event);
 end;
end;

Constructor tChrOpt.Init;

var R :tRect;
    txt:string;
    aa,bb: real;
    err: integer;

begin
 R.assign(1,1,45,13);
 inherited init(R,'Chromatogram options');
 options := options or ofCentered;
 R.assign(2,1,26,2);
 insert(new(pstatictext,init(r,'Vertical axis...')));

 R.assign(8,2,26,3);
 ylow := new(pinputline,init(r,15));
 if ChemChanged then
  str(0.00E00:12:12,txt)
 else
  str(yL:12:12,txt);
 txt := copy(txt,1,15);
 ylow^.Setdata(txt);
 insert(ylow);
 R.assign(2,2,7,3);
 insert(new(plabel,init(r,'~L~ow: ',ylow)));

 R.assign(8,3,26,4);
 yHigh := new(pinputline,init(r,15));
 if ChemChanged then
  str(cmax:12:12,txt)
 else
  str(yH:12:12,txt);
 txt := copy(txt,1,15);
 yHigh^.Setdata(txt);
 insert(yHigh);
 R.assign(2,3,8,4);
 insert(new(plabel,init(R,'~H~igh: ',yHigh)));

 R.assign(8,4,26,5);
 yStep := new(pinputline,init(R,15));
 if ChemChanged then
 begin
  yHigh^.getdata(txt);
  val(txt,aa,err);
  yLow^.Getdata(txt);
  val(txt,bb,err);
  str((aa+bb)/10:12:12,txt);
 end
 else
  str(yS:10:15,txt);
 txt := copy(txt,1,15);
 YStep^.Setdata(txt);
 insert(yStep);
 R.assign(2,4,8,5);
 insert(new(plabel,init(R,'~S~tep: ',yStep)));

 R.assign(2,6,26,7);
 insert(new(pstatictext,init(r,'Horizontal axis...')));
 R.assign(8,7,26,8);
 xLow := new(pinputline,init(r,15));
 if ChemChanged then
  str(0.00E00:12:12,txt)
 else
  str(xL:12:12,txt);
 txt := copy(txt,1,15);
 xLow^.Setdata(txt);
 insert(xLow);
 R.assign(2,7,7,8);
 insert(new(plabel,init(r,'L~o~w: ',xLow)));
 R.assign(8,8,26,9);
 xHigh := new(pinputline,init(r,15));
 if ChemChanged then
  str(tmax:12:12,txt)
 else
  str(xH:12:12,txt);
 txt := copy(txt,1,15);
 xHigh^.Setdata(txt);
 insert(xHigh);
 R.assign(2,8,8,9);
 insert(new(plabel,init(R,'H~i~gh: ',xHigh)));
 R.assign(8,9,26,10);
 xStep := new(pinputline,init(R,15));
 if ChemChanged then
 begin
  xHigh^.getdata(txt);
  val(txt,aa,err);
  xLow^.Getdata(txt);
  val(txt,bb,err);
  str((aa+bb)/10:12:12,txt);
 end
 else
  str(xS:12:12,txt);
 txt := copy(txt,1,15);
 xStep^.Setdata(txt);
 insert(xStep);
 R.assign(2,9,8,10);
 insert(new(plabel,init(R,'S~t~ep: ',xStep)));

 R.assign(26,2,Size.X-2,4);
 insert(new(pbutton,init(R,'~C~hromatogram',cmChrom,bfDefault)));
 R.assign(26,4,Size.X-2,6);
 insert(new(pbutton,init(R,'~P~rint',cmChromPrint,bfNormal)));
 R.assign(26,6,Size.X-2,8);
 insert(new(pbutton,init(R,'C~a~ncel',cmCancel,bfNormal)));
 SelectNext(True);
 SelectNext(True);
 HelpCtx := hcChrInst;
end;

Procedure tChrOpt.HandleEvent(var Event:Tevent);

begin
 if (Event.What = evBroadCast) then
  if Event.Command = cmDefault then
  begin
   if xLow^.GetState(sfSelected) or
      xHigh^.GetState(sfSelected) or
      xStep^.GetState(sfSelected) or
      yLow^.GetState(sfSelected) or
      yHigh^.GetState(sfSelected) or
      yStep^.GetState(sfSelected) then
   begin
    SelectNext(False);
    ClearEvent(Event);
   end;
  end;
 inherited HandleEvent(Event);
 if Event.What = evCommand then
 begin
  case Event.Command of
   cmCancel: EndModal(cmCancel);
   cmChrom : EndModal(cmChrom);
   cmChromPrint:EndModal(cmChromPrint);
  else
   exit;
  end;
  ClearEvent(Event);
 end;
end;

Procedure tChrOpt.EndModal(Command:word);

var err : integer;
    txt : string;
    error : boolean;

 Procedure NumError(item:string);

 begin
  if err <> 0 then
  begin
   messagebox(^C'Invalid number for'#13 + ^C'"'+item+'".',nil,mfError+mfOkButton);
   ChemChanged := true;
   error := true;
  end;
 end;

begin
 ChemChanged := false;
 error := false;

 yHigh^.getdata(txt);
 val(txt,yH,err);
 NumError('Vertical axis... HIGH');

 yLow^.getdata(txt);
 val(txt,yL,err);
 NumError('Vertical axis... LOW');

 yStep^.getdata(txt);
 val(txt,yS,err);
 NumError('Vertical axis... STEP');

 xHigh^.getdata(txt);
 val(txt,xH,err);
 NumError('Horizontal axis... HIGH');

 xLow^.getdata(txt);
 val(txt,xL,err);
 NumError('Horizontal axis... LOW');

 xStep^.getdata(txt);
 val(txt,xS,err);
 NumError('Horizontal axis... STEP');

 if error then
 begin
  inherited EndModal(cmCancel);
  exit;
 end;

 if (xH-xL <= 0) or (xS <= 0) then
 begin
  Messagebox(^C'Invalid X-axis.',nil,mfError+mfOkButton);
  inherited EndModal(cmCancel);
  exit;
 end;

 if (yH-yL <= 0) or (yS <= 0) then
 begin
  Messagebox(^C'Invalid Y-axis.',nil,mfError+mfOkButton);
  inherited EndModal(cmCancel);
  exit;
 end;

 inherited EndModal(Command);
end;

end.