/*--------------------------------------------------------------------------*/
/* XMM API                                                                  */
/*                                                                          */
/* Jan 1997 jmh@as.arizona.edu              released into the public domain */
/*--------------------------------------------------------------------------*/

#ifndef _xmmapi
#define _xmmapi


typedef struct {
    unsigned long   len;
    unsigned short  srchndl;
    unsigned long   srcoff;
    unsigned short  dsthndl;
    unsigned long   dstoff;
    } pmove;


extern  long    XMMaddr;
extern  pmove   XMMpmove;


short   XMMcheck    (void);
long    XMMvers     (void);
long    XMMreqHMA   (unsigned short size);
long    XMMrelHMA   (void);
long    XMMgeA20    (void);
long    XMMgdA20    (void);
long    XMMenA20    (void);
long    XMMdisA20   (void);
long    XMMgetA20   (void);
long    XMMlargest  (void);
long    XMMtotal    (void);
long    XMMalloc    (unsigned short kbytes);
long    XMMfree     (unsigned short handle);
long    XMMmove     (void);
long    XMMlock     (unsigned short handle);
long    XMMunlock   (unsigned short handle);
long    XMMgetlen   (unsigned short handle);
long    XMMgetinfo  (unsigned short handle);
long    XMMrealloc  (unsigned short handle, unsigned short kbytes);
long    XMMreqUMB   (unsigned short UMBsize);
long    XMMrelUMB   (unsigned short UMBseg);


#endif



