    TITLE   XMMAPI.ASM
    NAME    XMMAPI

;***************************************************************************;
; XMM C interface                                                           ;
;                                                                           ;
; Based on the Microsoft 2.0 release of the XMS. Rewritten to dispense with ;
; the obtuse macros MS used and also to use the large memory model.         ;
;                                                                           ;
; Requires MASM 6.0 (ml) to assemble.                                       ;
; Refer to the MASM docs for info on using a different memory model.        ;
; See the file xmmapi.h for prototype definitions.                          ;
;                                                                           ;
; jan 1997 - John M. Hughes (jmh@as.arizona.edu)                            ;
;                                                                           ;
; This code is supplied as-is, where-is, with no guarantees either express  ;
; or implied. User assumes all risks. No support is available. This code is ;
; in the public domain, and may be used without restriction.                ;
;***************************************************************************;

    INCLUDE macros.inc

    .MODEL LARGE, C, FARSTACK

    PUBLIC XMMpmove, XMMaddr


pmove       STRUCT                          ; XMMmove control data structure
            len     DWORD  ?                ; number of bytes to transfer
            srchndl WORD   ?                ; handle of source block
            srcoff  DWORD  ?                ; 32-bit offset into source
            dsthndl WORD   ?                ; handle of destination block
            dstoff  DWORD  ?                ; 32-bit offset into destination
pmove       ENDS


    .DATA

XMMaddr     LABEL   DWORD                   ; holds addr of XMM cmd handler
            dw      OFFSET XMMNotInit       ; initial address to jump to
            dw      seg _TEXT               ; whatever our text segment is

XMMpmove    pmove   < >

imbedded    DB      'Jan 97 public domain release jmh@as.arizona.edu'

    .CODE

;---------------------------------------------------------------------------;
; XMMNotInit                                                                ;
;                                                                           ;
; this will be invoked if one of the API functions is called prior to       ;
; XMMcheck, which places the correct address of the XMM command address     ;
; into the doubleword location at XMMaddr                                   ;
;---------------------------------------------------------------------------;

XMMNotInit  PROC FAR

            xor     ax, ax                      ; Immediate failure
            mov     bl, 80h                     ; Not Implemented

            ret

XMMNotInit  ENDP



;---------------------------------------------------------------------------;
; XMMcheck                                                                  ;
;                                                                           ;
; verifies the presence of HIMEM.SYS and sets the enter address for the     ;
; XMM command processor.                                                    ;
;                                                                           ;
; short XMMcheck (void)                                                     ;
;                                                                           ;
;---------------------------------------------------------------------------;

XMMcheck    PROC FAR C PUBLIC USES di si

            mov     ax, 4300h                   ; see if XMM is out there
            int     2fh
            cmp     al, 80h
            jne     nohimem 

            mov     ax, 4310h                   ; get control address 
            int     2fh
            mov     word ptr [XMMaddr], bx      ; save address for later
            mov     word ptr [XMMaddr+2], es

            mov     ax, 1
            jmp     endcheck

nohimem:    mov     ax, 0

endcheck:   ret

XMMcheck    ENDP



;---------------------------------------------------------------------------;
; XMMvers                                                                   ;
;                                                                           ;
; returns the version number of the installed XMM as a long value.          ;
;                                                                           ;
; long XMMvers (void)                                                       ;
;                                                                           ;
;---------------------------------------------------------------------------;

XMMvers     PROC FAR C PUBLIC USES di si 

            xor     ah, ah                      ; Function 0
            call    [XMMaddr]
            mov     dx, bx                      ; Return a long

            ret

XMMvers     ENDP



;---------------------------------------------------------------------------;
; XMMreqHMA                                                                 ;
;                                                                           ;
; attempts to allocate all or some of the HMA to the caller                 ;
;                                                                           ;
; long XMMreqHMA (unsigned short size);                                     ;
;                                                                           ;
;---------------------------------------------------------------------------;

XMMreqHMA   PROC FAR C PUBLIC USES di si, reqsize:WORD

            mov     ah, 1
            mov     dx, reqsize
            call    [XMMaddr]

            SuccessFail

            ret

XMMreqHMA   ENDP



;---------------------------------------------------------------------------;
; XMMrelHMA                                                                 ;
;                                                                           ;
; releases previously allocated HMA space                                   ;
;                                                                           ;
; long XMMrelHMA (void)                                                     ;
;                                                                           ;
;---------------------------------------------------------------------------;

XMMrelHMA   PROC FAR C PUBLIC USES di si

            mov     ah, 2
            call    [XMMaddr]

            SuccessFail

            ret

XMMrelHMA   ENDP



;---------------------------------------------------------------------------;
; XMMgeA20                                                                  ;
;                                                                           ;
; Globally enables the A20 line                                             ;
;                                                                           ;
; long XMMgeA20 (void)                                                      ;
;                                                                           ;
;---------------------------------------------------------------------------;
XMMgeA20    PROC FAR C PUBLIC USES di si 

            mov     ah, 3
            call    [XMMaddr]

            SuccessFail

            ret

XMMgeA20    ENDP



;---------------------------------------------------------------------------;
; XMMgdA20                                                                  ;
;                                                                           ;
; Globally disables the A20 line                                            ;
;                                                                           ;
; long XMMgdA20 (void)                                                      ;
;                                                                           ;
;---------------------------------------------------------------------------;
XMMgdA20    PROC FAR C PUBLIC USES di si  

            mov     ah, 4
            call    [XMMaddr]

            SuccessFail

            ret

XMMgdA20    ENDP



;---------------------------------------------------------------------------;
; XMMenA20                                                                  ;
;                                                                           ;
; Locally enables the A20 line                                              ;
;                                                                           ;
; long XMMenA20 (void)                                                      ;
;                                                                           ;
;---------------------------------------------------------------------------;

XMMenA20    PROC FAR C PUBLIC USES di si   

            mov     ah, 5
            call    [XMMaddr]

            SuccessFail

            ret

XMMenA20    ENDP



;---------------------------------------------------------------------------;
; XMMdisA20                                                                 ;
;                                                                           ;
; Locally disables the A20 line                                             ;
;                                                                           ;
; long XMMdisA20 (void)                                                     ;
;                                                                           ;
;---------------------------------------------------------------------------;

XMMdisA20   PROC FAR C PUBLIC USES di si   

            mov     ah, 6
            call    [XMMaddr]

            SuccessFail

            ret

XMMdisA20   ENDP



;---------------------------------------------------------------------------;
; XMMgetA20                                                                 ;
;                                                                           ;
; returns status of A20 line                                                ;
;                                                                           ;
; long XMMgetA20 (void)                                                     ;
;                                                                           ;
;---------------------------------------------------------------------------;

XMMgetA20   PROC FAR C PUBLIC USES di si   

            mov     ah, 7
            call    [XMMaddr]

            SuccessFailAX

            ret 

XMMgetA20   ENDP



;---------------------------------------------------------------------------;
; XMMlargest                                                                ;
;                                                                           ;
; returns the largest free XM block available                               ;
;                                                                           ;
; long XMMlargest(void)                                                     ;
;                                                                           ;
;---------------------------------------------------------------------------;

XMMlargest  PROC FAR C PUBLIC USES di si   

            mov     ah, 8
            call    [XMMaddr]

            SuccessFailAX

            ret

XMMlargest  ENDP



;---------------------------------------------------------------------------;
; XMMtotal                                                                  ;
;                                                                           ;
; returns total free XM space                                               ;
;                                                                           ;
; long XMMtotal (void)                                                      ;
;                                                                           ;
;---------------------------------------------------------------------------;

XMMtotal    PROC FAR C PUBLIC USES di si   

            mov     ah, 8
            call    [XMMaddr]

            SuccessFailDX

            ret

XMMtotal    ENDP



;---------------------------------------------------------------------------;
; XMMalloc                                                                  ;
;                                                                           ;
; Allocates extended memory                                                 ;
;                                                                           ;
; long XMMalloc (unsigned short kbytes)                                     ;
;                                                                           ;
;---------------------------------------------------------------------------;

XMMalloc    PROC FAR C PUBLIC USES di si, kbytes:WORD

            mov     ah, 9
            mov     dx, kbytes
            call    [XMMaddr]

            SuccessFailDX

            ret

XMMalloc    ENDP



;---------------------------------------------------------------------------;
; XMMfree                                                                   ;
;                                                                           ;
; free an allocated section of extended memory                              ;
;                                                                           ;
; long XMMfree (unsigned short handle)                                      ;
;                                                                           ;
;---------------------------------------------------------------------------;

XMMfree     PROC FAR C PUBLIC USES di si, handle:WORD
 
            mov     ah, 0Ah
            mov     dx, handle
            call    [XMMaddr]

            SuccessFail

            ret

XMMfree     ENDP



;---------------------------------------------------------------------------;
; XMMmove                                                                   ;
;                                                                           ;
; moves memory from low-to-high, low-to-low, or high-to-high                ;
;                                                                           ;
; NOTE: The control data structure MUST be configure correctly before this  ;
;       call is entered. There are no checks to ensure valid control data.  ;
;                                                                           ;
; long XMMmove (void)                                                       ;
;                                                                           ;
;---------------------------------------------------------------------------;

XMMmove     PROC FAR C PUBLIC USES di si 

            mov     ah, 0Bh
            mov     si, OFFSET XMMpmove         ; DS:SI => move parameters
            call    [XMMaddr]

            SuccessFail

            ret

XMMmove     ENDP



;---------------------------------------------------------------------------;
; XMMlock                                                                   ;
;                                                                           ;
; attempts to lock a section of extended memory                             ;
;                                                                           ;
; long XMMlock (unsigned short handle)                                      ;
;                                                                           ;
;---------------------------------------------------------------------------;

XMMlock     PROC FAR C PUBLIC USES di si, handle:WORD

            mov     ah, 0Ch
            mov     dx, handle
            call    [XMMaddr]

            xchg    ax, bx
            dec     bx
            jz      gotlock
            mov     dh, al

gotlock:    ret

XMMlock     ENDP



;---------------------------------------------------------------------------;
; XMMunlock                                                                 ;
;                                                                           ;
; unlocks a previously locked block of extended memory                      ;
;                                                                           ;
; long XMMunlock (unsigned short handle)                                    ;
;                                                                           ;
;---------------------------------------------------------------------------;

XMMunlock   PROC FAR C PUBLIC USES di si, handle:WORD

            mov     ah, 0Dh
            mov     dx, handle
            call    [XMMaddr]

            SuccessFail

            ret

XMMunlock   ENDP



;---------------------------------------------------------------------------;
; XMMgetlen                                                                 ;
;                                                                           ;
; returns the allocated size of block associated with a handle              ;
;                                                                           ;
; long XMMgetlen (unsigned short handle)                                    ;
;                                                                           ;
;---------------------------------------------------------------------------;

XMMgetlen   PROC FAR C PUBLIC USES di si, handle:WORD 

            mov     ah, 0Eh
            mov     dx, Handle
            call    [XMMaddr]

            SuccessFailDX

            ret

XMMgetlen   ENDP



;---------------------------------------------------------------------------;
; XMMgetinfo                                                                ;
;                                                                           ;
; returns information about an allocated block                              ;
;                                                                           ;
; long XMMgetinfo (unsigned short handle)                                   ;
;                                                                           ;
;---------------------------------------------------------------------------;

XMMgetinfo  PROC FAR C PUBLIC USES di si, handle:WORD  

            mov     ah, 0Eh
            mov     dx, Handle
            call    [XMMaddr]

            mov     dx, bx

            SuccessFailDX

            ret

XMMgetinfo  ENDP



;---------------------------------------------------------------------------;
; XMMrealloc                                                                ;
;                                                                           ;
; reallocates a block of extended memory. the block must be unlocked.       ;
;                                                                           ;
; long XMMrealloc (unsigned short handle, unsigned short kbytes)            ;
;                                                                           ;
;---------------------------------------------------------------------------;

XMMrealloc  PROC FAR C PUBLIC USES di si, handle:WORD, kbytes:WORD

            mov     ah, 0Fh
            mov     dx, Handle
            mov     bx, kbytes
            call    [XMMaddr]

            SuccessFail

            ret

XMMrealloc  ENDP


;---------------------------------------------------------------------------;
; XMMreqUMB                                                                 ;
;                                                                           ;
; attempts to allocate a UMB to the caller                                  ;
;                                                                           ;
; long XMMreqUMB (unsigned short UMBsize)                                   ;
;                                                                           ;
;---------------------------------------------------------------------------;

XMMreqUMB   PROC FAR C PUBLIC USES di si, UMBsize:WORD

            mov     ah, 10h
            mov     dx, UMBSize
            call    [XMMaddr]

            xchg    bx, ax          ; Segment in AX, Size in DX
            dec     bx
            jz      gotumb

            xchg    ax, dx          ; Largest available size in AX
            mov     dh, dl          ; Error code now in DH

gotumb:     ret

XMMreqUMB   ENDP



;---------------------------------------------------------------------------;
; XMMrelUMB                                                                 ;
;                                                                           ;
; releases previously allocated UMB space                                   ;
;                                                                           ;
; long XMMrelUMB (unsigned short UMBseg)                                    ;
;                                                                           ;
;---------------------------------------------------------------------------;

XMMrelUMB   PROC FAR C PUBLIC USES di si, UMBseg:WORD

            mov     ah, 11h
            mov     dx, UMBseg
            call    [XMMaddr]

            SuccessFail

            ret

XMMrelUMB   ENDP


            END
