/*
==============================================================================
		      WordUp Graphics Toolkit Version 5.0                     
			     Demonstration Program 35                         
									      
 Loads an image using wloadblock/wloadpak/wloadcel/wloadbmp/wloadpcx
 and saves the same image back out using wsaveblock, wsavepak, wsavecel,     
 wsavebmp, and wsavepcx.
									      
 *** PROJECT ***                                                             
 This program requires the file WGT5_WC.LIB to be linked.                    
									      
 *** DATA FILES ***                                                          
 You must have the following data files in your executable dir:              
 SAMPLE.BLK, SAMPLE.PAL                                  
							   WATCOM C++ VERSION 
==============================================================================
*/

#include <io.h>
#include <fcntl.h>
#include <wgt5.h>

block sample_image;    /* Contains our sample image */
color pal[256];
short oldmode;

short image_handle;      /* File handle used for finding file sizes */
			 /* Note that all files store the same image data,
			    and CEL, BMP, and PCX also store the palette. */ 

void main(void)
{
  if ( !vgadetected () )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit(0);
  }
  printf ("WGT Example #35\n\n");
  printf ("Several of WGT's image formats are demonstrated by loading and creating\n");
  printf ("bitmaps dynamically. Image file sizes are reported so you can compare the\n");
  printf ("the compression techniques. Press a key to end the program.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  oldmode = wgetmode ();
  vga256 ();

  wloadpalette("sample.pal", pal);  /* Load the palette for the image 
				       formats that don't store one */
  wsetpalette(0, 255, pal);

  wsavepalette ("output.pal", pal); /* Save the palette to a different file */

  wtextcolor(1);

  sample_image = wloadblock ("sample.blk");   /* Load the image */
  wputblock (0, 0, sample_image, 1);          /* Display the image */
  wgtprintf (0, 38, NULL, "BLK");                
  wsaveblock ("output.blk", sample_image);    /* Save in BLK format */
  wsavepak ("sample.pak", sample_image);      /* Save into PAK format */

  wfreeblock (sample_image);                  /* Free the image */

  sample_image = wloadpak ("sample.pak");
  wputblock (50, 0, sample_image, 1);
  wgtprintf (50, 38, NULL, "PAK");
 
  wsavecel ("sample.cel", sample_image, pal);   /* Save into CEL format */
  wfreeblock (sample_image);

  sample_image = wloadcel ("sample.cel", pal);
  wputblock (100, 0, sample_image, 1);
  wgtprintf (100, 38, NULL, "CEL");
  wsavebmp ("sample.bmp", sample_image, pal);   /* Save into BMP format */
  wfreeblock (sample_image);

 sample_image = wloadbmp ("sample.bmp", pal);
 wputblock (150, 0, sample_image, 1);
 wgtprintf (150, 38, NULL, "BMP");
 wsavepcx ("sample.pcx", sample_image, pal);    /* Save into PCX format */
 wfreeblock (sample_image);

 sample_image = wloadpcx ("sample.pcx", pal);
 wputblock (200, 0, sample_image, 1);
 wgtprintf (200, 38, NULL, "PCX");
 wfreeblock (sample_image);

 wgtprintf (0, 100, NULL, "File Sizes:");

 image_handle = open ("sample.blk", O_RDONLY);
 wgtprintf (8, 108, NULL, "BLK - %lu", filelength (image_handle));
 close (image_handle);

 image_handle = open ("sample.pak", O_RDONLY);
 wgtprintf (8, 116, NULL, "PAK - %lu", filelength (image_handle));
 close (image_handle);
 unlink ("sample.pak");

 image_handle = open ("sample.cel", O_RDONLY);
 wgtprintf (8, 124, NULL, "CEL - %lu", filelength (image_handle));
 close (image_handle);
 unlink ("sample.cel");

 image_handle = open ("sample.bmp", O_RDONLY);
 wgtprintf (8, 132, NULL, "BMP - %lu", filelength (image_handle));
 close (image_handle);
 unlink ("sample.bmp");

 image_handle = open ("sample.pcx", O_RDONLY);
 wgtprintf (8, 140, NULL, "PCX - %lu", filelength (image_handle));
 close (image_handle);
 unlink ("sample.pcx");

 unlink ("output.pal");
 unlink ("output.blk");


 getch ();
 wsetmode (oldmode);
}
