/*
==============================================================================
                      WordUp Graphics Toolkit Version 5.0                     
                             Demonstration Program 31                         
                                                                              
 Show how to use WGT library files - simple example with wloadsprites.       
 Also demonstrates how to use lib2buf to extract any type of file.           
                                                                              
  PROJECT                                                              
 This program requires the file WGT5_WC.LIB to be linked.                    
                                                                              
  DATA FILES                                                           
 You must have the DEMO31.WGT library file in your executable directory.    
                                                           WATCOM C++ VERSION 
==============================================================================
*/

#include <wgt5.h>
#include <conio.h>
#include <stdlib.h>

block sprites[2];             /* Pointers to sprites */
color pal[256];               /* Our palette */
short oldmode;                  /* Store previous video mode */
char *buf;                    /* Pointer to a buffer for extra data */

void main(void)
{

  if ( !vgadetected () )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit (0);
  }
  printf ("WGT Example #31\n\n");
  printf ("Files are loaded into memory from a 'library' file.\n");
  printf ("Press a key to end each section of the program.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  oldmode = wgetmode ();         /* Gets the current mode */
  vga256 ();                     /* Initialize graphics mode */
  
  setlib ("demo31.wgt");         /* Tell WGT what library file to use */
  setpassword ("wgt");           /* This is the required password for DEMO31.WGT */

  /* Loads a sprite file from within DEMO31.WGT */
  wloadsprites (pal, "demo31.spr", sprites, 0, 1);
  wsetpalette (0, 255, pal);

  wcls (0);                      /* Clear screen with black */
  do                             /* Randomly place block on screen */
  {
    wputblock (rand () % 300, rand () % 180, sprites[1], 0);
  } while (!kbhit ());           /* Abort when key is pressed */
  getch ();
  wfreesprites (sprites, 0, 1);
  
  /* Clear the screen and load a picture of some leaves */
  wcls (0);
  sprites[0] = wloadbmp ("leaves.bmp", pal);
  wsetpalette (0, 255, pal);
  wputblock (0, 0, sprites[0], NORMAL);
  getch ();
  wfreeblock (sprites[0]);

  /* Clear the screen and load a PCX format picture file */
  wcls (0);
  sprites[0] = wloadpcx ("wgt5_wc.pcx", pal);
  wsetpalette (0, 255, pal);
  wputblock (0, 0, sprites[0], NORMAL);
  getch ();
  wfreeblock (sprites[0]);

  wsetmode (oldmode);            /* Restore initial video mode */

  buf = lib2buf ("demo31.txt"); /* Load a text file from the library file */
  printf ("%s\n", buf);         /* Now display the file */
  free (buf);                   /* Deallocate the buffer */

  printf ("Press any key to exit.\n");
  while (!kbhit ());
  getch ();
}
