/*
==============================================================================
                      WordUp Graphics Toolkit Version 5.0                     
                             Demonstration Program 21                         
                                                                              
  Shows off some special FX using wvertres.                                   
                                                                              
  *** PROJECT ***                                                             
  This program requires the file WGT5_WC.LIB to be linked.                    
                                                                              
  *** DATA FILES ***                                                          
  Make sure that WGT1.PCX, and WGT2.PCX are in your executable dir.  
                                                           WATCOM C++ VERSION 
==============================================================================
*/

#include <conio.h>
#include <stdio.h>
#include <wgt5.h>

void crush (block, block, short);

block screen1, screen2;          /* two virtual screens */

short oldmode;
short y, s;
color palette[256];

void main (void)
{
  if ( !vgadetected () )
  {
    printf ("Error - VGA card required for any WGT program.\n");
    exit (0);
  }
  printf ("WGT Example #21\n\n");
  printf ("This program will repeatedly crush two screens until a key is pressed.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  oldmode = wgetmode ();
  vga256 ();

  screen1 = wloadpcx ("wgt1.pcx", palette);
  screen2 = wloadpcx ("wgt2.pcx", palette);
  wsetpalette (0, 255, palette);
  wputblock (0, 0, screen1, 0);

  do {
    crush (screen1, screen2, 5);
    crush (screen2, screen1, 5);
  } while (!kbhit ());

  wfreeblock (screen1);  /* remember to free that memory */
  wfreeblock (screen2);
  wsetmode (oldmode);
}


void crush (block b1, block b2, short dir)
{
  short q, w, e;

  for (q = 199; q >= 0; q -= dir)
  {
    wretrace ();
    wvertres (0, 0, q, b1);
    wvertres (0, q, 199, b2);
  }
}
