/*
==============================================================================
                      WordUp Graphics Toolkit Version 5.0                     
                             Demonstration Program 18                         
                                                                              
 This program shows how to make animation with two screens.                   
                                                                              
 One way to produce animation is to use two screens.  One screen is           
 constantly displayed while you draw things on the other.  Once the           
 drawing is complete, you then copy the whole screen in the background        
 to the one that is being displayed.                                          
                                                                              
                                                                              
            Visual Screen                          Background Screen          
     ..............................          ..............................   
     ......o.......................          ......o..............o........   
     ...../Y\......................          ...../Y\............/Y\.......   
     ......|.......................          ......|..............|........   
     ...../.\......................          ...../.\............/.\.......   
     ..............................          ..............................   
     ..............................          .Pos 1-> Clear Screen ->Pos 2.   
     ..............................          ..............................   
                                                                              
 Here we have a person shown on the visual page. It has just been copied      
 over from the background screen. Now you must clear the background screen    
 somehow (put a picture over top, or wcls(0) it).  Once it is cleared, you    
 can use wputblock to show the person in a different place on the screen.     
 Then you copy the background screen to the visual screen and repeat the      
 process.  This method is slow, but can be sped up by decreasing the number   
 of wputblocks you use as sprites, and make the area copied from one screen   
 to another smaller.                                                          
                                                                              
  *** PROJECT ***                                                             
  This program requires the file WGT5_WC.LIB to be linked.                    
                                                                              
  *** DATA FILES ***                                                          
  NONE                                                                        
                                                           WATCOM C++ VERSION 
==============================================================================
*/

#include <wgt5.h>


void main(void)
{
  block screen1;  /* one virtual screen */
  block circ[4];  /* and four circle images */
  short oldmode;
  short y;

  if ( !vgadetected () )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit (0);
  }
  printf ("WGT Example #18\n\n");
  printf ("This program will manipulate 4 bitmaps based on mouse movements.\n");
  printf ("It uses virtual screen buffers to produce smooth results. Press any mouse\n");
  printf ("button to end the demo.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  oldmode = wgetmode ();
  vga256 ();

  screen1 = wnewblock (0, 0, 319, 199);

  for (y = 0; y < 4; y++)
  {
    wsetcolor (40 + y * 5);
    wfill_circle (30, 30, 20 + y * 4);  /* draw a circle with a box cut out in middle */
    /* Note that the circle turns into a square when we increase the radius
       because I'm still grabbing the same area from the wnewblock... */

    wsetcolor (0);
    wbar (20, 20, 40, 40);
    circ[y] = wnewblock (10, 10, 50, 50);  /* get the sprite */
  }

  wsetscreen (screen1);
  minit ();

  do {
    for (y = 0; y < 200; y++)
    {
      wsetcolor (y);
      wline (0, y, 319, y);  /* clear the screen by drawing horz lines (fast) */
    }

    wputblock (mouse.mx, mouse.my, circ[0], 1);
    wputblock (279 - mouse.mx, mouse.my, circ[1], 1);
    wputblock (mouse.mx, 159 - mouse.my, circ[2], 1);
    wputblock (279 - mouse.mx, 159 - mouse.my, circ[3], 1);
    /* Put four blocks on the screen depending on where the mouse is. */
    /* The first one displayed is the one in the back. */

    wcopyscreen (0, 0, 319, 199, screen1, 0, 0, NULL);  
    /* copy the whole screen */
    /* notice how we never use wnormscreen at all! */

  } while (mouse.but == 0);
  mdeinit ();                   /* Deinitialize the mouse handler */

  wfreeblock (screen1);
  for (y = 0; y < 4; y ++)
    wfreeblock (circ[y]);
  wsetmode (oldmode);
}
