/*
==============================================================================
		      WordUp Graphics Toolkit Version 5.0                     
			     Demonstration Program 13                         
									      
 Demonstrates mouse noclick, mousehape, msetspeed, wsetthreshhold and wbutt.  
									      
 *** PROJECT ***                                                             
 This program requires the file WGT5_WC.LIB to be linked.                    
									      
 *** DATA FILES ***                                                          
 NONE                                                                        
							   WATCOM C++ VERSION 
==============================================================================
*/

#include <wgt5.h>

unsigned short wgtcursor[] = {
	0x3ff, 0x3ff, 0x7ff, 0x3ff, 0x1ff, 0x20ff,0xf07f,0xf8ff,
	0xfdff,0x1000,0x0,   0x0,   0x1,   0x1,   0x1,   0x1,
	0x0,   0x7800,0x7000,0x7800,0x5c00,0xe00 ,0x700, 0x200,
	0x0,   0x0,   0x45ce,0x4504,0x5564,0x5524,0x7de4,0x0     };

   /* This is the shape of the mouse cursor.  You can create
      source code for these with the sprite editor. */

void main(void)
{
  color palette[256];
  short i;
  short doneflag;               /* end of loop */
  short px, py, pbut;
  short oldmode;
  
  printf ("WGT Example #13\n\n");
  printf ("This program demonstrates a few of the WGT mouse commands.\n");
  printf ("Follow the onscreen instructions to complete the demo.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  if ( !vgadetected () )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit (0);
  }
  oldmode = wgetmode ();
  vga256 ();

  for (i = 1; i < 253; i++)
    wsetrgb (i, i + 30, i + 30, i, palette);  /* just something other
						 than black! */
  wsetrgb (253, 60, 60, 60, palette);
  wsetrgb (254, 50, 50, 50, palette);
  wsetrgb (255, 40, 40, 40, palette);
  wsetpalette (0, 255, palette);

  wcls (0);

  wbutt (1, 1, 319, 50);
  wbutt (1, 60, 319, 109);   /* Draw some 3D buttons */
  wbutt (1, 189, 319, 199);

  wtextcolor (253);
  wtexttransparent (TEXTFG);
  wouttextxy (30, 10, NULL, "This button doesn't use noclick()");
  wouttextxy (60, 70, NULL, "This button does!");
  wouttextxy (100, 191, NULL, "Click here to quit");

  minit ();
  msetbounds (0, 0, 319, 199);
  msetspeed (20, 5);                      /* make x slow and y real fast */
  msetthreshhold (10);
  mouseshape (0, 0, &wgtcursor);            /* 0,0 for hotspot */

  mon ();
  doneflag = 0;                           /* keep looping until flag is 1 */

  do {
    px = mouse.mx;
    py = mouse.my;
    pbut = mouse.but;

    if (pbut != 0)                       /* Mouse button was pressed */
    {
      if (py < 50)                        /* Top button ? */
      {
	sound (500);
	delay (30);
	nosound ();
      }
      else if ((py < 109) && (py > 60))      /* Middle button ? */
      {
	sound (500);
	delay (30);
	nosound ();
	noclick ();
      }
      else if (py > 189)
	doneflag = 1;                     /* You hit the quit button */
    }
  } while (!doneflag);
  minit (); /* Resets to arrow cursor */
  mdeinit ();                   /* Deinitialize the mouse handler */

  wsetmode (oldmode);
}
