#include <dos.h>
#include <conio.h>
#include <mem.h>
#include <stdlib.h>
/*
m
ͻ
             ۲ WordUp Graphics Toolkit V4.5               
         Source Code    Copyright 1995 Egerter Software          
Ķ
 Module:       wgtjoy.c                                          
 Contains:     wcheckjoystick, wreadjoystick, wcalibratejoystick,
               winitjoystick                                     
                                                                 
 Last Revised: May 23, 1996                                      
                                                                 
 Written by:   Barry and Chris Egerter   Real Mode version       
ͼ
*/

static struct {
  char patch_id[8];
  char fname[12];
  float version;
} patch_struct = {"WGTPATCH", "wgtjoy", 1.0} ;



typedef struct {
    short x, y;                   // coordinates
    short cenx, ceny;             // centre x and y
    short xrange, yrange;         // range +- the middle
    short port, buttons;          // port number, and button info
    short scale;                  // coordinate scaling
    } joystick;


int  joy_axis[4]; /* Array of axis values */
unsigned char joy_button;  /* Button values */


unsigned char wjoyread (int *axis, unsigned char *button)
{
unsigned char result;

 asm {
   push   ds
   les    di, axis    // make a pointer to the coordinate info
   mov    dx, 513     // game port
   cli
   out    dx, al      // start gameport timers
   mov    cx, 0ffffh  // maximum timeout
   mov    bl, 0fh     // start with all 4 pulses hi
  }
 waitloop:;
 asm {
   in     al, dx          // wait for change
   and    al, bl          // Get low nibble for pulses
   and    al, 15          // mask out unwanted axes
   cmp    al, bl          // Any changes?
   loopz  waitloop        // go and wait if no change
   cmp    cx, 0           // see if cx is zero
   jz     short timeout   // timeout..took too long
   xor    al, bl          // set bits with changes
   push   ax              // save changes for later
   push   cx              // save count for later
   dec    cx              // decrement timeout
   xor    bl, al          // update line status's
   jnz    waitloop        // not done yet, go back
   xor    dh, dh          // clear return code
   jmp    done            // Okay, all lines low...
  }
 timeout:;
 asm {
   in     al, dx          // get bit values
   mov    dh, al          // move to dh for return
   push   ax              // dump dummy values
   push   cx              //   onto stack
  }
 done:;
 asm {
   sti                    // turn on the ints
   mov    dl, 4          // decode change nibbles
  }
 decode:;
 asm {
   pop    bx             // get count off stack
   sub    bx, 0fffeh     // turn down count....
   neg    bx             //  into an up count
   pop    ax             // get first change info
   mov    cx, 4          // check four bits
  }
 decod1:;
 asm {
   shr    al, 1          // next bit set (changed?)
   jnc    short decod2
   mov    es:[di], bx       // store the count
   dec    dl
  }
 decod2:;
 asm {
   inc    di             // move di to next value
   inc    di
   loop   decod1
   sub    di, 8          // reset di to vector start
   or     dl, dl         // has it been 4 values?
   jnz    decode         // nope, keep going
   push   dx             // save return val on stack
   mov    dx, 513        // load game port io address
   les    di, button     // get pointer to button value
   in     al, dx         // done, get the buttons..
   xor    ah, ah         // kill the high byte
   xor    al, 0f0h       // be nice and flip the bits
   mov    cl, 4          // be nice and move the button
   shr    ax, cl         // bits into the low nibble
   mov    es:[di], al       // save button values

   pop    ax             // get return value off stack
   and    ax, 00f00h     // mask off garbage bits...
   xchg   al, ah         // be nice and flip things
   xor    ax, 0fh        //   around...
   mov    result, al
   pop    ds
  }
return result;
}





short wcheckjoystick (void)
/* See if a joystick is available */
{
unsigned char result;
short found;

  result = wjoyread (joy_axis, &joy_button);

  found = 0;
  if ((result & 1) && (result && 2))
    found += 1;
  if ((result & 4) && (result && 8))
    found += 2;


  /* any bits that changed state are now set */
  return found;
}


short wreadjoystick (joystick *joy1, joystick *joy2)
/* Read the joystick */
{
  wjoyread (joy_axis, &joy_button);

  joy1->buttons = (joy_button & 3);
  joy2->buttons = ((joy_button >> 2) & 30);

  if (joy1->port > 0)
    {
     /* Make sure we don't go past the range */
     joy_axis[0] -= joy1->cenx;
     joy_axis[1] -= joy1->ceny;

     if (joy_axis[0] < -joy1->xrange)
       joy_axis[0] = -joy1->xrange;
     else if (joy_axis[0] > joy1->xrange)
       joy_axis[0] = joy1->xrange;

     if (joy_axis[1] < -joy1->yrange)
       joy_axis[1] = -joy1->yrange;
     else if (joy_axis[1] > joy1->yrange)
       joy_axis[1] = joy1->yrange;

    joy1->x = ((long)joy1->scale * (long)joy_axis[0]) / (long)joy1->xrange;
    joy1->y = ((long)joy1->scale * (long)joy_axis[1]) / (long)joy1->yrange;
   }
  else
   {
    joy1->x = joy_axis[0];
    joy1->y = joy_axis[1];
   }


  if (joy2->port > 0)
    {
     joy_axis[2] -= joy2->cenx;
     joy_axis[3] -= joy2->ceny;

     /* Make sure we don't go past the range */
     if (joy_axis[2] < -joy2->xrange)
       joy_axis[2] = -joy2->xrange;
     else if (joy_axis[2] > joy2->xrange)
       joy_axis[2] = joy2->xrange;

     if (joy_axis[3] < -joy2->yrange)
       joy_axis[3] = -joy2->yrange;
     else if (joy_axis[3] > joy2->yrange)
       joy_axis[3] = joy2->yrange;

     joy2->x = ((long)joy2->scale * (long)joy_axis[2]) / (long)joy2->xrange;
     joy2->y = ((long)joy2->scale * (long)joy_axis[3]) / (long)joy2->yrange;
    }
  else
    {
     joy2->x = joy_axis[2];
     joy2->y = joy_axis[3];
    }

  return 1;
}


void winitjoystick (joystick *joy1, joystick *joy2)
/* Initializes the joystick. Joystick must be centered when this routine
   is called.  Sets the centre, range, and scale to default. */
{
  memset (joy1, 0, sizeof (joystick));
  memset (joy2, 0, sizeof (joystick));

  wreadjoystick (joy1, joy2);

  joy1->cenx = joy1->x;
  joy1->ceny = joy1->y;
  joy1->xrange = joy1->x;
  joy1->yrange = joy1->y;

  joy2->cenx = joy2->x;
  joy2->ceny = joy2->y;
  joy2->xrange = joy2->x;
  joy2->yrange = joy2->y;
}


short wcalibratejoystick (joystick *joy1, joystick *joy2)
/* Set up range properly for joystick */
{
short maxx1, maxy1, minx1, miny1;
short maxx2, maxy2, minx2, miny2;

  maxx1 = maxy1 = -10000;
  minx1 = miny1 = 10000;

  maxx2 = maxy2 = -10000;
  minx2 = miny2 = 10000;

  do {
    if (!wreadjoystick (joy1, joy2))
      return 0;

    gotoxy (1, 1);

    printf ("x1: %i  y1: %i\n", minx2, miny2);
    printf ("x2: %i  y2: %i\n", maxx2, maxy2);
    printf ("button %i\n", joy_button);

    printf ("x1: %i  y1: %i\n", joy_axis[0], joy_axis[1]);
    printf ("x2: %i  y2: %i\n", joy_axis[2], joy_axis[3]);
    printf ("button %i", joy_button);

    if (joy1->x > maxx1)
      maxx1 = joy1->x;
    if (joy1->y > maxy1)
      maxy1 = joy1->y;
    if (joy1->x < minx1)
      minx1 = joy1->x;
    if (joy1->y < miny1)
      miny1 = joy1->y;

    if (joy2->x > maxx2)
      maxx2 = joy2->x;
    if (joy2->y > maxy2)
      maxy2 = joy2->y;
    if (joy2->x < minx2)
      minx2 = joy2->x;
    if (joy2->y < miny2)
      miny2 = joy2->y;
   } while ((joy1->buttons == 0) && (joy2->buttons == 0) && (!kbhit ()));

  joy1->xrange = (maxx1 - minx1) / 2;
  joy1->yrange = (maxy1 - miny1) / 2;
  joy1->cenx = minx1 + joy1->xrange;
  joy1->ceny = miny1 + joy1->yrange;

  if (joy1->xrange == 0)
    joy1->xrange = 1;
  if (joy1->yrange == 0)
    joy1->yrange = 1;

  joy2->xrange = (maxx2 - minx2) / 2;
  joy2->yrange = (maxy2 - miny2) / 2;
  joy2->cenx = minx2 + joy2->xrange;
  joy2->ceny = miny2 + joy2->yrange;

  if (joy2->xrange == 0)
    joy2->xrange = 1;
  if (joy2->yrange == 0)
    joy2->yrange = 1;

  joy1->scale = 100;
  joy2->scale = 100;

  do {
    if (!wreadjoystick (joy1, joy2))
      return 0;
  } while (((joy1->buttons) || (joy2->buttons)) && (!kbhit ()));

  joy1->port = 1;
  joy2->port = 2;

  if (kbhit ())
    {
     getch ();
     return (0);
    }
  return 1;
}

