/*
ͻ
                     WordUp Graphics Toolkit Version 4.5                    
                            Demonstration Program 27                        
                                                                            
 Draws some circles, captures a block, and skews the block while rotating   
 the colors.                                                                
                                                                            
  PROJECT                                                             
 This program requires the file WGT45.LIB to be linked.          	     
                                                                            
  DATA FILES                                                          
 NONE                                                                       
                                                                            
ͼ
*/

#include <conio.h>
#include <wgt45.h>


void main(void)
{
block skewit;			/* Pointer to our block */
color palette[256];		/* Our palette */
int oldmode;			/* Store initial video mode */
int i = 0;			/* Loop counter */

  printf ("WGT Example #27\n\n");
  printf ("A bitmap is skewed left and right while the palette is rotated.\n");
  printf ("Press a key to end the program at any time.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  if (!vgadetected ())
    {
     printf ("Error - VGA card required for any WGT program.\n");
     exit (0);
    }

  oldmode = wgetmode ();	/* Gets the current mode */
  vga256 ();			/* Initialize graphics mode */

  wreadpalette (0, 255, palette); /* Store our current palette */

  wcls (0);			/* Clear screen with black */

  for (i = 100; i > 0; i--)	/* Draw 100 filled circles */
    {
     wsetcolor (i);
     wfill_circle (160, 100, i);
    }

  wsetcolor (0);            	/* Use black as active color */
  wbar (0, 0, 104, 199);	/* Draw two solid rectangles */
  wbar (216, 0, 319, 199);
  skewit=wnewblock (100, 40, 220, 160);	/* Grab a block for skewing */

  wcls (0);				/* Clear screen with black */
  do {
    for (i = -100; i < 100; i += 2)   	/* Skew image 2 pixels at a time */
      {
       wskew (100, 40, skewit, i);
       wcolrotate (1, 100, 0, palette);	/* Rotate palette too */
       wsetpalette (1, 100, palette);	/* And show palette changes */
      }

    for (i = 100; i > -100; i -= 2)	/* Skew image back to starting pos */
      {
       wskew (100, 40, skewit, i);
       wcolrotate (1, 100, 0, palette);	/* Rotate palette */
       wsetpalette (1, 100, palette);	/* Show palette changes */
      }
   } while (!kbhit ());			/* Stop when key is pressed */

  getch ();
  wsetmode (oldmode);		/* Restore initial video mode */
}